/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class UserCustomChart
extends TimelineChart {
    private ArrayList<DAChartSeries> tempSeriesList;
    private boolean[] usedColor;

    public UserCustomChart(int chartType, String chartName) {
        super(TimelinePage.pageID);
        this.chartType = chartType;
        this.chartName = chartName;
        this.chartIcon = ImageResources.CHART_CUSTOM;
        this.addIcon = ImageResources.CHART_CUSTOM;
        this.tempSeriesList = new ArrayList();
        this.usedColor = new boolean[11];
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        List seriesList = null;
        if (this.chart != null) {
            seriesList = this.chart.getSeriesList();
        }
        DAChartBoardItem item = super.createBoardItem(board);
        if (seriesList != null) {
            for (DAChartSeries series : seriesList) {
                this.chart.addSeries(series);
            }
        }
        return item;
    }

    public void addSeries(DAChartSeries series) {
        this.chart.addSeries(series);
    }

    public void addTempSeries(DAChartSeries series, int colorIndex) {
        this.tempSeriesList.add(series);
        this.usedColor[colorIndex] = true;
    }

    public ArrayList<DAChartSeries> getTempSeries() {
        return this.tempSeriesList;
    }

    public int getSeriesNum() {
        return this.chart.getSeriesList().size();
    }

    @Override
    public List<DAChartSeries> getBaseDASeriesList() {
        if (this.chart != null) {
            return this.chart.getSeriesList();
        }
        return null;
    }

    @Override
    public DAChart getChart() {
        return this.chart;
    }

    public int getUnusedColorIndex() {
        int i = 1;
        while (i < this.usedColor.length) {
            boolean status = this.usedColor[i];
            if (!status) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

