/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.tooltip;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.FontResources;

public abstract class DACustomTooltip {
    public static final int TOOLTIP_HEIGHT_MARGIN = 10;
    public static final int TOOLTIP_WIDTH_MARGIN = 10;
    public static final int TOOLTIP_HEIGHT = 18;
    public static final int TOOLTIP_TEXT_HEIGHT = 10;
    public static final int TOOLTIP_TEXT_MARGIN = 8;
    public static final int TOOLTIP_LOCATION_LEFT = 10;
    public static final int TOOLTIP_LOCATION_TOP = 20;
    private int height = 0;
    private int width = 0;
    private Color backgroundColor = ColorResources.FEATURELIST_TOOLTIP_BACKGROUND;
    private Color strokeColor = ColorResources.FEATURELIST_TOOLTIP_LINE;
    private Color fontColor = ColorResources.FEATURELIST_TOOLTIP_TEXT;
    private Font font = FontResources.TIMELINE_FONT;
    protected Shell parent = null;
    protected Shell tooltipShell = null;
    protected Canvas tooltipCanvas = null;
    protected String selectedItem = null;
    protected List<String> tooltipMessage = new ArrayList<String>();
    protected boolean hidden = false;
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }
    };

    public void openAndMove(Shell parent) {
        if (!this.tooltipMessage.isEmpty() && !this.hidden) {
            if (this.tooltipShell == null) {
                this.open(parent);
            } else {
                this.move();
            }
        } else {
            this.close();
        }
    }

    public void open(Shell parent) {
        if (this.tooltipShell != null && !this.tooltipShell.isDisposed()) {
            return;
        }
        this.tooltipShell = new Shell(parent, 540684);
        this.parent = parent;
        this.setTooltipShellSizeAndLocation();
        this.tooltipShell.setLayout((Layout)new FillLayout());
        this.tooltipCanvas = new Canvas((Composite)this.tooltipShell, 0x60000000);
        this.tooltipCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DACustomTooltip.this.drawTooltip(e.gc);
            }
        });
        this.tooltipCanvas.addKeyListener(this.keyListener);
        this.tooltipShell.open();
    }

    public void move() {
        if (this.tooltipShell != null && !this.tooltipShell.isDisposed()) {
            this.setTooltipShellSizeAndLocation();
        }
    }

    public void close() {
        if (this.tooltipShell != null && !this.tooltipShell.isDisposed()) {
            this.tooltipShell.close();
            this.tooltipShell.dispose();
            this.tooltipShell = null;
        }
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    public void setSeletedItem(String selectedItem) {
        this.selectedItem = selectedItem;
        if (selectedItem != null) {
            this.setTooltipMessage();
        } else {
            this.tooltipMessage.clear();
        }
    }

    private void drawTooltip(GC gc) {
        Rectangle rect = this.tooltipCanvas.getClientArea();
        gc.setAlpha(150);
        gc.setBackground(this.backgroundColor);
        gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
        gc.setAlpha(255);
        gc.setForeground(this.strokeColor);
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        gc.setForeground(this.fontColor);
        gc.setFont(this.font);
        int i = 0;
        while (i < this.tooltipMessage.size()) {
            gc.drawText(this.tooltipMessage.get(i), 10, 10 + 18 * i, 3);
            ++i;
        }
    }

    private void setTooltipShellSizeAndLocation() {
        this.generateTooltipSize();
        Point p = Display.getCurrent().getCursorLocation();
        this.tooltipShell.setSize(this.width, this.height);
        this.tooltipShell.setLocation(p.x + 10, p.y + 20);
    }

    public void setTooltipLocation(Point p, int top, int left) {
        this.generateTooltipSize();
        this.tooltipShell.setSize(this.width, this.height);
        this.tooltipShell.setLocation(p.x + left, p.y + top);
        this.tooltipShell.setVisible(true);
    }

    private void generateTooltipSize() {
        if (!this.tooltipMessage.isEmpty()) {
            this.height = this.tooltipMessage.size() * 10 + (this.tooltipMessage.size() - 1) * 8 + 20;
            GC gc = new GC((Drawable)this.parent.getDisplay(), 0);
            gc.setFont(this.font);
            int max = 0;
            int i = 0;
            while (i < this.tooltipMessage.size()) {
                Point p = gc.textExtent(this.tooltipMessage.get(i), 8);
                if (p.x > max) {
                    max = p.x;
                }
                ++i;
            }
            this.width = max + 20;
            gc.dispose();
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public abstract void setTooltipMessage();

    public abstract void setTooltipMessage(String var1);
}

