/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.info;

import java.io.File;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObject;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;

public class HierarchyTreeNodeInfoScreenshotFigure
extends Shape {
    private static final int MAX_IMAGE_WIDTH = 168;
    private static final int MAX_IMAGE_HEIGHT = 168;
    private static final int MIN_IMAGE_HEIGHT = 87;
    private static final int STATUS_TEXT_HEIGHT = 34;
    private static final int STATUS_IMAGE_SIZE = 30;
    private static final int STATUS_IMAGE_BOTTOM_MARGIN = 23;
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 300;
    private HierarchyUIObject uiObject;
    private boolean isHover;

    public HierarchyTreeNodeInfoScreenshotFigure(HierarchyUIObject uiObject) {
        this.uiObject = uiObject;
        this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                HierarchyTreeNodeInfoScreenshotFigure.this.isHover = true;
                HierarchyTreeNodeInfoScreenshotFigure.this.repaint();
            }

            public void mouseExited(MouseEvent me) {
                HierarchyTreeNodeInfoScreenshotFigure.this.isHover = false;
                HierarchyTreeNodeInfoScreenshotFigure.this.repaint();
            }
        });
        this.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mouseReleased(MouseEvent me) {
                HierarchyTreeNodeInfoScreenshotFigure.this.showExpandImage();
            }
        });
    }

    protected void fillShape(Graphics gc) {
        int imageBoxHeight = this.getImageBoxHeight();
        if (this.uiObject.getStatus() == HierarchyUIObject.STATUS.OK) {
            Dimension imageSize = this.getAdjustedImageSize();
            int imageWidth = imageSize.width;
            int imageHeight = imageSize.height;
            String imagePath = this.uiObject.getImageFilePath();
            int drawX = 0;
            int drawY = 0;
            if (imagePath != null) {
                Image image = new Image((Device)Display.getDefault(), imagePath);
                Rectangle imageBounds = image.getBounds();
                drawX = this.bounds.x + (this.bounds.width - imageWidth) / 2;
                drawY = this.bounds.y + (imageBoxHeight - imageHeight) / 2;
                gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, drawX, drawY, imageWidth, imageHeight);
                if (this.isHover) {
                    Image icon = ImageResources.EXPAND_SCREENSHOT_HOVER;
                    Rectangle iconBounds = icon.getBounds();
                    int iconX = this.getBounds().x + (this.getBounds().width - iconBounds.width) / 2;
                    int iconY = this.getBounds().y + (this.getBounds().height - iconBounds.height) / 2;
                    gc.drawImage(icon, iconX, iconY);
                }
            }
        } else {
            FontData[] fontData = FontResources.UIHIERARCHY_TREE_NODE_INFO_NAME_FONT.getFontData();
            int i = 0;
            while (i < fontData.length) {
                fontData[i].setHeight(fontData[i].getHeight());
                ++i;
            }
            Font font = new Font((Device)Display.getCurrent(), fontData);
            gc.setFont(font);
            gc.setForegroundColor(ColorResources.TREEVIEW_NODE_INFO_ERROR);
            String statusText = this.uiObject.getStatusMsg();
            Dimension textExtent = TextUtilities.INSTANCE.getStringExtents(statusText, font);
            int drawX = this.bounds.x + (this.bounds.width - textExtent.width) / 2;
            int drawY = this.bounds.y + (34 - textExtent.height) / 2;
            gc.drawText(statusText, drawX, drawY);
            drawX = this.bounds.x + (this.bounds.width - 30) / 2;
            drawY = this.bounds.y + 34;
            gc.drawImage(ImageResources.NO_SCREENSHOT, drawX, drawY);
        }
    }

    protected void outlineShape(Graphics gc) {
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension imageSize = this.getAdjustedImageSize();
        imageSize.width = 168;
        imageSize.height = imageSize.height > 87 ? imageSize.height : 87;
        return imageSize;
    }

    private int getImageBoxHeight() {
        Dimension imageSize = this.getAdjustedImageSize();
        int height = imageSize.height > 87 ? imageSize.height : 87;
        return height;
    }

    private Dimension getAdjustedImageSize() {
        if (this.uiObject.getStatus() == HierarchyUIObject.STATUS.OK) {
            int[] geometry = this.uiObject.getGeometry();
            int imageWidth = geometry[2];
            int imageHeight = geometry[3];
            if (imageWidth > 168 || imageHeight > 168) {
                if (imageWidth > imageHeight) {
                    imageHeight = 168 * imageHeight / imageWidth;
                    imageWidth = 168;
                } else {
                    imageWidth = 168 * imageWidth / imageHeight;
                    imageHeight = 168;
                }
            }
            return new Dimension(imageWidth, imageHeight);
        }
        return new Dimension(168, 87);
    }

    private void showExpandImage() {
        String imagePath = this.uiObject.getImageFilePath();
        if (imagePath == null || !new File(imagePath).exists()) {
            return;
        }
        final Image image = new Image((Device)Display.getDefault(), imagePath);
        Shell parent = WorkbenchUtil.getWorkbenchWindow().getShell();
        Shell expandImageShell = new Shell(parent, 65600);
        final Rectangle imageBounds = image.getBounds();
        expandImageShell.getBorderWidth();
        int shellWidth = imageBounds.width > 300 ? imageBounds.width : 300;
        int shellHeight = imageBounds.height > 300 ? imageBounds.height : 300;
        expandImageShell.setLayout((Layout)new FillLayout());
        final Canvas canvas = new Canvas((Composite)expandImageShell, 0x20000000);
        canvas.setBackground(ColorResources.TREEVIEW_BG);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle area = canvas.getClientArea();
                int x = area.width > imageBounds.width ? (area.width - imageBounds.width) / 2 : 0;
                int y = area.height > imageBounds.height ? (area.height - imageBounds.height) / 2 : 0;
                int width = area.width > imageBounds.width ? imageBounds.width : area.width;
                int height = area.height > imageBounds.height ? imageBounds.height : area.height;
                e.gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, x, y, width, height);
            }
        });
        expandImageShell.setSize(shellWidth, shellHeight);
        expandImageShell.open();
    }
}

