/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.table.state;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.model.TableInput;
import org.tizen.dynamicanalyzer.ui.opengl.GLPage;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLSelectionData;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStatisticsDataType;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class GLStatisticsTable
extends DATableComposite {
    public GLStatisticsTable(Composite parent, int style, int tableStyle) {
        super(parent, style, tableStyle);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GridItem[] items = GLStatisticsTable.this.table.getSelection();
                if (items == null) {
                    return;
                }
                DATableDataFormat tableDataFormat = (DATableDataFormat)items[0].getData();
                GLDataManager.getInstance().setSelectedAPIAtTable((String)tableDataFormat.getData().get(0));
                GLSelectionData selData = new GLSelectionData(GLPage.statisticsViewID, 0L, 0L, items, (Control)GLStatisticsTable.this.table, 0, 0L);
                AnalyzerManager.getCurrentPage().updateView((DAViewData)selData);
                AnalyzerManager.updateView(GLPage.statisticsViewID, selData);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    protected List<TableInput> makeTableInput() {
        GLStatisticsDataType data;
        ArrayList<TableInput> input = new ArrayList<TableInput>();
        List<GLStatisticsDataType> dataList = GLDataManager.getInstance().getStatisticsDataManger().getStatisticsTableData();
        if (dataList == null) {
            return null;
        }
        int totalCallCount = 0;
        int size = dataList.size();
        double totlaElapsedTime = 0.0;
        int i = 0;
        while (i < size) {
            data = dataList.get(i);
            totlaElapsedTime += (double)data.getElapsedTime();
            ++i;
        }
        i = 0;
        while (i < size) {
            data = dataList.get(i);
            ArrayList<String> text = new ArrayList<String>();
            text.add(data.getAPIName());
            text.add(this.gerTimeRate(totlaElapsedTime, data.getElapsedTime()));
            text.add(Integer.toString(data.getCallCount()));
            text.add(data.getAPIType());
            DATableDataFormat tableData = new DATableDataFormat(i + 1);
            ArrayList<Object> compareData = new ArrayList<Object>();
            compareData.add(text.get(0));
            compareData.add(String.valueOf(data.getElapsedTime()));
            compareData.add(text.get(2));
            compareData.add(text.get(3));
            tableData.setData(compareData);
            TableInput tableInput = new TableInput();
            tableInput.setText(text);
            tableInput.setData(tableData);
            if (GLDataManager.getInstance().getSelectedAPIAtTable().equals(data.getAPIName())) {
                tableInput.setSecondSelection(true);
            }
            input.add(tableInput);
            totalCallCount += data.getCallCount();
            ++i;
        }
        input.add(this.makeTotalRowInfo(size, totalCallCount));
        return input;
    }

    private String gerTimeRate(double totalTime, double itemTime) {
        double rateTime = itemTime / totalTime * 100.0;
        return String.format("%.2f", rateTime);
    }

    private TableInput makeTotalRowInfo(int size, int totalCallCount) {
        ArrayList<String> text = new ArrayList<String>();
        text.add("Total (" + size + " items)");
        text.add("100");
        text.add(Integer.toString(totalCallCount));
        text.add("-");
        DATableDataFormat tableData = new DATableDataFormat(0L);
        ArrayList<Object> compareData = new ArrayList<Object>();
        compareData.add(text.get(0));
        compareData.add("100000000");
        compareData.add(text.get(2));
        compareData.add(text.get(3));
        tableData.setData(compareData);
        TableInput tableInput = new TableInput();
        tableInput.setText(text);
        tableInput.setData(tableData);
        return tableInput;
    }

    public void removeSelection() {
        this.table.removeAll();
        this.updateTable();
    }
}

