/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerUpdate;
import org.eclipse.ui.internal.views.markers.MarkerUpdateJob;
import org.eclipse.ui.internal.views.markers.Markers;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class IncrementUpdateJob
extends MarkerUpdateJob {
    private LinkedList<MarkerEntry> incrementEntryList = new LinkedList();
    private LinkedList<MarkerUpdate> updateQueue;

    public IncrementUpdateJob(CachedMarkerBuilder builder) {
        super(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(MarkerMessages.MarkerView_processUpdates, -1);
        boolean clean = this.isClean();
        if (clean) {
            this.clearEntries();
        }
        Collection<MarkerEntry> markerEntries = this.incrementalEntries();
        if (clean) {
            LinkedList<MarkerUpdate> queue;
            clean = !this.clean(markerEntries, monitor);
            LinkedList<MarkerUpdate> linkedList = queue = this.getUpdatesQueue();
            synchronized (linkedList) {
                queue.clear();
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!clean) {
            this.builder.registerTypesToListener();
            if (!this.processUpdates(monitor)) {
                return Status.CANCEL_STATUS;
            }
        }
        if (!this.processMarkerEntries(markerEntries, monitor)) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.updateIncrementalList(markerEntries);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.builder.getUpdateScheduler().scheduleUIUpdate(150L);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.builder.setBuilding(false);
        this.updateDone();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateIncrementalList(Collection<MarkerEntry> markerEntries) {
        Markers clone;
        markerEntries.clear();
        Markers markers = clone = this.builder.getMarkers();
        synchronized (markers) {
            clone = clone.getClone();
        }
        MarkerEntry[] entries = clone.getMarkerEntryArray();
        int i = 0;
        while (i < entries.length) {
            markerEntries.add(entries[i]);
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUpdates(IProgressMonitor monitor) {
        Collection<MarkerEntry> markerEntries = this.incrementalEntries();
        int addCount = 0;
        int removedCount = 0;
        int changedCount = 0;
        int size = 0;
        int newSize = 0;
        LinkedList<MarkerUpdate> queue = this.getUpdatesQueue();
        MarkerUpdate next = null;
        do {
            LinkedList<MarkerUpdate> linkedList = queue;
            synchronized (linkedList) {
                next = !queue.isEmpty() ? queue.removeFirst() : null;
            }
            if (monitor.isCanceled() || next == null) break;
            size = markerEntries.size();
            this.handleRemovedEntries(markerEntries, next.removed, monitor);
            newSize = markerEntries.size();
            removedCount += size - newSize;
            this.handleChangedEntries(markerEntries, next.changed, monitor);
            changedCount += next.changed.size();
            size = newSize;
            this.handleAddedEntries(markerEntries, next.added, monitor);
            newSize = markerEntries.size();
            removedCount += newSize - size;
        } while (next != null);
        boolean[] changeFlags = new boolean[]{addCount > 0, removedCount > 0, changedCount > 0};
        int i = 0;
        while (i < changeFlags.length) {
            if (changeFlags[i]) {
                this.builder.updateChangeFlags(changeFlags);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void handleAddedEntries(Collection<MarkerEntry> markerEntries, Collection<MarkerEntry> added, IProgressMonitor monitor) {
        MarkerContentGenerator generator = this.builder.getGenerator();
        for (MarkerEntry entry : added) {
            if (!generator.select(entry)) continue;
            markerEntries.add(entry);
        }
    }

    private void handleChangedEntries(Collection<MarkerEntry> markerEntries, Collection<MarkerEntry> changed, IProgressMonitor monitor) {
        MarkerContentGenerator generator = this.builder.getGenerator();
        Iterator<MarkerEntry> iterator = changed.iterator();
        while (iterator.hasNext()) {
            MarkerEntry entry = iterator.next();
            Iterator<MarkerEntry> iterator2 = markerEntries.iterator();
            while (iterator2.hasNext()) {
                MarkerEntry oldEntry = iterator2.next();
                if (!oldEntry.getMarker().equals((Object)entry.getMarker())) continue;
                iterator2.remove();
            }
            if (generator.select(entry)) continue;
            iterator.remove();
        }
        markerEntries.addAll(changed);
    }

    private void handleRemovedEntries(Collection<MarkerEntry> markerEntries, Collection<MarkerEntry> removed, IProgressMonitor monitor) {
        MarkerEntry entry;
        boolean found = false;
        Iterator<MarkerEntry> iterator = markerEntries.iterator();
        block0: while (iterator.hasNext()) {
            entry = iterator.next();
            found = entry.getStaleState();
            if (found) {
                iterator.remove();
            }
            if (removed.isEmpty()) continue;
            Iterator<MarkerEntry> iterator2 = removed.iterator();
            while (iterator2.hasNext()) {
                MarkerEntry stale = iterator2.next();
                if (!stale.getMarker().equals((Object)entry.getMarker())) continue;
                iterator2.remove();
                if (found) continue block0;
                iterator.remove();
                continue block0;
            }
        }
        if (removed.isEmpty()) {
            return;
        }
        iterator = markerEntries.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.getMarker() == null || entry.getMarker().exists()) continue;
            iterator.remove();
        }
    }

    void clearEntries() {
        this.incrementEntryList = new LinkedList();
    }

    Collection<MarkerEntry> incrementalEntries() {
        return this.incrementEntryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedList<MarkerUpdate> getUpdatesQueue() {
        Object object = this.builder.MARKER_INCREMENTAL_UPDATE_FAMILY;
        synchronized (object) {
            if (this.updateQueue == null) {
                this.updateQueue = new LinkedList();
            }
            return this.updateQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUpdate(MarkerUpdate update) {
        LinkedList<MarkerUpdate> updateList;
        LinkedList<MarkerUpdate> linkedList = updateList = this.getUpdatesQueue();
        synchronized (linkedList) {
            updateList.addLast(update);
        }
    }

    @Override
    public boolean belongsTo(Object family) {
        if (family.equals(this.builder.MARKER_INCREMENTAL_UPDATE_FAMILY)) {
            return true;
        }
        return super.belongsTo(family);
    }
}

