/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.tizen.sdblib.daemon.AbstractServer;
import org.tizen.sdblib.daemon.ServerState;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.Log;

public class StreamGobbler
extends AbstractServer {
    protected OutputStream os;
    protected StringBuffer buffer = new StringBuffer();
    protected BufferedReader br;

    public StreamGobbler(InputStream is) {
        this(is, null);
    }

    public StreamGobbler(InputStream is, OutputStream os) {
        this(null, is, os);
    }

    public StreamGobbler(String name, InputStream is, OutputStream os) {
        super(name);
        this.br = new BufferedReader(new InputStreamReader(is));
        this.os = os;
    }

    public String getResult() {
        return this.buffer.toString();
    }

    @Override
    public void process() {
        try {
            int ch = this.br.read();
            if (ch == -1) {
                this.setStatus(ServerState.Halting);
                return;
            }
            this.buffer.append((char)ch);
            if (this.os != null) {
                this.os.write((char)ch);
            }
        }
        catch (IOException ioe) {
            Log.e("sdb", "failed to read stream:" + ioe);
        }
    }

    @Override
    protected void terminate() {
        IOUtil.tryClose(this.br);
    }
}

