/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.graph.bar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.widgets.graph.bar.SingleBar;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;
import org.tizen.dynamicanalyzer.widgets.helper.Formatter;

public class FourBarGraph
extends Composite {
    public static int TYPE_BYTE = 1;
    public static int TYPE_PERCENT = 0;
    private String measure = Formatter.toByteFormatMeasure(0L);
    private String labelText = "";
    private static final int INNER_MARGIN = 3;
    private static final int LABEL_MARGIN = 15;
    private int graphCount = 4;
    private int graphWidth = 16;
    private int graphType = TYPE_PERCENT;
    private List<SingleBar> graphs;
    private Label label;
    private Font labelFont;
    private Label emptyLabel;
    private Color fontColor = ColorResources.WHITE;
    private FourBarGraph me;
    private Color bgColor = ColorResources.BLACK;
    ControlListener controlListener = new ControlListener(){

        public void controlResized(ControlEvent e) {
            Rectangle r = FourBarGraph.this.me.getClientArea();
            int leftMargin = (r.width - (FourBarGraph.this.graphCount * FourBarGraph.this.graphWidth + (FourBarGraph.this.graphCount - 1) * 3)) / 2;
            int i = 0;
            while (i < FourBarGraph.this.graphCount) {
                SingleBar bar = (SingleBar)((Object)FourBarGraph.this.graphs.get(i));
                FormData data = new FormData();
                data.top = new FormAttachment(0, 0);
                data.left = i == 0 ? new FormAttachment(0, leftMargin) : new FormAttachment((Control)FourBarGraph.this.graphs.get(i - 1), 3);
                data.width = FourBarGraph.this.graphWidth;
                data.bottom = new FormAttachment(100, -15);
                bar.setLayoutData(data);
                FourBarGraph.this.graphs.add(bar);
                ++i;
            }
            FormData data = new FormData();
            data.top = new FormAttachment((Control)FourBarGraph.this.graphs.get(0), 0);
            data.height = 3;
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            FourBarGraph.this.emptyLabel.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)FourBarGraph.this.emptyLabel, 0);
            data.height = 15;
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            FourBarGraph.this.label.setLayoutData((Object)data);
        }

        public void controlMoved(ControlEvent e) {
        }
    };

    public FourBarGraph(Composite parent, int style, int type) {
        super(parent, style);
        this.graphType = type;
        this.me = this;
        this.graphs = new ArrayList<SingleBar>();
        this.labelFont = this.getShell().getDisplay().getSystemFont();
        this.setLayout((Layout)new FormLayout());
        this.setBackground(this.bgColor);
        this.addControlListener(this.controlListener);
        int i = 0;
        while (i < this.graphCount) {
            SingleBar bar = new SingleBar(this.me, 0, this.graphType);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.left = i == 0 ? new FormAttachment(0, 3) : new FormAttachment((Control)this.graphs.get(i - 1), 3);
            data.bottom = new FormAttachment(100, -15);
            bar.setLayoutData(data);
            this.graphs.add(bar);
            ++i;
        }
        this.emptyLabel = new Label((Composite)this.me, 0x40000000);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.graphs.get(0), 0);
        data.height = 3;
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.emptyLabel.setLayoutData((Object)data);
        this.emptyLabel.setBackground(this.bgColor);
        this.label = new Label((Composite)this.me, 0x40000000);
        data = new FormData();
        data.top = new FormAttachment((Control)this.emptyLabel, 0);
        data.height = 15;
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.label.setLayoutData((Object)data);
        this.label.setFont(this.labelFont);
        this.label.setAlignment(0x1000000);
        this.label.setForeground(this.fontColor);
        this.label.setBackground(this.bgColor);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.label.setFont(font);
        this.labelFont = font;
    }

    public void setGraphColor(Color graph, Color gray, Color font) {
        int i = 0;
        while (i < this.graphs.size()) {
            this.graphs.get(i).setColors(graph, this.bgColor, gray, font);
            ++i;
        }
    }

    public void setGraphBgColor(Color bg) {
        int i = 0;
        while (i < this.graphs.size()) {
            this.graphs.get(i).setBgColor(bg);
            ++i;
        }
    }

    public void setMaxSize(long max) {
        int i = 0;
        while (i < this.graphs.size()) {
            this.graphs.get(i).setMaxSize(max);
            ++i;
        }
    }

    public void setMaxSize(List<Long> maxSizes) {
        int i = 0;
        while (i < maxSizes.size() && i < this.graphCount) {
            this.graphs.get(i).setMaxSize(maxSizes.get(i));
            ++i;
        }
    }

    public void setCurrentValue(List<Long> currentValues) {
        int i = 0;
        while (i < currentValues.size() && i < this.graphCount) {
            if (this.graphType == TYPE_BYTE) {
                long value = currentValues.get(i);
                this.measure = Formatter.toByteFormatMeasure(value);
                this.setText(this.labelText);
            }
            this.graphs.get(i).setCurrentSize(currentValues.get(i));
            this.graphs.get(i).redraw();
            ++i;
        }
    }

    public void setText(String text) {
        this.labelText = text;
        this.label.setForeground(this.fontColor);
        text = this.graphType == TYPE_BYTE ? String.valueOf(text) + " (" + this.measure + ")" : String.valueOf(text) + " (%)";
        this.label.setText(text);
    }

    public void setTextColor(Color color) {
        this.label.setForeground(color);
        this.fontColor = color;
    }

    public void setTextBgColor(Color color) {
        this.emptyLabel.setBackground(color);
        this.label.setBackground(color);
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
        this.setBackground(this.bgColor);
        this.setGraphBgColor(this.bgColor);
    }

    public void setGraphFont(Font font) {
        int size = this.graphs.size();
        int i = 0;
        while (i < size) {
            this.graphs.get(i).setFont(font);
            ++i;
        }
    }

    public void setGraphwidth(int graphWidth) {
        this.graphWidth = graphWidth;
    }

    public void clear() {
        int i = 0;
        while (i < this.graphs.size()) {
            this.graphs.get(i).setCurrentSize(0L);
            this.graphs.get(i).redraw();
            ++i;
        }
    }
}

