/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmWinProperties
extends HierarchyUIObjectProperties {
    private boolean iconified;
    private boolean maximized;
    private boolean modal;
    private String iconName;
    private boolean withdrawn;
    private String role;
    private int[] sizeStep = new int[2];
    private String focusHighlightStyle;
    private boolean borderless;
    private boolean focusHighlightEnabled;
    private String title;
    private boolean alpha;
    private boolean urgent;
    private int rotation;
    private boolean sticky;
    private boolean focusHighlightAnimate;
    private double aspect;
    private String indicatorOpacity;
    private boolean demandAttention;
    private int layer;
    private String profile;
    private boolean shaped;
    private boolean fullscreen;
    private String indicatorMode;
    private boolean conformant;
    private int[] sizeBase = new int[2];
    private boolean quickPanel;
    private boolean rotationSupported;
    private int[] screenDpi = new int[2];
    private String type;

    public ElmWinProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.iconified = parser.getBoolean();
        this.maximized = parser.getBoolean();
        this.modal = parser.getBoolean();
        this.iconName = parser.getString();
        this.withdrawn = parser.getBoolean();
        this.role = parser.getString();
        this.sizeStep[0] = parser.getInt();
        this.sizeStep[1] = parser.getInt();
        this.focusHighlightStyle = parser.getString();
        this.borderless = parser.getBoolean();
        this.focusHighlightEnabled = parser.getBoolean();
        this.title = parser.getString();
        this.alpha = parser.getBoolean();
        this.urgent = parser.getBoolean();
        this.rotation = parser.getInt();
        this.sticky = parser.getBoolean();
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            this.focusHighlightAnimate = parser.getBoolean();
        }
        this.aspect = parser.getFloat();
        this.indicatorOpacity = this.getIndicatorOpacityMessage(parser.getChar());
        this.demandAttention = parser.getBoolean();
        this.layer = parser.getInt();
        this.profile = parser.getString();
        this.shaped = parser.getBoolean();
        this.fullscreen = parser.getBoolean();
        this.indicatorMode = this.getIndicatorMode(parser.getChar());
        this.conformant = parser.getBoolean();
        this.sizeBase[0] = parser.getInt();
        this.sizeBase[1] = parser.getInt();
        this.quickPanel = parser.getBoolean();
        this.rotationSupported = parser.getBoolean();
        this.screenDpi[0] = parser.getInt();
        this.screenDpi[1] = parser.getInt();
        this.type = this.getTypeMode(parser.getChar());
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("type", this.type));
        properties.add(new PropertyValue("title", this.title));
        properties.add(new PropertyValue("modal", Boolean.toString(this.modal)));
        properties.add(new PropertyValue("alpha", Boolean.toString(this.alpha)));
        properties.add(new PropertyValue("maximized", Boolean.toString(this.maximized)));
        properties.add(new PropertyValue("iconified", Boolean.toString(this.iconified)));
        properties.add(new PropertyValue("iconName", this.iconName));
        properties.add(new PropertyValue("withdrawn", Boolean.toString(this.withdrawn)));
        properties.add(new PropertyValue("role", this.role));
        properties.add(new PropertyValue("sizeStep", "[" + this.sizeStep[0] + ", " + this.sizeStep[1] + "]"));
        properties.add(new PropertyValue("sizeBase", "[" + this.sizeBase[0] + ", " + this.sizeBase[1] + "]"));
        properties.add(new PropertyValue("borderless", Boolean.toString(this.borderless)));
        properties.add(new PropertyValue("focusHighlightStyle", this.focusHighlightStyle));
        properties.add(new PropertyValue("focusHighlightEnabled", Boolean.toString(this.focusHighlightEnabled)));
        if (this.protocolVersion != Protocol.VERSION_30_UIHV) {
            properties.add(new PropertyValue("focusHighlightAnimate", Boolean.toString(this.focusHighlightAnimate)));
        }
        properties.add(new PropertyValue("urgent", Boolean.toString(this.urgent)));
        properties.add(new PropertyValue("rotation", Integer.toString(this.rotation)));
        properties.add(new PropertyValue("sticky", Boolean.toString(this.sticky)));
        properties.add(new PropertyValue("aspect", Double.toString(this.aspect)));
        properties.add(new PropertyValue("indicatorMode", this.indicatorMode));
        properties.add(new PropertyValue("indicatorOpacity", this.indicatorOpacity));
        properties.add(new PropertyValue("demandAttention", Boolean.toString(this.demandAttention)));
        properties.add(new PropertyValue("layer", Integer.toString(this.layer)));
        properties.add(new PropertyValue("profile", this.profile));
        properties.add(new PropertyValue("shaped", Boolean.toString(this.shaped)));
        properties.add(new PropertyValue("fullscreen", Boolean.toString(this.fullscreen)));
        properties.add(new PropertyValue("quickPanel", Boolean.toString(this.quickPanel)));
        properties.add(new PropertyValue("rotationSupported", Boolean.toString(this.rotationSupported)));
        properties.add(new PropertyValue("screenDpi", "[" + this.screenDpi[0] + ", " + this.screenDpi[1] + "]"));
        return properties;
    }

    private String getIndicatorOpacityMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_WIN_INDICATOR_OPACITY_UNKNOWN";
            }
            case 1: {
                return "ELM_WIN_INDICATOR_OPAQUE";
            }
            case 2: {
                return "ELM_WIN_INDICATOR_TRANSLUCENT";
            }
            case 3: {
                return "ELM_WIN_INDICATOR_TRANSPARENT";
            }
            case 4: {
                return "ELM_WIN_INDICATOR_BG_TRANSPARENT";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getIndicatorMode(int code) {
        switch (code) {
            case 0: {
                return "ELM_WIN_INDICATOR_UNKNOWN";
            }
            case 1: {
                return "ELM_WIN_INDICATOR_HIDE";
            }
            case 2: {
                return "ELM_WIN_INDICATOR_SHOW";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }

    private String getTypeMode(int code) {
        switch (code) {
            case 0: {
                return "ELM_WIN_UNKNOWN";
            }
            case 1: {
                return "ELM_WIN_BASIC";
            }
            case 2: {
                return "ELM_WIN_DIALOG_BASIC";
            }
            case 3: {
                return "ELM_WIN_DESKTOP";
            }
            case 4: {
                return "ELM_WIN_DOCK";
            }
            case 5: {
                return "ELM_WIN_TOOLBAR";
            }
            case 6: {
                return "ELM_WIN_MENU";
            }
            case 7: {
                return "ELM_WIN_UTILITY";
            }
            case 8: {
                return "ELM_WIN_SPLASH";
            }
            case 9: {
                return "ELM_WIN_DROPDOWN_MENU";
            }
            case 10: {
                return "ELM_WIN_POPUP_MENU";
            }
            case 11: {
                return "ELM_WIN_TOOLTIP";
            }
            case 12: {
                return "ELM_WIN_NOTIFICATION";
            }
            case 13: {
                return "ELM_WIN_COMBO";
            }
            case 14: {
                return "ELM_WIN_DND";
            }
            case 15: {
                return "ELM_WIN_INLINED_IMAGE";
            }
            case 16: {
                return "ELM_WIN_SOCKET_IMAGE";
            }
            case 17: {
                return "ELM_WIN_TIZEN_WIDGET";
            }
            case 18: {
                return "ELM_WIN_FAKE";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

