/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.model.TreeInput;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObject;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.UIObjectCategoryCode;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableDataFormat;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATreeComposite;

public class HierarchyPropertiesTable
extends DATreeComposite {
    private HierarchyUIObject uiObject = null;

    public HierarchyPropertiesTable(Composite parent, int compStyle, int tableStyle) {
        super(parent, compStyle, tableStyle);
    }

    public void setUIObject(HierarchyUIObject uiObject) {
        this.uiObject = uiObject;
    }

    @Override
    public List<TreeInput> makeTreeInput() {
        if (this.uiObject == null) {
            return null;
        }
        long key = 0L;
        ArrayList<TreeInput> output = new ArrayList<TreeInput>();
        List<PropertyValue> uiObjectInfos = this.uiObject.getUIObjectInfos();
        List<PropertyValue> evasProperties = this.uiObject.getEvasPropertiesValue();
        List<PropertyValue> elementaryProperties = this.uiObject.getElementaryPropertiesValue();
        List<PropertyValue> edjeProperties = this.uiObject.getEdjePropertiesValue();
        List<PropertyValue> specificProperties = this.uiObject.getSpecificPropertiesValue();
        if (uiObjectInfos != null) {
            key = this.addTableData(output, uiObjectInfos, key);
        }
        if (evasProperties != null) {
            key = this.addTableData(output, evasProperties, UIObjectCategoryCode.EVAS.name(), key);
        }
        if (elementaryProperties != null) {
            key = this.addTableData(output, elementaryProperties, UIObjectCategoryCode.ELEMENTARY.name(), key);
        }
        if (edjeProperties != null) {
            key = this.addTableData(output, edjeProperties, UIObjectCategoryCode.EDJE.name(), key);
        }
        if (specificProperties != null) {
            key = this.addTableData(output, specificProperties, this.uiObject.getTypeName(), key);
        }
        return output;
    }

    private long addTableData(List<TreeInput> output, List<PropertyValue> values, long key) {
        int i = 0;
        while (i < values.size()) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(values.get((int)i).propertyName);
            text.add(values.get((int)i).propertyValue);
            DATableDataFormat tableData = new DATableDataFormat(key++);
            tableData.setObject(values.get((int)i).propertyName);
            TreeInput tableInput = new TreeInput();
            tableInput.setText(text);
            tableInput.setData(tableData);
            output.add(tableInput);
            ++i;
        }
        return key;
    }

    private long addTableData(List<TreeInput> output, List<PropertyValue> values, String category, long key) {
        DATableDataFormat tableData = new DATableDataFormat(key++);
        tableData.setObject(category);
        TreeInput rootInput = new TreeInput();
        rootInput.setData(tableData);
        output.add(rootInput);
        return this.addTableData(rootInput.getChildren(), values, key);
    }
}

