/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleAttribute;
import org.tizen.dynamicanalyzer.widgets.scale.DAScaleDefaultRenderer;

public class HierarchyScaleRenderer
extends DAScaleDefaultRenderer {
    private static final String LEFT_TEXT = "0%";
    private static final String RIGHT_TEXT = "200%";
    private static final int MARGIN = 2;

    public void draw(GC gc, Canvas canvas, DAScaleAttribute attr) {
        if (attr.getLeftRect() != null) {
            Rectangle rect = canvas.getClientArea();
            gc.setForeground(ColorResources.ZOOM_BAR_TEXT);
            gc.setFont(FontResources.UIHIERARCHY_TOOLBAR_FONT);
            Point textSize = gc.textExtent(LEFT_TEXT);
            int textStart = attr.getLeftRect().x + attr.getLeftRect().width - textSize.x - 2;
            gc.drawText(LEFT_TEXT, textStart, attr.getLeftRect().y + attr.getLeftRect().height / 2);
            textSize = gc.textExtent(RIGHT_TEXT);
            textStart = attr.getRightRect().x + 2;
            gc.drawText(RIGHT_TEXT, textStart, attr.getRightRect().y + attr.getRightRect().height / 2);
            gc.drawImage(ImageResources.SCALE_CONTROL_BG, attr.getAreaRect().x, rect.y + (rect.height - ImageResources.SCALE_CONTROL_BG.getBounds().height) / 2);
            if (attr.getThumbImage() != null) {
                gc.drawImage(attr.getThumbImage(), attr.getThumbRect().x, attr.getThumbRect().y);
            } else {
                gc.setBackground(ColorResources.RED);
                gc.fillOval(attr.getThumbRect().x, attr.getThumbRect().y, attr.getThumbRect().width, attr.getThumbRect().height);
            }
        }
    }
}

