/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLContextDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLStateDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLContextNameEnum;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStateTextureType;
import org.tizen.dynamicanalyzer.util.Logger;

public class GLTextureStateDataMaker {
    private GLStateDataManager glStateDataManager = null;

    public GLTextureStateDataMaker(GLStateDataManager glStateDataManager) {
        this.glStateDataManager = glStateDataManager;
    }

    private GLStateDataManager getStateDataManager() {
        return this.glStateDataManager;
    }

    public void extractGLTextureAPIParameter(GLES20LogData logData) {
        block32: {
            GLContextDataManager curretnContextValue;
            String[] parameters;
            long contextId;
            String apiName;
            block37: {
                block36: {
                    block35: {
                        block34: {
                            String[] contextValues;
                            block33: {
                                if (!this.glStateDataManager.isNormalAPIStatusForExtractParameter(logData)) break block32;
                                apiName = logData.getApiName();
                                String parameter = logData.getArgs();
                                contextId = logData.getCurrentContextID();
                                parameters = parameter.split(", ");
                                contextValues = logData.getContextValue().trim().split(",");
                                curretnContextValue = this.getStateDataManager().getGLContextDataManager(contextId);
                                if (!apiName.equals("glActiveTexture")) break block33;
                                if (parameters.length != 1) {
                                    Logger.error((Object)("GL extract API parameter  : " + apiName));
                                    return;
                                }
                                this.getStateDataManager().updateStateAtCurrentContext(GLContextNameEnum.TEXTURE_ACTIVE.ordinal(), Integer.parseInt(parameters[0]));
                                break block32;
                            }
                            if (!apiName.equals("glGenTextures")) break block34;
                            if (parameters.length != 2) {
                                Logger.error((Object)("GL extract API parameter  : " + apiName));
                                return;
                            }
                            int i = 0;
                            while (i < Integer.parseInt(parameters[0])) {
                                curretnContextValue.textureList.add(new GLStateTextureType(Integer.parseInt(contextValues[i].trim()), contextId, logData.getSeq()));
                                ++i;
                            }
                            break block32;
                        }
                        if (!apiName.equals("glBindTexture")) break block35;
                        if (parameters.length != 2) {
                            Logger.error((Object)("GL extract API parameter  : " + apiName));
                            return;
                        }
                        int i = 0;
                        while (i < curretnContextValue.textureList.size()) {
                            if (this.isSameTextureType(curretnContextValue.textureList.get(i), parameters[1], contextId)) {
                                curretnContextValue.textureList.get(i).setType(Integer.parseInt(parameters[0].trim()));
                                break block32;
                            }
                            ++i;
                        }
                        break block32;
                    }
                    if (!apiName.equals("glDeleteTextures")) break block36;
                    if (parameters.length != 2) {
                        Logger.error((Object)("GL extract API parameter  : " + apiName));
                        return;
                    }
                    int i = 0;
                    while (i < Integer.parseInt(parameters[0])) {
                        int j = 0;
                        while (j < curretnContextValue.textureList.size()) {
                            if (this.isSameTextureType(curretnContextValue.textureList.get(j), parameters[0], contextId)) {
                                curretnContextValue.textureList.get(j).setType(Integer.parseInt(parameters[0].trim()));
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    break block32;
                }
                if (!apiName.equals("glTexParameterf") && !apiName.equals("glTexParameteri")) break block37;
                if (parameters.length != 3) {
                    Logger.error((Object)("GL extract API parameter  : " + apiName));
                    return;
                }
                int i = 0;
                while (i < curretnContextValue.textureList.size()) {
                    if (curretnContextValue.textureList.get(i).getContextID() == contextId && curretnContextValue.textureList.get(i).getType() == Integer.parseInt(parameters[0].trim())) {
                        if (parameters[1].equals("10240")) {
                            curretnContextValue.textureList.get(i).setMagFilter(Integer.parseInt(parameters[2]));
                        } else if (parameters[1].equals("10241")) {
                            curretnContextValue.textureList.get(i).setMinFilter(Integer.parseInt(parameters[2]));
                        } else if (parameters[1].equals("10242")) {
                            curretnContextValue.textureList.get(i).setWrapS(Integer.parseInt(parameters[2]));
                        } else if (parameters[1].equals("10243")) {
                            curretnContextValue.textureList.get(i).setWrapT(Integer.parseInt(parameters[2]));
                        } else {
                            Logger.error((Object)("GL " + apiName + " undefine type : " + parameters[1]));
                        }
                    }
                    ++i;
                }
                break block32;
            }
            if (!apiName.equals("glTexParameterfv") && !apiName.equals("glTexParameteriv")) break block32;
            if (parameters.length != 3) {
                Logger.error((Object)("GL extract API parameter  : " + apiName));
                return;
            }
            int i = 0;
            while (i < curretnContextValue.textureList.size()) {
                if (curretnContextValue.textureList.get(i).getObjID() == Integer.parseInt(parameters[0].trim()) && curretnContextValue.textureList.get(i).getContextID() == contextId && curretnContextValue.textureList.get(i).getType() == Integer.parseInt(parameters[0].trim())) {
                    if (parameters[1].equals("10240")) {
                        curretnContextValue.textureList.get(i).setMagFilter(Integer.parseInt(parameters[2]));
                    } else if (parameters[1].equals("10241")) {
                        curretnContextValue.textureList.get(i).setMinFilter(Integer.parseInt(parameters[2]));
                    } else if (parameters[1].equals("10242")) {
                        curretnContextValue.textureList.get(i).setWrapS(Integer.parseInt(parameters[2]));
                    } else if (parameters[1].equals("10243")) {
                        curretnContextValue.textureList.get(i).setWrapT(Integer.parseInt(parameters[2]));
                    } else {
                        Logger.error((Object)("GL " + apiName + " undefine type : " + parameters[1]));
                    }
                }
                ++i;
            }
        }
    }

    public void addTextureList(GLStateTextureType textureType) {
        GLContextDataManager contextValue = this.getStateDataManager().getGLContextDataManager(textureType.getContextID());
        if (contextValue == null) {
            contextValue = new GLContextDataManager(textureType.getContextID());
            this.getStateDataManager().getStateHashMap().put(textureType.getContextID(), contextValue);
        }
        contextValue.textureList.add(textureType);
    }

    public List<GLStateTextureType> getTextureList() {
        ArrayList<GLStateTextureType> returnProgramList = new ArrayList<GLStateTextureType>();
        for (Map.Entry<Long, GLContextDataManager> entry : this.getStateDataManager().getStateHashMap().entrySet()) {
            returnProgramList.addAll(entry.getValue().textureList);
        }
        return returnProgramList;
    }

    private boolean isSameTextureType(GLStateTextureType existingTexture, String parameterTextureObjId, long contextId) {
        return existingTexture.getObjID() == Integer.parseInt(parameterTextureObjId.trim()) && existingTexture.getContextID() == contextId;
    }
}

