/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.ui.summary.SummaryDataManager;
import org.tizen.dynamicanalyzer.ui.summary.failed.FailedApiListView;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfiler;
import org.tizen.dynamicanalyzer.ui.summary.profiling.FunctionUsageProfilingView;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningDetailView;
import org.tizen.dynamicanalyzer.ui.summary.warning.WarningListView;
import org.tizen.dynamicanalyzer.widgets.da.view.DABaseComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAContainerComposite;

public class SummaryPage
extends DAContainerComposite {
    public static final String pageID = SummaryPage.class.getName();
    public static final String failedViewID = FailedApiListView.class.getName();
    public static final String profilingViewID = FunctionUsageProfilingView.class.getName();
    public static final String warningListViewID = WarningListView.class.getName();
    public static final String warningDetailViewID = WarningDetailView.class.getName();
    public static final int FAILED_APILIST_VIEW_INDEX = 0;
    public static final int LEAK_VIEW_INDEX = 1;
    public static final int INFO_VIEW_INDEX = 2;
    public static final int FUNCTION_PROFILING_VIEW_INDEX = 3;
    public static final int WARNING_VIEW_INDEX = 4;
    public static final int WARNING_VIEW_DETAIL_INDEX = 5;
    SashForm upperForm;
    SashForm bottomForm;
    SashForm baseForm;
    SashForm warningForm;

    public SummaryPage(Composite parent, int style) {
        super(parent, style);
        this.setTitle(AnalyzerLabels.COOLBAR_AREA_SUMMARY);
        this.setData("tooltip", ShortCutManager.COOLBAR_AREA_SUMMARY_TOOLTIP);
        this.setBackground(ColorResources.CONFIGURATION_TABLE_COVER_BACKGROUND_COLOR);
        this.setLayout((Layout)new FillLayout());
        this.baseForm = new SashForm((Composite)this, 512);
        this.baseForm.setLayout((Layout)new FillLayout());
        this.baseForm.setForeground(ColorResources.TAB_SELECTED_COLOR_START);
        ((FillLayout)this.getLayout()).marginHeight = 5;
        this.upperForm = new SashForm((Composite)this.baseForm, 256);
        FailedApiListView failedApiListView = new FailedApiListView((Composite)this.upperForm, 0);
        this.addView((DABaseComposite)failedApiListView);
        this.upperForm.setWeights(new int[]{50, 50});
        this.bottomForm = new SashForm((Composite)this.baseForm, 256);
        FunctionUsageProfilingView userFunctionProfilingView = new FunctionUsageProfilingView((Composite)this.bottomForm, 0);
        this.addView((DABaseComposite)userFunctionProfilingView);
        this.warningForm = new SashForm((Composite)this.bottomForm, 512);
        this.bottomForm.setWeights(new int[]{50, 50});
        WarningListView warningListView = new WarningListView((Composite)this.warningForm, 0);
        this.addView((DABaseComposite)warningListView);
        WarningDetailView warningDetailView = new WarningDetailView((Composite)this.warningForm, 0);
        this.addView((DABaseComposite)warningDetailView);
        this.warningForm.setWeights(new int[]{70, 30});
        this.baseForm.setSashWidth(2);
        this.bottomForm.setSashWidth(2);
        this.upperForm.setSashWidth(2);
        this.warningForm.setSashWidth(2);
        DataManagerRegistry.registerPageDataManager(FunctionUsageProfiler.getInstance());
        DataManagerRegistry.registerPageDataManager(SummaryDataManager.getInstance());
    }

    protected void onResized(int width, int height) {
        this.upperForm.setWeights(new int[]{50, 50});
        this.baseForm.setWeights(new int[]{50, 50});
    }

    public void clear() {
        super.clear();
        FunctionUsageProfiler.getInstance().clear();
        SummaryDataManager.getInstance().clear();
    }
}

