/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.thread.chart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.tizen.dynamicanalyzer.nl.ThreadPageLabels;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.common.ChartPopupMenu;
import org.tizen.dynamicanalyzer.ui.common.TimeLineChartKeyListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.common.TimelineChartMouseTrackAdapter;
import org.tizen.dynamicanalyzer.ui.thread.ThreadPage;
import org.tizen.dynamicanalyzer.ui.thread.chart.SyncChartBoard;
import org.tizen.dynamicanalyzer.ui.thread.chart.ThreadChart;
import org.tizen.dynamicanalyzer.ui.thread.chart.ThreadChartMouseEventListener;
import org.tizen.dynamicanalyzer.ui.thread.chart.ThreadChartRenderer;
import org.tizen.dynamicanalyzer.ui.thread.data.ThreadDataManager;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageSyncData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadData;
import org.tizen.dynamicanalyzer.ui.thread.type.ThreadPageThreadDataEvent;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.widgets.chart.DAChart;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlotTooltip;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartRenderer;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class ThreadChartBoard
extends SyncChartBoard {
    static final int THREAD_CONTEXT_MENU_ALL_HIDE_INDEX = 6;
    static final int THREAD_CONTEXT_MENU_ALL_SHOW_INDEX = 7;
    static final int TEMP_CHART_PID = -2;
    private List<ThreadChart> threadChartItemList = new ArrayList<ThreadChart>();
    private int threadListCount = -1;
    private int preSelectionPId = -1;
    private int tempChartIndex = 0;

    public ThreadChartBoard(Composite parent, String title) {
        super(parent, title);
    }

    public ThreadChartBoard(Composite parent, String title, int[] scaleValues) {
        super(parent, title, scaleValues);
    }

    public ThreadChartBoard(Composite parent, String title, int boardStyle) {
        super(parent, title, boardStyle);
    }

    @Override
    public void updateChart() {
        this.createChartItem();
        this.clearSeries();
        this.updateSeries();
        this.chartFilteringByPId();
    }

    @Override
    protected void chartFilteringByPId() {
        if (this.getItemList() == null) {
            return;
        }
        int selectedPid = Toolbar.INSTANCE.getSelectedPid();
        if (this.preSelectionPId == selectedPid) {
            return;
        }
        int parentIndex = 0;
        for (ThreadChart chart : this.threadChartItemList) {
            if (selectedPid == 0) {
                this.showItem(parentIndex);
            } else if (selectedPid == chart.getpId()) {
                this.showItem(parentIndex);
            } else {
                this.hideItem(parentIndex);
            }
            ++parentIndex;
        }
        this.preSelectionPId = selectedPid;
    }

    @Override
    public void clear() {
        super.clear();
        this.threadChartItemList.clear();
        this.threadListCount = -1;
        this.preSelectionPId = -1;
        this.tempChartIndex = 0;
        this.setEnableContextMenu(true, false);
    }

    @Override
    public boolean createChartItem() {
        this.createThreadItem();
        this.createSyncItem();
        return true;
    }

    @Override
    protected void initChart(DAChart chart, boolean isAddContextMenuItem) {
        if (chart == null) {
            return;
        }
        DAChartPlot plot = chart.getPlot();
        if (plot == null) {
            return;
        }
        chart.setChartRenderer((DAChartRenderer)new ThreadChartRenderer(this));
        plot.setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
        plot.setAxisFont(FontResources.CHART_AXIS_FONT);
        plot.setAxisRangeY(0.0, 101.0);
        plot.setAxisRangeX(this.getVisibleStartTime(), this.getVisibleEndTime());
        DAChartPlotTooltip tooltip = new DAChartPlotTooltip(-1.0);
        tooltip.setFont(FontResources.CHART_TOOLTIP_FONT);
        plot.setTooltip(tooltip);
        ChartPopupMenu popupMenu = new ChartPopupMenu(chart);
        plot.setBackgroundImage(ImageResources.BG_GRADIENT);
        popupMenu.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        TimeLineChartKeyListener timelineKeyListener = new TimeLineChartKeyListener(this);
        chart.addKeyListener((KeyListener)timelineKeyListener);
        if (isAddContextMenuItem) {
            this.addContextMenuItemChart(popupMenu, chart);
        } else {
            this.initDefaultChart(popupMenu, chart);
        }
    }

    private void addContextMenuItemChart(DAPopupMenu popupMenu, DAChart chart) {
        this.addContextMenuItemOfThreadChart(popupMenu);
        ThreadChartMouseEventListener threadChartMouseEventListener = new ThreadChartMouseEventListener(popupMenu, this.getTimeline());
        chart.addMouseListener((MouseListener)threadChartMouseEventListener);
        chart.addMouseMoveListener((MouseMoveListener)threadChartMouseEventListener);
        chart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
    }

    private void addContextMenuItemOfThreadChart(DAPopupMenu popupMenu) {
        DAPopupMenuItem hideItem = new DAPopupMenuItem(popupMenu, 0);
        hideItem.setText(ThreadPageLabels.THREAD_CONTEXT_MENU_HIDE);
        hideItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                int i = 0;
                while (i < ThreadChartBoard.this.threadChartItemList.size()) {
                    ThreadPageThreadData selectedData = (ThreadPageThreadData)ThreadChartBoard.this.getSelectItem().getData();
                    if (selectedData == null || ThreadChartBoard.this.isMainThreadChartItem(selectedData)) {
                        return;
                    }
                    if (((ThreadChart)ThreadChartBoard.this.threadChartItemList.get(i)).gettId() == selectedData.getTid()) {
                        ThreadChartBoard.this.hideItem(i);
                    }
                    ++i;
                }
            }
        });
        DAPopupMenuItem hideAllItem = new DAPopupMenuItem(popupMenu, 0);
        hideAllItem.setText(ThreadPageLabels.THREAD_CONTEXT_MENU_ALL_HIDE);
        hideAllItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ThreadChartBoard.this.addTempChartAndHideAllChart();
            }
        });
        DAPopupMenuItem showAllItem = new DAPopupMenuItem(popupMenu, 0);
        showAllItem.setText(ThreadPageLabels.THREAD_CONTEXT_MENU_ALL_SHOW);
        showAllItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                ThreadChartBoard.this.removeTempChartAndShowAllChart();
            }
        });
    }

    private void initDefaultChart(DAPopupMenu popupMenu, DAChart chart) {
        DAChartPlot plot = chart.getPlot();
        plot.setBackgroundImage(ImageResources.BG_CHILD_GRADIENT);
        TimelineChartMouseEventListener timeLineChartMouseEventListener = new TimelineChartMouseEventListener(popupMenu, this.getTimeline(), ThreadPage.pageID);
        chart.addMouseListener((MouseListener)timeLineChartMouseEventListener);
        chart.addMouseMoveListener((MouseMoveListener)timeLineChartMouseEventListener);
        chart.addMouseTrackListener((MouseTrackListener)new TimelineChartMouseTrackAdapter(this.getTimeline()));
    }

    private boolean isMainThreadChartItem(ThreadPageThreadData selectedData) {
        return selectedData.getKey().equals(selectedData.getPid());
    }

    private void addTempChartAndHideAllChart() {
        ThreadPageThreadData selectedData = (ThreadPageThreadData)this.getSelectItem().getData();
        if (selectedData == null || selectedData.getKey().equals(selectedData.getPid())) {
            return;
        }
        ArrayList<Integer> reArrangeItemIndexList = new ArrayList<Integer>();
        int size = this.threadChartItemList.size();
        this.showItem(0);
        int i = 1;
        while (i < size) {
            reArrangeItemIndexList.add(i);
            if (this.threadChartItemList.get(i).gettId() > selectedData.getCreateTID()) {
                if (this.threadChartItemList.get(i).gettId() == selectedData.getTid()) {
                    this.tempChartIndex = i - 1;
                }
                if (this.tempChartIndex == 0) {
                    this.hideItem(i);
                }
            }
            ++i;
        }
        reArrangeItemIndexList.add(this.tempChartIndex, 0);
        this.reArrangeItem(reArrangeItemIndexList.toArray(new Integer[reArrangeItemIndexList.size()]));
        this.setEnableContextMenu(false, true);
    }

    private void makeTempChartItem() {
        DAChartBoardItem tempItem = new DAChartBoardItem((DAChartBoard)this, "...");
        tempItem.setData(null);
        tempItem.setEnabled(false);
        tempItem.setHeight(25);
        ThreadChart tempChartData = new ThreadChart(-1, tempItem, tempItem.getChart(), 2);
        tempChartData.settId(-2);
        tempItem.getChart().setData((Object)-2);
        this.initChart(tempItem.getChart(), false);
        this.threadChartItemList.add(tempChartData);
    }

    public void removeTempChartAndShowAllChart() {
        ArrayList<Integer> reArrangeItemIndexList = new ArrayList<Integer>();
        reArrangeItemIndexList.add(this.tempChartIndex);
        int i = 0;
        while (i < this.threadChartItemList.size()) {
            if (this.tempChartIndex != i) {
                reArrangeItemIndexList.add(i);
            }
            this.showItem(i);
            ++i;
        }
        this.reArrangeItem(reArrangeItemIndexList.toArray(new Integer[reArrangeItemIndexList.size()]));
        this.selectItem(this.tempChartIndex + 1);
        this.tempChartIndex = 0;
        this.setEnableContextMenu(true, false);
    }

    private void hideTempChart() {
        if (this.getItemList() != null && this.getItemList().getItemSize() > 0 && this.isTempChartAtTop()) {
            this.hideItem(0);
        }
    }

    private boolean isTempChartAtTop() {
        return this.getItemList().get(0).getData() == null;
    }

    private void setEnableContextMenu(boolean hidden, boolean show) {
        ThreadChartMouseEventListener.isEnableHiddenAllItem = hidden;
        ThreadChartMouseEventListener.isEnableShowAllItem = show;
        this.hideTempChart();
    }

    public int getThreadChartIndexByTID(String tID) {
        this.removeTempChartAndShowAllChart();
        int itemSize = this.getItemList().getItemSize();
        if (tID == null || itemSize == 0) {
            return 0;
        }
        int i = 0;
        while (i < itemSize) {
            ThreadPageThreadData pageData;
            DAChartBoardItem item = this.getItemList().get(i);
            if (item.getData() != null && (pageData = (ThreadPageThreadData)item.getData()).getTid() == Integer.parseInt(tID)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void createThreadItem() {
        if (this.threadListCount == ThreadDataManager.getInstance().getThreadDataMaker().getChartRowData().size()) {
            return;
        }
        List<ThreadPageThreadData> sortList = this.sortThreadChartByTID(ThreadDataManager.getInstance().getThreadDataMaker().getChartRowData());
        for (ThreadPageThreadData data : sortList) {
            if (this.isExistThreadChartRow(data)) continue;
            this.addThreadParentChartItemList(data);
        }
        this.threadListCount = ThreadDataManager.getInstance().getThreadDataMaker().getChartRowData().size();
    }

    private List<ThreadPageThreadData> sortThreadChartByTID(List<ThreadPageThreadData> list) {
        Comparator<ThreadPageThreadData> comparator = new Comparator<ThreadPageThreadData>(){

            @Override
            public int compare(ThreadPageThreadData arg0, ThreadPageThreadData arg1) {
                if (arg0.getTid() > arg1.getTid()) {
                    return 1;
                }
                if (arg0.getTid() < arg1.getTid()) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
        return list;
    }

    private void createSyncItem() {
        if (this.syncListCount == ThreadDataManager.getInstance().getSyncDataMaker().getChartRowData().size()) {
            return;
        }
        for (ThreadPageSyncData data : ThreadDataManager.getInstance().getSyncDataMaker().getChartRowData()) {
            if (this.isExistSyncChartRow(data)) continue;
            this.addChartChildItemList(data);
        }
        this.syncListCount = ThreadDataManager.getInstance().getSyncDataMaker().getChartRowData().size();
    }

    private boolean isExistThreadChartRow(ThreadPageThreadData data) {
        for (ThreadChart chart : this.threadChartItemList) {
            if (chart.getChartID() != data.getThreadDataID()) continue;
            return true;
        }
        return false;
    }

    private void addChartChildItemList(ThreadPageSyncData data) {
        ThreadChart parent = this.getParentChartData(data);
        if (parent != null) {
            this.addSyncChildChartItemList(parent, data);
        }
    }

    private ThreadChart getParentChartData(ThreadPageSyncData syncData) {
        if (syncData.getSyncDataType() != 2) {
            return null;
        }
        for (ThreadChart chart : this.threadChartItemList) {
            if (chart.getChartID() != syncData.getParentID()) continue;
            return chart;
        }
        return null;
    }

    private void addThreadParentChartItemList(ThreadPageThreadData data) {
        DAChartBoardItem parentItem = new DAChartBoardItem((DAChartBoard)this, String.valueOf(data.getTypeString()) + ThreadPageLabels.THREAD_CHART_NAME_PREFIX + ThreadPageLabels.THREAD_CHART_NAME_PID + data.getPid() + ThreadPageLabels.THREAD_CHART_NAME_COMMA + ThreadPageLabels.THREAD_CHART_NAME_TID + data.getKey() + ThreadPageLabels.THREAD_CHART_NAME_POSTFIX);
        parentItem.setData((Object)data);
        DAChart parentDAChart = parentItem.getChart();
        parentDAChart.setData((Object)data.getTid());
        ThreadChart parentChartData = new ThreadChart(data.getThreadDataID(), parentItem, parentDAChart, 2);
        this.initChart(parentDAChart, false);
        parentChartData.setpId(Integer.parseInt(data.getPid()));
        parentChartData.settId(data.getTid());
        this.threadChartItemList.add(parentChartData);
    }

    @Override
    public void clearSeries() {
        super.clearSeries();
        this.clearThreadSeries();
    }

    private void clearThreadSeries() {
        if (this.threadChartItemList == null) {
            return;
        }
        for (ThreadChart chart : this.threadChartItemList) {
            chart.clearSeries();
        }
    }

    private void updateSeries() {
        this.updateThreadEventSeries();
        this.updateSyncEventSeries();
    }

    private void updateThreadEventSeries() {
        if (this.threadChartItemList == null) {
            return;
        }
        ArrayList<ThreadPageThreadDataEvent> seriesList = new ArrayList<ThreadPageThreadDataEvent>();
        seriesList.addAll(this.selectThreadEventSeriesListFromDB());
        seriesList.addAll(ThreadDataManager.getInstance().getThreadDataMaker().getRemainingCallEvent());
        if (seriesList == null || seriesList.size() == 0) {
            return;
        }
        for (ThreadChart chart : this.threadChartItemList) {
            chart.updateThreadSeries(seriesList);
        }
    }

    /*
     * Exception decompiling
     */
    private List<ThreadPageThreadDataEvent> selectThreadEventSeriesListFromDB() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<ThreadChart> getThreadChartItemList() {
        return this.threadChartItemList;
    }
}

