/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.TizenButton;
import org.eclipse.swt.custom.TizenButtonAttribute;
import org.eclipse.swt.custom.TizenPushButtonRenderer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class TizenArrowButtonRenderer
extends TizenPushButtonRenderer {
    private int arrowButtonStayle = 0;
    private final int ARROW_SIZE = 4;

    TizenArrowButtonRenderer(TizenButton parent, Composite parentComposite, int style) {
        super(parent, parentComposite);
        this.arrowButtonStayle = style;
    }

    private int getArrowButtonStyle(int style) {
        int bits = 148608;
        return style & bits;
    }

    protected void drawButton(Event e) {
        TizenButton me = (TizenButton)e.widget;
        Rectangle rect = me.getClientArea();
        this.drawBackground(e.gc, rect, this.getButtonState(), this.parent.getAttribute());
        this.drawArrow(e.gc, rect, this.getButtonState(), this.parent.getAttribute());
    }

    private void drawArrow(GC gc, Rectangle rect, int state, TizenButtonAttribute attr) {
        if (this.parent.attr == null || this.parent.attr.getBackGroundcolor(state) == null) {
            return;
        }
        int centerX = rect.width / 2;
        int centerY = rect.height / 2 - 1;
        gc.setBackground(attr.getForeGroundcolor(state));
        switch (this.getArrowButtonStyle(this.arrowButtonStayle)) {
            case 16384: {
                int[] leftTriangle = new int[]{centerX - 4, centerY, centerX + 4, centerY - 4, centerX + 4, centerY + 4};
                gc.fillPolygon(leftTriangle);
                break;
            }
            case 131072: {
                int[] rightTriangle = new int[]{centerX + 4, centerY, centerX - 4, centerY - 4, centerX - 4, centerY + 4};
                gc.fillPolygon(rightTriangle);
                break;
            }
            case 128: {
                int[] upTriangle = new int[]{centerX - 4, centerY + 2, centerX + 4, centerY + 2, centerX, centerY - 4};
                gc.fillPolygon(upTriangle);
                break;
            }
            case 1024: {
                int[] downTriangle = new int[]{centerX - 4, centerY - 2, centerX + 4, centerY - 2, centerX, centerY + 4};
                gc.fillPolygon(downTriangle);
                break;
            }
            default: {
                int[] defaultTriangle = new int[]{centerX - 4, centerY - 4, centerX + 4, centerY - 4, centerX, centerY + 4};
                gc.fillPolygon(defaultTriangle);
            }
        }
    }
}

