/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.da.base;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.base.DAAbstractText;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextCallbackEvent;

public class DAValidTextBox
extends DAAbstractText {
    private Composite composite = null;
    private Image iconImage = ImageResources.TEXT_BOX_OK;
    private int imageArea = 20;
    DATextCallbackEvent validationChecker = null;

    public DAValidTextBox(Composite parent, int style) {
        this.composite = new Composite(parent, 0x20000000);
        this.composite.setLayout((Layout)new FormLayout());
        this.text = new Text(this.composite, style);
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite comp = (Composite)e.widget;
                Rectangle rect = comp.getClientArea();
                e.gc.setForeground(DAValidTextBox.this.boaderColor);
                e.gc.drawRectangle(rect.x, rect.y, rect.width - DAValidTextBox.this.imageArea, rect.height - 1);
                if (DAValidTextBox.this.iconImage != null) {
                    ImageData data = DAValidTextBox.this.iconImage.getImageData();
                    e.gc.drawImage(DAValidTextBox.this.iconImage, rect.width - data.width - 1, (rect.height - data.height) / 2);
                }
            }
        });
        this.text.addListener(6, this.textMouseListener);
        this.text.addListener(7, this.textMouseListener);
        this.text.addListener(3, this.textMouseListener);
        this.text.addListener(4, this.textMouseListener);
        this.text.addListener(32, this.textMouseListener);
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                DAValidTextBox.this.boaderColor = ColorResources.TEXT_NORMAL_COLOR;
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (DAValidTextBox.this.validationChecker != null) {
                    if (DAValidTextBox.this.validationChecker.checkValidation(DAValidTextBox.this.text.getText())) {
                        DAValidTextBox.this.iconImage = ImageResources.TEXT_BOX_OK;
                    } else {
                        DAValidTextBox.this.iconImage = ImageResources.TEXT_BOX_WARNING;
                    }
                    DAValidTextBox.this.composite.redraw();
                } else {
                    Logger.debug((Object)"validationChecker is null, register CallbackEvent!!");
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public void setLayoutData(FormData data) {
        this.composite.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 1);
        data.bottom = new FormAttachment(100, -1);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -this.imageArea);
        this.text.setLayoutData((Object)data);
        this.composite.layout();
    }

    public void setCompositeBackground(Color color) {
        this.composite.setBackground(color);
    }

    public void setDefaultIconImage(boolean defaultImage) {
        this.iconImage = defaultImage ? ImageResources.TEXT_BOX_OK : ImageResources.TEXT_BOX_WARNING;
    }

    @Override
    void redraw() {
        this.composite.redraw();
    }

    public void registerCallbackEvent(DATextCallbackEvent event) {
        this.validationChecker = event;
    }
}

