/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.warning;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.swap.model.data.LogData;
import org.tizen.dynamicanalyzer.swap.model.data.LogDataFactory;
import org.tizen.dynamicanalyzer.swap.model.data.ProbeCommonData;

public class WarningData {
    private static long uNum = 1L;
    private long seq = uNum++;
    private int category;
    private int warningCase;
    private List<String> data = null;
    private String key = null;
    private long callerPc = -1L;
    private LogData logData = null;
    private int pid = -1;
    private String libName = null;

    public WarningData(int wCase, LogData data, String key) {
        this.category = data.getMsgID();
        this.warningCase = wCase;
        this.key = key;
        this.callerPc = ((ProbeCommonData)data).getCallerPcAddr();
        this.logData = data;
        this.pid = data.getPid();
        this.libName = ((ProbeCommonData)data).getLibName();
    }

    public List<String> getData() {
        if (this.data == null) {
            this.data = new ArrayList<String>();
        }
        return this.data;
    }

    public long getSeq() {
        return this.seq;
    }

    public int getLogId() {
        return this.category;
    }

    public String getCategory() {
        return LogDataFactory.getLogFormatName(this.category);
    }

    public int getWarningCase() {
        return this.warningCase;
    }

    public String getKey() {
        return this.key;
    }

    public static void resetSeq() {
        uNum = 1L;
    }

    public long getCallerPc() {
        return this.callerPc;
    }

    public LogData getLogData() {
        return this.logData;
    }

    public void setLogData(LogData logData) {
        this.logData = logData;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getLibName() {
        return this.libName;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }
}

