/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.toolbar.opentrace;

import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.common.path.PathManager;
import org.tizen.dynamicanalyzer.handlers.CommonAction;
import org.tizen.dynamicanalyzer.handlers.OpenTraceHandler;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.ui.timeline.TimelinePage;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.da.view.DAContainerComposite;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;

public class OpenTraceProgressManager
implements Runnable {
    public static final int INIT = 0;
    public static final int OPEN_TRACE_PROCESS_START = 1;
    public static final int OPEN_TRACE_PROCESS_END = 2;
    private int state = 0;
    private ProgressHolder progress;
    private String savePath = null;
    private int percent = 0;
    private static OpenTraceProgressManager instance = new OpenTraceProgressManager();
    private Thread openTraceThread = null;

    public void startOpenTraceThread() {
        if (this.openTraceThread == null || !this.openTraceThread.isAlive()) {
            this.openTraceThread = new Thread(null, new OpenTraceProgressManager(), "Open trace input thread");
            this.openTraceThread.start();
        }
    }

    public void stopOpenTraceThread() {
        if (this.openTraceThread != null && this.openTraceThread.isAlive()) {
            this.openTraceThread.interrupt();
        }
    }

    public int getPercent() {
        return this.percent;
    }

    public void setSavePath(String path) {
        this.savePath = path;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public static OpenTraceProgressManager getInstance() {
        return instance;
    }

    public void openTracePrgressStart(final String EndMessage) {
        if (this.state == 1) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                OpenTraceProgressManager.this.state = 1;
                OpenTraceProgressManager.this.progress = ProgressManager.INSTANCE.createProgress(false, 0, EndMessage, AnalyzerLabels.DLG_PLEASE_WAIT, null);
            }
        });
    }

    public void setProgressPercent(final String message, final int percent) {
        if (this.progress != null) {
            this.percent = percent;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OpenTraceProgressManager.this.progress.setValues(message, percent);
                }
            });
        }
    }

    public void setValue(final int percent) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                OpenTraceProgressManager.this.progress.setValue(percent);
            }
        });
    }

    public void openTraceComplete() {
        DAState.changeCurrentState(DAState.DONE);
        if (this.progress != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    AnalyzerUtil.changePage(TimelinePage.pageID);
                    OpenTraceProgressManager.this.progress.setValue(100);
                    ProgressManager.INSTANCE.stopProgress(OpenTraceProgressManager.this.progress);
                }
            });
            this.state = 2;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (Global.getProject().getSavePath().contains(PathManager.DA_TEMP_FOLDER_PATH)) {
                        Toolbar.INSTANCE.setAllControlState(true);
                    }
                    UIActionHolder.getUIAction().applyWebProfilingUI(Global.getProject().isWebApplication());
                    DAContainerComposite page = AnalyzerManager.getCurrentPage();
                    page.updateView();
                }
            });
            Logger.debug((Object)"open trace complete!!");
            this.percent = 0;
        }
    }

    public void closeOpenTraceDialog(final String errMsg) {
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OpenTraceProgressManager.this.progress.errorOccured(errMsg, AnalyzerLabels.OPEN_TRACE_PROGRESS_ERROR);
                    OpenTraceProgressManager.this.progress.setValue(50);
                }
            });
            Thread.sleep(500L);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OpenTraceProgressManager.this.progress.setValue(100);
                }
            });
            Thread.sleep(300L);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressManager.INSTANCE.stopProgress(OpenTraceProgressManager.this.progress);
                }
            });
            this.state = 2;
        }
        catch (InterruptedException e) {
            Logger.exception((Throwable)e);
        }
    }

    public int getState() {
        return this.state;
    }

    @Override
    public void run() {
        CommonAction.clear();
        Project project = Project.getProjectFromFile(OpenTraceProgressManager.getInstance().getSavePath());
        if (project != null) {
            Global.setProject(project);
            Global.getProject().setLoadedProject(true);
            Global.getProject().setSavedData(true);
            AnalyzerUtil.executeCommand(OpenTraceHandler.ID);
        } else {
            this.closeOpenTraceDialog(AnalyzerLabels.OPEN_TRACE_PROGRESS_LOADING_FAILED);
            UIActionHolder.getUIAction().showWarning(AnalyzerLabels.OPEN_TRACE_PROGRESS_INVALID);
            CommonAction.clear();
        }
    }
}

