/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.symbols.dwarf;

import java.nio.ByteOrder;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.MemoryStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.symbols.InvalidVariableLocation;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.DwarfMessages;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.LocationEntry;
import org.eclipse.cdt.debug.edc.internal.symbols.dwarf.LocationExpression;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.symbols.ILocationProvider;
import org.eclipse.cdt.debug.edc.symbols.IModuleScope;
import org.eclipse.cdt.debug.edc.symbols.IScope;
import org.eclipse.cdt.debug.edc.symbols.IVariableLocation;
import org.eclipse.cdt.dsf.debug.service.IStack;

public class LocationList
implements ILocationProvider {
    protected LocationEntry[] locationList;
    protected int addressSize;
    protected IScope scope;
    protected ByteOrder byteOrder;

    public LocationList(LocationEntry[] locationList, ByteOrder byteOrder, int addressSize, IScope scope) {
        this.locationList = locationList;
        this.byteOrder = byteOrder;
        this.addressSize = addressSize;
        this.scope = scope;
    }

    public LocationEntry[] getLocationEntries() {
        return this.locationList;
    }

    @Override
    public IVariableLocation getLocation(EDCServicesTracker tracker, IStack.IFrameDMContext context, IAddress forLinkAddress, boolean isNonLocalConstVariable) {
        if (this.locationList != null) {
            IScope searchScope = this.scope;
            do {
                IVariableLocation location;
                if ((location = this.searchForLocation(tracker, context, forLinkAddress, searchScope)) == null) continue;
                return location;
            } while (!((searchScope = searchScope.getParent()) instanceof IModuleScope));
        }
        return this.locationList != null ? new InvalidVariableLocation(DwarfMessages.UnknownVariableAddress) : null;
    }

    private IVariableLocation searchForLocation(EDCServicesTracker tracker, IStack.IFrameDMContext context, IAddress forLinkAddress, IScope scope) {
        long address = forLinkAddress.getValue().longValue();
        LocationEntry[] locationEntryArray = this.locationList;
        int n = this.locationList.length;
        int n2 = 0;
        while (n2 < n) {
            LocationEntry entry = locationEntryArray[n2];
            if (address >= entry.getLowPC() && address < entry.getHighPC()) {
                MemoryStreamBuffer locationData = new MemoryStreamBuffer(entry.getBytes(), this.byteOrder);
                LocationExpression expression = new LocationExpression(locationData, this.addressSize, scope);
                return expression.getLocation(tracker, context, forLinkAddress, false);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean isLocationKnown(IAddress forLinkAddress) {
        long address = forLinkAddress.getValue().longValue();
        LocationEntry[] locationEntryArray = this.locationList;
        int n = this.locationList.length;
        int n2 = 0;
        while (n2 < n) {
            LocationEntry entry = locationEntryArray[n2];
            if (address >= entry.getLowPC() && address < entry.getHighPC()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean lifetimeMustMatchScope() {
        return false;
    }
}

