/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.disassembler;

import org.eclipse.cdt.dsf.debug.service.IInstruction;
import org.eclipse.cdt.dsf.debug.service.IMixedInstruction;

public class EDCMixedInstruction
implements IMixedInstruction {
    private final String fileName;
    private final int lineNumber;
    private final IInstruction[] instructions;

    public EDCMixedInstruction(String fileName, int lineNumber, IInstruction[] instructions) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.instructions = instructions;
    }

    public String getFileName() {
        return this.fileName;
    }

    public IInstruction[] getInstructions() {
        return this.instructions;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Source File: ").append(this.fileName).append("\n");
        buf.append(" line #").append(this.lineNumber).append(":\n");
        IInstruction[] iInstructionArray = this.instructions;
        int n = this.instructions.length;
        int n2 = 0;
        while (n2 < n) {
            IInstruction i = iInstructionArray[n2];
            buf.append("\t").append(i).append("\n");
            ++n2;
        }
        return buf.toString();
    }
}

