/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Arrays;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class OriginalText
extends Scrollable {
    int bufferHandle;
    int imContext;
    int tabs = 8;
    int lastEventTime = 0;
    int gdkEventKey = 0;
    int fixStart = -1;
    int fixEnd = -1;
    boolean doubleClick;
    String message = "";
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    int[] segments;
    static final int ITER_SIZEOF = OS.GtkTextIter_sizeof();
    static final int SPACE_FOR_CURSOR = 1;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";
    GdkRGBA background;

    public OriginalText(Composite parent, int style) {
        super(parent, OriginalText.checkStyle(style));
        if ((style & 0x80) != 0) {
            if ((style & 0x100) != 0) {
                this.style |= 0x100;
                OS.gtk_entry_set_icon_from_icon_name(this.handle, 1, OS.GTK_NAMED_ICON_CLEAR);
                OS.gtk_entry_set_icon_sensitive(this.handle, 1, false);
            }
            if ((style & 0x200) != 0) {
                this.style |= 0x200;
                OS.gtk_entry_set_icon_from_icon_name(this.handle, 0, OS.GTK_NAMED_ICON_FIND);
            }
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x80) != 0) {
            style |= 0x804;
            style &= 0xFFBFFFFF;
        }
        if ((style & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = OriginalText.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    void createHandle(int index) {
        this.state |= 0x28;
        if ((this.style & 8) != 0 && this.applyThemeBackground() == 1) {
            this.state |= 0x10000;
        }
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        if ((this.style & 4) != 0) {
            this.handle = OS.gtk_entry_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            OS.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
            OS.gtk_entry_set_has_frame(this.handle, (this.style & 0x800) != 0);
            OS.gtk_entry_set_visibility(this.handle, (this.style & 0x400000) == 0);
            float alignment = 0.0f;
            if ((this.style & 0x1000000) != 0) {
                alignment = 0.5f;
            }
            if ((this.style & 0x20000) != 0) {
                alignment = 1.0f;
            }
            if (alignment > 0.0f) {
                OS.gtk_entry_set_alignment(this.handle, alignment);
            }
        } else {
            this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            this.handle = OS.gtk_text_view_new();
            if (this.handle == 0) {
                this.error(2);
            }
            this.bufferHandle = OS.gtk_text_view_get_buffer(this.handle);
            if (this.bufferHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            OS.gtk_container_add(this.scrolledHandle, this.handle);
            OS.gtk_text_view_set_editable(this.handle, (this.style & 8) == 0);
            if ((this.style & 0x40) != 0) {
                OS.gtk_text_view_set_wrap_mode(this.handle, 3);
            }
            int hsp = (this.style & 0x100) != 0 ? 0 : 2;
            int vsp = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
            if ((this.style & 0x800) != 0) {
                OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
            int just = 0;
            if ((this.style & 0x1000000) != 0) {
                just = 2;
            }
            if ((this.style & 0x20000) != 0) {
                just = 1;
            }
            OS.gtk_text_view_set_justification(this.handle, just);
        }
        if (OS.GTK3) {
            this.imContext = OS.imContextLast();
            if ((this.style & 4) != 0) {
                OS.gtk_entry_set_width_chars(this.handle, 6);
            }
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0xB00) == 0 ? 1 : 0;
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.doubleClick = true;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.clearSegments(true);
        this.applySegments();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        this.clearSegments(true);
        if ((this.style & 4) != 0) {
            OS.gtk_editable_insert_text(this.handle, buffer, buffer.length, new int[]{-1});
            OS.gtk_editable_set_position(this.handle, -1);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_end_iter(this.bufferHandle, position);
            OS.gtk_text_buffer_insert(this.bufferHandle, position, buffer, buffer.length);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, position);
            int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
        }
        this.applySegments();
    }

    void applySegments() {
        String string;
        if (this.isDisposed() || !this.hooks(49) && !this.filters(49)) {
            return;
        }
        Event event = new Event();
        event.text = string = this.getText();
        event.segments = this.segments;
        this.sendEvent(49, event);
        this.segments = event.segments;
        if (this.segments == null) {
            return;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return;
        }
        int i = 1;
        int length = string == null ? 0 : string.length();
        while (i < nSegments) {
            if (event.segments[i] < event.segments[i - 1] || event.segments[i] > length) {
                this.error(5);
            }
            ++i;
        }
        char[] segmentsChars = event.segmentsChars;
        char[] separator = new char[]{this.getOrientation() == 0x4000000 ? (char)'\u200f' : '\u200e'};
        if ((this.style & 4) != 0) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            int limit = OS.gtk_entry_get_max_length(this.handle);
            if (limit != 0) {
                OS.gtk_entry_set_max_length(this.handle, this.translateOffset(limit));
            }
            int[] pos = new int[1];
            int i2 = 0;
            while (i2 < nSegments) {
                pos[0] = this.segments[i2] + i2;
                if (segmentsChars != null && segmentsChars.length > i2) {
                    separator[0] = segmentsChars[i2];
                }
                byte[] buffer = Converter.wcsToMbcs(null, separator, false);
                int ptr = OS.gtk_entry_get_text(this.handle);
                pos[0] = OS.g_utf16_offset_to_utf8_offset(ptr, pos[0]);
                OS.gtk_editable_insert_text(this.handle, buffer, buffer.length, pos);
                ++i2;
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
        } else {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            byte[] pos = new byte[ITER_SIZEOF];
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            int i3 = 0;
            while (i3 < nSegments) {
                OS.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
                int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
                OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, pos, OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i3] + i3));
                OS.g_free(ptr);
                if (segmentsChars != null && segmentsChars.length > i3) {
                    separator[0] = segmentsChars[i3];
                }
                byte[] buffer = Converter.wcsToMbcs(null, separator, false);
                OS.gtk_text_buffer_insert(this.bufferHandle, pos, buffer, buffer.length);
                ++i3;
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
        }
    }

    void clearSegments(boolean applyText) {
        if (this.segments == null) {
            return;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int limit;
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            if (applyText) {
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
                int ptr = OS.gtk_entry_get_text(this.handle);
                int i = 0;
                while (i < nSegments) {
                    int start = OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i]);
                    int end = OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i] + 1);
                    OS.gtk_editable_delete_text(this.handle, start, end);
                    ++i;
                }
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
            }
            if ((limit = OS.gtk_entry_get_max_length(this.handle)) != 0) {
                OS.gtk_entry_set_max_length(this.handle, this.untranslateOffset(limit));
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        } else if (applyText) {
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            int i = 0;
            while (i < nSegments) {
                OS.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
                int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
                OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, start, OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i]));
                OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, end, OS.g_utf16_offset_to_utf8_offset(ptr, this.segments[i] + 1));
                OS.gtk_text_buffer_delete(this.bufferHandle, start, end);
                OS.g_free(ptr);
                ++i;
            }
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
        }
        this.segments = null;
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int position = OS.gtk_editable_get_position(this.handle);
            OS.gtk_editable_select_region(this.handle, position, position);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            int insertMark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, insertMark);
            OS.gtk_text_buffer_select_range(this.bufferHandle, position, position);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int layout;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        if ((this.style & 4) != 0) {
            OS.gtk_widget_realize(this.handle);
            int layout2 = OS.gtk_entry_get_layout(this.handle);
            OS.pango_layout_get_pixel_size(layout2, w, h);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, start, end);
            int text = OS.gtk_text_buffer_get_text(this.bufferHandle, start, end, true);
            layout = OS.gtk_widget_create_pango_layout(this.handle, text);
            OS.g_free(text);
            OS.pango_layout_set_width(layout, wHint * 1024);
            OS.pango_layout_get_pixel_size(layout, w, h);
            OS.g_object_unref(layout);
        }
        int width = w[0];
        int height = h[0];
        if ((this.style & 4) != 0 && this.message.length() > 0) {
            byte[] buffer = Converter.wcsToMbcs(null, this.message, true);
            layout = OS.gtk_widget_create_pango_layout(this.handle, buffer);
            Arrays.fill(buffer, (byte)0);
            OS.pango_layout_get_pixel_size(layout, w, h);
            OS.g_object_unref(layout);
            width = Math.max(width, w[0]);
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        Rectangle trim = this.computeTrim(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int xborder = 0;
        int yborder = 0;
        if ((this.style & 4) != 0) {
            if (OS.GTK3) {
                GtkBorder tmp = new GtkBorder();
                int context = OS.gtk_widget_get_style_context(this.handle);
                OS.gtk_style_context_get_padding(context, 0, tmp);
                trim.x -= tmp.left;
                trim.y -= tmp.top;
                trim.width += tmp.left + tmp.right;
                trim.height += tmp.top + tmp.bottom;
                if ((this.style & 0x800) != 0) {
                    OS.gtk_style_context_get_border(context, 0, tmp);
                    trim.x -= tmp.left;
                    trim.y -= tmp.top;
                    trim.width += tmp.left + tmp.right;
                    trim.height += tmp.top + tmp.bottom;
                }
                GdkRectangle icon_area = new GdkRectangle();
                OS.gtk_entry_get_icon_area(this.handle, 0, icon_area);
                trim.x -= icon_area.width;
                trim.width += icon_area.width;
                OS.gtk_entry_get_icon_area(this.handle, 1, icon_area);
                trim.width += icon_area.width;
            } else {
                if ((this.style & 0x800) != 0) {
                    Point thickness = this.getThickness(this.handle);
                    xborder += thickness.x;
                    yborder += thickness.y;
                }
                GtkBorder innerBorder = Display.getEntryInnerBorder(this.handle);
                trim.x -= innerBorder.left;
                trim.y -= innerBorder.top;
                trim.width += innerBorder.left + innerBorder.right;
                trim.height += innerBorder.top + innerBorder.bottom;
            }
        } else {
            int borderWidth = OS.gtk_container_get_border_width(this.handle);
            xborder += borderWidth;
            yborder += borderWidth;
        }
        int[] property = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.interior_focus, property, 0);
        if (property[0] == 0) {
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, property, 0);
            xborder += property[0];
            yborder += property[0];
        }
        trim.x -= xborder;
        trim.y -= yborder;
        trim.width += 2 * xborder;
        trim.height += 2 * yborder;
        ++trim.width;
        return new Rectangle(trim.x, trim.y, trim.width, trim.height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_copy_clipboard(this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get(0);
            this.clearSegments(true);
            OS.gtk_text_buffer_copy_clipboard(this.bufferHandle, clipboard);
            this.applySegments();
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_cut_clipboard(this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get(0);
            this.clearSegments(true);
            OS.gtk_text_buffer_cut_clipboard(this.bufferHandle, clipboard, OS.gtk_text_view_get_editable(this.handle));
            this.applySegments();
        }
    }

    char[] deprocessText(char[] text, int start, int end) {
        int nSegments;
        if (text == null) {
            return new char[0];
        }
        if (start < 0) {
            start = 0;
        }
        int length = text.length;
        if (end == -1) {
            end = start + length;
        }
        if (this.segments != null && end > this.segments[0] && (nSegments = this.segments.length) > 0 && start <= this.segments[nSegments - 1]) {
            int nLeadSegments = 0;
            while (start - nLeadSegments > this.segments[nLeadSegments]) {
                ++nLeadSegments;
            }
            int segmentCount = nLeadSegments;
            int i = start;
            while (i < end) {
                if (segmentCount < nSegments && i - segmentCount == this.segments[segmentCount]) {
                    ++segmentCount;
                } else {
                    text[i - segmentCount + nLeadSegments - start] = text[i - start];
                }
                ++i;
            }
            length = end - start - segmentCount + nLeadSegments;
        }
        if (start != 0 || end != start + length) {
            char[] newText = new char[length];
            System.arraycopy(text, 0, newText, 0, length);
            return newText;
        }
        return text;
    }

    void deregister() {
        int imContext;
        super.deregister();
        if (this.bufferHandle != 0) {
            this.display.removeWidget(this.bufferHandle);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.removeWidget(imContext);
        }
    }

    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        if (filter) {
            Object[] e;
            Object[] s;
            int start = 0;
            int end = 0;
            if ((this.style & 4) != 0) {
                s = new int[1];
                e = new int[1];
                OS.gtk_editable_get_selection_bounds(this.handle, s, e);
                start = s[0];
                end = e[0];
            } else {
                s = new byte[ITER_SIZEOF];
                e = new byte[ITER_SIZEOF];
                OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, (byte[])s, (byte[])e);
                start = OS.gtk_text_iter_get_offset((byte[])s);
                end = OS.gtk_text_iter_get_offset((byte[])e);
            }
            if (start != end) {
                if (end < start) {
                    int temp = end;
                    end = start;
                    start = temp;
                }
                int position = -1;
                if ((this.style & 4) != 0) {
                    int[] index = new int[1];
                    int[] trailing = new int[1];
                    int layout = OS.gtk_entry_get_layout(this.handle);
                    OS.pango_layout_xy_to_index(layout, x * 1024, y * 1024, index, trailing);
                    int ptr = OS.pango_layout_get_text(layout);
                    position = OS.g_utf8_pointer_to_offset(ptr, ptr + index[0]) + trailing[0];
                } else {
                    byte[] p = new byte[ITER_SIZEOF];
                    OS.gtk_text_view_get_iter_at_location(this.handle, p, x, y);
                    position = OS.gtk_text_iter_get_offset(p);
                }
                if (start <= position && position < end && super.dragDetect(x, y, filter, dragOnTimeout, consume)) {
                    if (consume != null) {
                        consume[0] = true;
                    }
                    return true;
                }
            }
            return false;
        }
        return super.dragDetect(x, y, filter, dragOnTimeout, consume);
    }

    int eventWindow() {
        return this.paintWindow();
    }

    boolean filterKey(int keyval, int event) {
        int time = OS.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            int imContext = this.imContext();
            if (imContext != 0) {
                return OS.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    void fixIM() {
        int imContext;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (imContext = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getBorderWidth() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return super.getBorderWidth();
        }
        if ((this.style & 0x800) != 0) {
            return this.getThickness((int)this.handle).x;
        }
        return 0;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, mark);
        return OS.gtk_text_iter_get_line(position);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int index = OS.gtk_editable_get_position(this.handle);
            index = OS.gtk_entry_text_index_to_layout_index(this.handle, index);
            int[] offset_x = new int[1];
            int[] offset_y = new int[1];
            OS.gtk_entry_get_layout_offsets(this.handle, offset_x, offset_y);
            int layout = OS.gtk_entry_get_layout(this.handle);
            PangoRectangle pos = new PangoRectangle();
            OS.pango_layout_index_to_pos(layout, index, pos);
            int x = offset_x[0] + OS.PANGO_PIXELS(pos.x) - this.getBorderWidth();
            int y = offset_y[0] + OS.PANGO_PIXELS(pos.y);
            return new Point(x, y);
        }
        byte[] position = new byte[ITER_SIZEOF];
        int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, mark);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_iter_location(this.handle, position, rect);
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_text_view_buffer_to_window_coords(this.handle, 2, rect.x, rect.y, x, y);
        return new Point(x[0], y[0]);
    }

    public int getCaretPosition() {
        int result;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int ptr = OS.gtk_entry_get_text(this.handle);
            result = OS.g_utf8_offset_to_utf16_offset(ptr, OS.gtk_editable_get_position(this.handle));
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, mark);
            byte[] zero = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
            int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, zero, position, true);
            result = OS.g_utf8_offset_to_utf16_offset(ptr, OS.gtk_text_iter_get_offset(position));
            OS.g_free(ptr);
        }
        return this.untranslateOffset(result);
    }

    public int getCharCount() {
        int result;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int ptr = OS.gtk_entry_get_text(this.handle);
            result = OS.g_utf16_strlen(ptr, -1);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
            int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
            result = OS.g_utf16_strlen(ptr, -1);
            OS.g_free(ptr);
        }
        return this.untranslateOffset(result);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 4) != 0 && !OS.gtk_entry_get_visibility(this.handle)) {
            return OS.gtk_entry_get_invisible_char(this.handle);
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_editable(this.handle);
        }
        return OS.gtk_text_view_get_editable(this.handle);
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        return OS.gtk_text_buffer_get_line_count(this.bufferHandle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public int getOrientation() {
        return super.getOrientation();
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int position = -1;
        if ((this.style & 4) != 0) {
            int[] index = new int[1];
            int[] trailing = new int[1];
            int layout = OS.gtk_entry_get_layout(this.handle);
            OS.pango_layout_xy_to_index(layout, point.x * 1024, point.y * 1024, index, trailing);
            int ptr = OS.pango_layout_get_text(layout);
            position = OS.g_utf16_pointer_to_offset(ptr, ptr + index[0]) + trailing[0];
        } else {
            byte[] p = new byte[ITER_SIZEOF];
            OS.gtk_text_view_get_iter_at_location(this.handle, p, point.x, point.y);
            byte[] zero = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
            int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, zero, p, true);
            position = OS.g_utf8_offset_to_utf16_offset(ptr, OS.gtk_text_iter_get_offset(p));
            OS.g_free(ptr);
        }
        return this.untranslateOffset(position);
    }

    public Point getSelection() {
        Point selection;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, start, end);
            int ptr = OS.gtk_entry_get_text(this.handle);
            start[0] = OS.g_utf8_offset_to_utf16_offset(ptr, start[0]);
            end[0] = OS.g_utf8_offset_to_utf16_offset(ptr, end[0]);
            selection = new Point(start[0], end[0]);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, startIter, endIter);
            byte[] zero = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
            int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, zero, endIter, true);
            int start = OS.g_utf8_offset_to_utf16_offset(ptr, OS.gtk_text_iter_get_offset(startIter));
            int end = OS.g_utf8_offset_to_utf16_offset(ptr, OS.gtk_text_iter_get_offset(endIter));
            OS.g_free(ptr);
            selection = new Point(start, end);
        }
        selection.x = this.untranslateOffset(selection.x);
        selection.y = this.untranslateOffset(selection.y);
        return selection;
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point selection = this.getSelection();
        return Math.abs(selection.y - selection.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        Point selection = this.getSelection();
        return this.getText().substring(selection.x, selection.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int tabs) {
        byte[] buffer = Converter.wcsToMbcs(null, " ", true);
        int layout = OS.gtk_widget_create_pango_layout(this.handle, buffer);
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size(layout, width, height);
        OS.g_object_unref(layout);
        return width[0] * tabs;
    }

    public String getText() {
        return new String(this.getTextChars());
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        String str = this.getText();
        int length = str.length();
        if (start > (end = Math.min(end, length - 1))) {
            return "";
        }
        start = Math.max(0, start);
        return str.substring(start, end + 1);
    }

    public char[] getTextChars() {
        int address;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            address = OS.gtk_entry_get_text(this.handle);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, start, end);
            address = OS.gtk_text_buffer_get_text(this.bufferHandle, start, end, true);
        }
        if (address == 0) {
            return new char[0];
        }
        int length = OS.strlen(address);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, address, length);
        if ((this.style & 2) != 0) {
            OS.g_free(address);
        }
        char[] result = Converter.mbcsToWcs(null, buffer);
        Arrays.fill(buffer, (byte)0);
        if (this.segments != null) {
            result = this.deprocessText(result, 0, -1);
        }
        return result;
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return LIMIT;
        }
        int limit = OS.gtk_entry_get_max_length(this.handle);
        return limit == 0 ? 65535 : this.untranslateOffset(limit);
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect(this.handle, rect);
        OS.gtk_text_view_get_line_at_y(this.handle, position, rect.y, null);
        return OS.gtk_text_iter_get_line(position);
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect(this.handle, rect);
        int[] lineTop = new int[1];
        OS.gtk_text_view_get_line_at_y(this.handle, position, rect.y, lineTop);
        return lineTop[0];
    }

    int gtk_activate(int widget) {
        this.sendSelectionEvent(14);
        return 0;
    }

    int gtk_button_press_event(int widget, int event) {
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        if (!this.doubleClick) {
            switch (gdkEvent.type) {
                case 5: 
                case 6: {
                    return 1;
                }
            }
        }
        return result;
    }

    int gtk_changed(int widget) {
        boolean keyPress = false;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    keyPress = true;
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        if (keyPress) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        if ((this.style & 0x80) != 0 && (this.style & 0x100) != 0) {
            int ptr = OS.gtk_entry_get_text(this.handle);
            OS.gtk_entry_set_icon_sensitive(this.handle, 1, OS.g_utf16_strlen(ptr, -1) > 0);
        }
        return 0;
    }

    int gtk_commit(int imContext, int text) {
        if (text == 0) {
            return 0;
        }
        if ((this.style & 4) != 0 && !OS.gtk_editable_get_editable(this.handle)) {
            return 0;
        }
        int length = OS.strlen(text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove(buffer, text, length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        Arrays.fill(buffer, (byte)0);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0, 0, 9);
        int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0, 0, this.handle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
            Arrays.fill(buffer, (byte)0);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0, 0, 9);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0, 0, this.handle);
        if ((this.style & 4) != 0 && this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.handle, this.fixStart);
            OS.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0;
    }

    int gtk_delete_range(int widget, int iter1, int iter2) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        byte[] startIter = new byte[ITER_SIZEOF];
        byte[] endIter = new byte[ITER_SIZEOF];
        OS.memmove(startIter, iter1, startIter.length);
        OS.memmove(endIter, iter2, endIter.length);
        int start = OS.gtk_text_iter_get_offset(startIter);
        int end = OS.gtk_text_iter_get_offset(endIter);
        byte[] zero = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
        int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, zero, endIter, true);
        start = OS.g_utf8_offset_to_utf16_offset(ptr, start);
        end = OS.g_utf8_offset_to_utf16_offset(ptr, end);
        OS.g_free(ptr);
        String newText = this.verifyText("", start, end);
        if (newText == null) {
            OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, startIter, endIter);
            start = OS.gtk_text_iter_get_offset(startIter);
            end = OS.gtk_text_iter_get_offset(endIter);
            if (start != end) {
                this.fixStart = start;
                this.fixEnd = end;
            }
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
        } else if (newText.length() > 0) {
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.gtk_text_buffer_delete(this.bufferHandle, startIter, endIter);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.gtk_text_buffer_insert(this.bufferHandle, startIter, buffer, buffer.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
            Arrays.fill(buffer, (byte)0);
        }
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        int end;
        int start;
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        int ptr = OS.gtk_entry_get_text(this.handle);
        if (end_pos == -1) {
            end_pos = OS.g_utf8_strlen(ptr, -1);
        }
        if ((newText = this.verifyText("", start = OS.g_utf8_offset_to_utf16_offset(ptr, start_pos), end = OS.g_utf8_offset_to_utf16_offset(ptr, end_pos))) == null) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, newStart, newEnd);
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{end_pos};
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.gtk_editable_insert_text(this.handle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.gtk_editable_set_position(this.handle, pos[0]);
            Arrays.fill(buffer, (byte)0);
        }
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            GdkEvent event = new GdkEvent();
            OS.memmove(event, gdkEvent, GdkEvent.sizeof);
            switch (event.type) {
                case 12: {
                    GdkEventFocus gdkEventFocus = new GdkEventFocus();
                    OS.memmove(gdkEventFocus, gdkEvent, GdkEventFocus.sizeof);
                    if (gdkEventFocus.in != 0) break;
                    int settings = OS.gtk_settings_get_default();
                    OS.g_object_set(settings, OS.gtk_entry_select_on_focus, true, 0);
                }
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    void drawMessage(int cr) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 2, 0)) {
            return;
        }
        if ((this.style & 4) != 0 && this.message.length() > 0) {
            int str = OS.gtk_entry_get_text(this.handle);
            if (!OS.gtk_widget_has_focus(this.handle) && OS.strlen(str) == 0) {
                int window = this.paintWindow();
                int[] w = new int[1];
                int[] h = new int[1];
                this.gdk_window_get_size(window, w, h);
                GtkBorder innerBorder = Display.getEntryInnerBorder(this.handle);
                int width = w[0] - innerBorder.left - innerBorder.right;
                int height = h[0] - innerBorder.top - innerBorder.bottom;
                int context = OS.gtk_widget_get_pango_context(this.handle);
                int lang = OS.pango_context_get_language(context);
                int metrics = OS.pango_context_get_metrics(context, this.getFontDescription(), lang);
                int ascent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(metrics));
                int descent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(metrics));
                OS.pango_font_metrics_unref(metrics);
                byte[] buffer = Converter.wcsToMbcs(null, this.message, true);
                int layout = OS.gtk_widget_create_pango_layout(this.handle, buffer);
                int line = OS.pango_layout_get_line(layout, 0);
                PangoRectangle rect = new PangoRectangle();
                OS.pango_layout_line_get_extents(line, null, rect);
                rect.y = OS.PANGO_PIXELS(rect.y);
                rect.height = OS.PANGO_PIXELS(rect.height);
                rect.width = OS.PANGO_PIXELS(rect.width);
                int y = (height - ascent - descent) / 2 + ascent + rect.y;
                if (rect.height > height) {
                    y = (height - rect.height) / 2;
                } else if (y < 0) {
                    y = 0;
                } else if (y + rect.height > height) {
                    y = height - rect.height;
                }
                y += innerBorder.top;
                int x = innerBorder.left;
                boolean rtl = (this.style & 0x4000000) != 0;
                int alignment = this.style & 0x1024000;
                switch (alignment) {
                    case 16384: {
                        x = rtl ? width - rect.width : innerBorder.left;
                        break;
                    }
                    case 0x1000000: {
                        x = (width - rect.width) / 2;
                        break;
                    }
                    case 131072: {
                        x = rtl ? innerBorder.left : width - rect.width;
                    }
                }
                GdkColor textColor = new GdkColor();
                GdkColor baseColor = new GdkColor();
                if (OS.GTK3) {
                    int styleContext = OS.gtk_widget_get_style_context(this.handle);
                    GdkRGBA rgba = new GdkRGBA();
                    OS.gtk_style_context_get_color(styleContext, 8, rgba);
                    textColor.red = (short)(rgba.red * 65535.0);
                    textColor.green = (short)(rgba.green * 65535.0);
                    textColor.blue = (short)(rgba.blue * 65535.0);
                    Point thickness = this.getThickness(this.handle);
                    x += thickness.x;
                    y += thickness.y;
                } else {
                    int style = OS.gtk_widget_get_style(this.handle);
                    OS.gtk_style_get_text(style, 4, textColor);
                    OS.gtk_style_get_base(style, 0, baseColor);
                }
                if (OS.USE_CAIRO) {
                    int cairo = cr != 0 ? cr : OS.gdk_cairo_create(window);
                    Cairo.cairo_set_source_rgba(cairo, (float)(textColor.red & 0xFFFF) / 65535.0f, (float)(textColor.green & 0xFFFF) / 65535.0f, (float)(textColor.blue & 0xFFFF) / 65535.0f, 1.0);
                    Cairo.cairo_move_to(cairo, x, y);
                    OS.pango_cairo_show_layout(cairo, layout);
                    if (cr != cairo) {
                        Cairo.cairo_destroy(cairo);
                    }
                } else {
                    int gc = OS.gdk_gc_new(window);
                    OS.gdk_draw_layout_with_colors(window, gc, x, y, layout, textColor, baseColor);
                    OS.g_object_unref(gc);
                }
                OS.g_object_unref(layout);
            }
        }
    }

    int gtk_draw(int widget, int cairo) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        int result = super.gtk_draw(widget, cairo);
        this.drawMessage(cairo);
        return result;
    }

    int gtk_expose_event(int widget, int event) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        int result = super.gtk_expose_event(widget, event);
        this.drawMessage(0);
        return result;
    }

    int gtk_focus_out_event(int widget, int event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    int gtk_grab_focus(int widget) {
        int result = super.gtk_grab_focus(widget);
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            int settings = OS.gtk_settings_get_default();
            OS.g_object_set(settings, OS.gtk_entry_select_on_focus, false, 0);
        }
        return result;
    }

    int gtk_icon_release(int widget, int icon_pos, int event) {
        Event e = new Event();
        if (icon_pos == 0) {
            e.detail = 512;
        } else {
            e.detail = 256;
            OS.gtk_editable_delete_text(this.handle, 0, -1);
        }
        this.sendSelectionEvent(14, e, false);
        return 0;
    }

    int gtk_insert_text(int widget, int new_text, int new_text_length, int position) {
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if (new_text == 0 || new_text_length == 0) {
            return 0;
        }
        byte[] buffer = new byte[new_text_length];
        OS.memmove(buffer, new_text, buffer.length);
        String oldText = new String(Converter.mbcsToWcs(null, buffer));
        int[] pos = new int[1];
        OS.memmove(pos, position, 4);
        int ptr = OS.gtk_entry_get_text(this.handle);
        if (pos[0] == -1) {
            pos[0] = OS.g_utf8_strlen(ptr, -1);
        }
        int start = pos[0];
        int end = pos[0];
        if (this.fixStart != -1 && this.fixEnd != -1) {
            start = pos[0] = this.fixStart;
            end = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        if ((newText = this.verifyText(oldText, start = OS.g_utf8_offset_to_utf16_offset(ptr, start), end = OS.g_utf8_offset_to_utf16_offset(ptr, end))) != oldText) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, newStart, newEnd);
            if (newText != null) {
                if (newStart[0] != newEnd[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                    OS.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
                }
                byte[] buffer3 = Converter.wcsToMbcs(null, newText, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
                OS.gtk_editable_insert_text(this.handle, buffer3, buffer3.length, pos);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
                newStart[0] = newEnd[0] = pos[0];
            }
            pos[0] = newEnd[0];
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            OS.memmove(position, pos, 4);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        int result;
        boolean handleSegments = false;
        boolean segmentsCleared = false;
        if (this.hooks(49) || this.filters(49)) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, event, GdkEventKey.sizeof);
            if (gdkEvent.length > 0 && (gdkEvent.state & 0xC) == 0) {
                handleSegments = true;
                if (this.segments != null) {
                    this.clearSegments(true);
                    segmentsCleared = true;
                }
            }
        }
        if ((result = super.gtk_key_press_event(widget, event)) != 0) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1) {
            result = 1;
        }
        this.gdkEventKey = 0;
        if (handleSegments && (result != 0 || segmentsCleared)) {
            this.applySegments();
        }
        return result;
    }

    int gtk_populate_popup(int widget, int menu) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(menu, 2);
            OS.gtk_container_forall(menu, this.display.setDirectionProc, 2);
        }
        return 0;
    }

    int gtk_text_buffer_insert_text(int widget, int iter, int text, int length) {
        int start;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        OS.memmove(position, iter, position.length);
        int end = start = OS.gtk_text_iter_get_offset(position);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            start = this.fixStart;
            end = this.fixEnd;
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        byte[] zero = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, zero, 0);
        int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, zero, position, true);
        start = OS.g_utf8_offset_to_utf16_offset(ptr, start);
        end = OS.g_utf8_offset_to_utf16_offset(ptr, end);
        OS.g_free(ptr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, text, buffer.length);
        String oldText = new String(Converter.mbcsToWcs(null, buffer));
        String newText = this.verifyText(oldText, start, end);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        } else if (newText != oldText) {
            byte[] buffer1 = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.gtk_text_buffer_insert(this.bufferHandle, iter, buffer1, buffer1.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        }
        return 0;
    }

    void hookEvents() {
        int imContext;
        super.hookEvents();
        if ((this.style & 4) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.handle, OS.grab_focus, this.display.getClosure(23), false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
            if ((this.style & 0x80) != 0) {
                OS.g_signal_connect_closure(this.handle, OS.icon_release, this.display.getClosure(67), false);
            }
        } else {
            OS.g_signal_connect_closure(this.bufferHandle, OS.changed, this.display.getClosure(6), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.insert_text, this.display.getClosure(52), false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.delete_range, this.display.getClosure(12), false);
            OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
        }
        if ((imContext = this.imContext()) != 0) {
            OS.g_signal_connect_closure(imContext, OS.commit, this.display.getClosure(9), false);
            int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int mask = 17;
            OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0, 0, this.handle);
        }
        OS.g_signal_connect_closure(this.handle, OS.backspace, this.display.getClosure(70), false);
        OS.g_signal_connect_closure(this.handle, OS.backspace, this.display.getClosure(71), true);
        OS.g_signal_connect_closure(this.handle, OS.copy_clipboard, this.display.getClosure(72), false);
        OS.g_signal_connect_closure(this.handle, OS.copy_clipboard, this.display.getClosure(73), true);
        OS.g_signal_connect_closure(this.handle, OS.cut_clipboard, this.display.getClosure(74), false);
        OS.g_signal_connect_closure(this.handle, OS.cut_clipboard, this.display.getClosure(75), true);
        OS.g_signal_connect_closure(this.handle, OS.paste_clipboard, this.display.getClosure(76), false);
        OS.g_signal_connect_closure(this.handle, OS.paste_clipboard, this.display.getClosure(77), true);
        OS.g_signal_connect_closure(this.handle, OS.delete_from_cursor, this.display.getClosure(78), false);
        OS.g_signal_connect_closure(this.handle, OS.delete_from_cursor, this.display.getClosure(79), true);
        OS.g_signal_connect_closure(this.handle, OS.move_cursor, this.display.getClosure(80), false);
        OS.g_signal_connect_closure(this.handle, OS.move_cursor, this.display.getClosure(81), true);
        OS.g_signal_connect_closure(this.handle, OS.direction_changed, this.display.getClosure(82), true);
    }

    int imContext() {
        if (this.imContext != 0) {
            return this.imContext;
        }
        if ((this.style & 4) != 0) {
            return OS.GTK_ENTRY_IM_CONTEXT(this.handle);
        }
        return OS.GTK_TEXTVIEW_IM_CONTEXT(this.handle);
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.clearSegments(true);
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, start, end);
            OS.gtk_editable_delete_selection(this.handle);
            OS.gtk_editable_insert_text(this.handle, buffer, buffer.length, start);
            OS.gtk_editable_set_position(this.handle, start[0]);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            if (OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, start, end)) {
                OS.gtk_text_buffer_delete(this.bufferHandle, start, end);
            }
            OS.gtk_text_buffer_insert(this.bufferHandle, start, buffer, buffer.length);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, start);
            int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
        }
        this.applySegments();
    }

    int paintWindow() {
        if ((this.style & 4) != 0) {
            int window = super.paintWindow();
            int children = OS.gdk_window_get_children(window);
            if (children != 0) {
                do {
                    window = OS.g_list_data(children);
                } while ((children = OS.g_list_next(children)) != 0);
            }
            OS.g_list_free(children);
            return window;
        }
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_text_view_get_window(this.handle, 2);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_paste_clipboard(this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get(0);
            this.clearSegments(true);
            OS.gtk_text_buffer_paste_clipboard(this.bufferHandle, clipboard, null, OS.gtk_text_view_get_editable(this.handle));
            this.applySegments();
        }
    }

    void register() {
        int imContext;
        super.register();
        if (this.bufferHandle != 0) {
            this.display.addWidget(this.bufferHandle, this);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.addWidget(imContext, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
        this.message = null;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSegmentListener(SegmentListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, listener);
        this.clearSegments(true);
        this.applySegments();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_select_region(this.handle, 0, -1);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, start, 0);
            OS.gtk_text_buffer_get_end_iter(this.bufferHandle, end);
            OS.gtk_text_buffer_select_range(this.bufferHandle, start, end);
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        if (!OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, color);
        }
    }

    GdkColor getContextBackground() {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            if (this.background != null) {
                GdkColor color = new GdkColor();
                color.red = (short)(this.background.red * 65535.0);
                color.green = (short)(this.background.green * 65535.0);
                color.blue = (short)(this.background.blue * 65535.0);
                return color;
            }
            return this.display.COLOR_WIDGET_BACKGROUND;
        }
        return super.getContextBackground();
    }

    void setBackgroundColor(int context, int handle, GdkRGBA rgba) {
        this.background = rgba;
        if ((this.style & 2) != 0) {
            super.setBackgroundColor(context, handle, rgba);
            return;
        }
        this.setBackgroundColorGradient(context, handle, rgba);
    }

    void setCursor(int cursor) {
        int defaultCursor = 0;
        if (cursor == 0) {
            defaultCursor = OS.gdk_cursor_new(152);
        }
        super.setCursor(cursor != 0 ? cursor : defaultCursor);
        if (cursor == 0) {
            this.gdk_cursor_unref(defaultCursor);
        }
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_visibility(this.handle, echo == '\u0000');
            OS.gtk_entry_set_invisible_char(this.handle, echo);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_editable(this.handle, editable);
        } else {
            OS.gtk_text_view_set_editable(this.handle, editable);
        }
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        this.setTabStops(this.tabs);
    }

    void setForegroundColor(GdkColor color) {
        this.setForegroundColor(this.handle, color, false);
    }

    public void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            this.error(4);
        }
        this.message = message;
        if (OS.GTK_VERSION >= OS.VERSION(3, 2, 0) && (this.style & 4) != 0) {
            byte[] buffer = Converter.wcsToMbcs(null, message, true);
            OS.gtk_entry_set_placeholder_text(this.handle, buffer);
            return;
        }
        this.redraw(false);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(int start) {
        this.checkWidget();
        start = this.translateOffset(start);
        if ((this.style & 4) != 0) {
            int ptr = OS.gtk_entry_get_text(this.handle);
            start = OS.g_utf16_offset_to_utf8_offset(ptr, start);
            OS.gtk_editable_set_position(this.handle, start);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
            int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
            start = OS.g_utf16_offset_to_utf8_offset(ptr, start);
            OS.g_free(ptr);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, startIter, start);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, startIter);
            int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        if ((this.style & 4) != 0) {
            int ptr = OS.gtk_entry_get_text(this.handle);
            start = OS.g_utf16_offset_to_utf8_offset(ptr, start);
            end = OS.g_utf16_offset_to_utf8_offset(ptr, end);
            OS.gtk_editable_set_position(this.handle, start);
            OS.gtk_editable_select_region(this.handle, start, end);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, startIter, endIter);
            int ptr = OS.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
            start = OS.g_utf16_offset_to_utf8_offset(ptr, start);
            end = OS.g_utf16_offset_to_utf8_offset(ptr, end);
            OS.g_free(ptr);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, startIter, start);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, endIter, end);
            OS.gtk_text_buffer_select_range(this.bufferHandle, startIter, endIter);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (tabs < 0) {
            return;
        }
        this.tabs = tabs;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int tabs) {
        if ((this.style & 4) != 0) {
            return;
        }
        int tabWidth = this.getTabWidth(tabs);
        int tabArray = OS.pango_tab_array_new(1, false);
        OS.pango_tab_array_set_tab(tabArray, 0, 0, tabWidth);
        OS.gtk_text_view_set_tabs(this.handle, tabArray);
        OS.pango_tab_array_free(tabArray);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount())) == null) {
            return;
        }
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        this.setText(text);
    }

    public void setTextChars(char[] text) {
        this.checkWidget();
        if (text == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            String string = this.verifyText(new String(text), 0, this.getCharCount());
            if (string == null) {
                return;
            }
            text = new char[string.length()];
            string.getChars(0, text.length, text, 0);
        }
        this.setText(text);
    }

    void setText(char[] text) {
        this.clearSegments(false);
        if ((this.style & 4) != 0) {
            byte[] buffer = Converter.wcsToMbcs(null, text, true);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.gtk_entry_set_text(this.handle, buffer);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
            Arrays.fill(buffer, (byte)0);
        } else {
            byte[] buffer = Converter.wcsToMbcs(null, text, false);
            byte[] position = new byte[ITER_SIZEOF];
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.gtk_text_buffer_set_text(this.bufferHandle, buffer, buffer.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 52);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, position, 0);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, position);
            int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
            Arrays.fill(buffer, (byte)0);
        }
        this.sendEvent(24);
        if ((this.style & 0x80) != 0 && (this.style & 0x100) != 0) {
            OS.gtk_entry_set_icon_sensitive(this.handle, 1, true);
        }
        this.applySegments();
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_max_length(this.handle, this.segments != null ? Math.min(LIMIT, this.translateOffset(limit)) : limit);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        byte[] position = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_line(this.bufferHandle, position, index);
        OS.gtk_text_view_scroll_to_iter(this.handle, position, 0.0, true, 0.0, 0.0);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int mark = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
        mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
    }

    int translateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int i = 0;
        int nSegments = this.segments.length;
        while (i < nSegments && offset - i >= this.segments[i]) {
            ++offset;
            ++i;
        }
        return offset;
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                int imContext = this.imContext();
                if (imContext == 0) break;
                int[] preeditString = new int[1];
                OS.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0) break;
                int length = OS.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    int traversalCode(int key, GdkEventKey event) {
        int bits = super.traversalCode(key, event);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 65289 && event != null) {
                boolean next;
                boolean bl = next = (event.state & 1) == 0;
                if (next && (event.state & 4) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    int untranslateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int i = 0;
        int nSegments = this.segments.length;
        while (i < nSegments && offset > this.segments[i]) {
            --offset;
            ++i;
        }
        return offset;
    }

    String verifyText(String string, int start, int end) {
        if (string != null && string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    this.setKeyState(event, gdkEvent);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }

    int windowProc(int handle, int user_data) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch (user_data) {
                case 70: 
                case 72: 
                case 74: 
                case 76: {
                    this.clearSegments(true);
                    break;
                }
                case 71: 
                case 73: 
                case 75: 
                case 77: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(handle, user_data);
    }

    int windowProc(int handle, int arg0, int user_data) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch (user_data) {
                case 82: {
                    this.clearSegments(true);
                    this.applySegments();
                }
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }

    int windowProc(int handle, int arg0, int arg1, int user_data) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch (user_data) {
                case 78: {
                    this.clearSegments(true);
                    break;
                }
                case 79: {
                    this.applySegments();
                }
            }
        }
        return super.windowProc(handle, arg0, arg1, user_data);
    }

    int windowProc(int handle, int arg0, int arg1, int arg2, int user_data) {
        if (this.hooks(49) || this.filters(49) || this.segments != null) {
            switch (user_data) {
                case 80: {
                    if (arg0 != 1) break;
                    this.clearSegments(true);
                    break;
                }
                case 81: {
                    if (arg0 != 1) break;
                    this.applySegments();
                }
            }
        }
        return super.windowProc(handle, arg0, arg1, arg2, user_data);
    }
}

