/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;

public class BreakpointsDropAdapter
extends ViewerDropAdapter {
    private Item fTarget = null;
    private TreePath fPath = null;
    private BreakpointsView fView;

    protected BreakpointsDropAdapter(TreeViewer viewer) {
        super((Viewer)viewer);
        this.setFeedbackEnabled(false);
    }

    protected BreakpointsDropAdapter(TreeViewer viewer, BreakpointsView view) {
        this(viewer);
        this.fView = view;
    }

    public boolean performDrop(Object data) {
        if (this.getViewer() instanceof BreakpointsViewer) {
            return ((BreakpointsViewer)this.getViewer()).performDrop(this.fTarget, (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection());
        }
        if (this.fView != null) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            if (this.fPath != null && selection instanceof ITreeSelection && selection instanceof ITreeSelection) {
                return this.fView.performDrop(this.fPath, (ITreeSelection)LocalSelectionTransfer.getTransfer().getSelection());
            }
        }
        return false;
    }

    protected Object determineTarget(DropTargetEvent event) {
        this.fTarget = (Item)event.item;
        if (this.fTarget instanceof TreeItem) {
            ArrayList<Object> list = new ArrayList<Object>();
            TreeItem item = (TreeItem)this.fTarget;
            while (item != null) {
                list.add(item.getData());
                item = item.getParentItem();
            }
            this.fPath = new TreePath(list.toArray());
        } else {
            this.fPath = null;
        }
        return this.fTarget;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (this.getViewer() instanceof BreakpointsViewer) {
            return ((BreakpointsViewer)this.getViewer()).canDrop(this.fTarget, (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection());
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (this.fPath != null && selection instanceof ITreeSelection && selection instanceof ITreeSelection) {
            return this.fView.canDrop(this.fPath, (ITreeSelection)LocalSelectionTransfer.getTransfer().getSelection());
        }
        return false;
    }
}

