/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.evas;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class EvasTableProperties
extends HierarchyUIObjectProperties {
    private String homogeneous;
    private double[] align = new double[2];
    private int[] padding = new int[2];
    private boolean mirrored;
    private int colSize;
    private int rowSize;

    public EvasTableProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.homogeneous = this.getHomogeneousMessage(parser.getChar());
        this.align[0] = parser.getFloat();
        this.align[1] = parser.getFloat();
        this.padding[0] = parser.getInt();
        this.padding[1] = parser.getInt();
        this.mirrored = parser.getBoolean();
        this.colSize = parser.getInt();
        this.rowSize = parser.getInt();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("homogeneous", this.homogeneous));
        properties.add(new PropertyValue("align", "[" + this.align[0] + ", " + this.align[1] + "]"));
        properties.add(new PropertyValue("padding", "[" + this.padding[0] + ", " + this.padding[1] + "]"));
        properties.add(new PropertyValue("mirrored", Boolean.toString(this.mirrored)));
        properties.add(new PropertyValue("colSize", Integer.toString(this.colSize)));
        properties.add(new PropertyValue("rowSize", Integer.toString(this.rowSize)));
        return properties;
    }

    private String getHomogeneousMessage(int code) {
        switch (code) {
            case 0: {
                return "EVAS_OBJECT_TABLE_HOMOGENEOUS_NONE";
            }
            case 1: {
                return "EVAS_OBJECT_TABLE_HOMOGENEOUS_TABLE";
            }
            case 2: {
                return "EVAS_OBJECT_TABLE_HOMOGENEOUS_ITEM";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

