/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.common.explorer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.common.explorer.DAFileExplorerEmptyCellRenderer;
import org.tizen.dynamicanalyzer.ui.common.explorer.DAFileExplorerTableRenderer;
import org.tizen.dynamicanalyzer.ui.common.explorer.ExplorerUtil;
import org.tizen.dynamicanalyzer.ui.widgets.DAGrid;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableHeaderRenderer;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButton;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonClickEventListener;
import org.tizen.dynamicanalyzer.widgets.da.base.DAButton;
import org.tizen.dynamicanalyzer.widgets.da.base.DATextBox;

public class DAFileExplorer
extends Composite {
    private static int FAIL = -1;
    private static int FILE = 1;
    private static int DIRECTORY = 2;
    protected Grid table = null;
    protected DATextBox inputText = null;
    protected DACustomButton goButton = null;
    private File root = null;
    private File current = null;
    private File selected = null;
    protected String filter = null;
    private String selectionStr = null;
    private SelectionListener tableSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            GridItem[] selections = DAFileExplorer.this.table.getSelection();
            GridItem selection = selections[0];
            File file = (File)selection.getData(ExplorerUtil.DATA_FIEL_KEY);
            Logger.debug((Object)("Selected : " + file.getAbsolutePath()));
            DAFileExplorer.this.selected = file;
            String path = DAFileExplorer.this.selected.getAbsolutePath();
            DAFileExplorer.this.inputText.setText(path);
            DAFileExplorer.this.inputText.setBackground(ColorResources.WHITE);
            int length = path.length();
            DAFileExplorer.this.inputText.getControl().setSelection(length, length);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private MouseListener tableMouseListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (DAFileExplorer.this.selected.isDirectory()) {
                DAFileExplorer.this.current = DAFileExplorer.this.selected;
                DAFileExplorer.this.updateData();
            }
        }
    };
    private DACustomButtonClickEventListener goButtonClickListener = new DACustomButtonClickEventListener(){

        public void handleClickEvent(DACustomButton button) {
            DAFileExplorer.this.adjustInput();
        }
    };
    private KeyListener inputKeyListener = new KeyListener(){

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 13) {
                DAFileExplorer.this.adjustInput();
                DAFileExplorer.this.inputText.getControl().setSelection(DAFileExplorer.this.inputText.getText().length());
            }
        }

        public void keyPressed(KeyEvent e) {
        }
    };
    private FocusListener inputTextFocusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            GridItem[] selections = new GridItem[]{};
            DAFileExplorer.this.table.setSelection(selections);
            int length = DAFileExplorer.this.inputText.getText().length();
            DAFileExplorer.this.inputText.getControl().setSelection(0, length);
        }
    };

    public DAFileExplorer(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FormLayout());
        this.setBackground(ColorResources.DIALOG_BG_UPPER);
        this.inputText = new DATextBox((Composite)this, 4);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -80);
        data.height = 18;
        this.inputText.setLayoutData((Object)data);
        this.inputText.getControl().addKeyListener(this.inputKeyListener);
        this.inputText.getControl().addFocusListener(this.inputTextFocusListener);
        this.goButton = new DAButton((Composite)this, 0);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.inputText.getControl(), 5);
        data.right = new FormAttachment(100, -5);
        data.height = 22;
        this.goButton.setLayoutData((Object)data);
        this.goButton.setText("Go");
        this.goButton.addClickListener(this.goButtonClickListener);
        this.table = new DAGrid(this, 2560);
        this.table.setBackground(ColorResources.TABLE_CONTENTS_NORMAL);
        this.table.setForeground(ColorResources.TABLE_CONTENTS_FONT_COLOR);
        this.setColumns();
        this.table.setEmptyCellRenderer((GridCellRenderer)new DAFileExplorerEmptyCellRenderer());
        this.table.setItemHeight(40);
        data = new FormData();
        data.top = new FormAttachment((Control)this.inputText.getControl(), 7);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.table.setLayoutData((Object)data);
        this.table.addSelectionListener(this.tableSelectionListener);
        this.table.addMouseListener(this.tableMouseListener);
    }

    public void setColumns() {
        GridColumn fileColumn = new GridColumn(this.table, 0);
        fileColumn.setCellRenderer((GridCellRenderer)new DAFileExplorerTableRenderer());
        fileColumn.setHeaderRenderer((GridHeaderRenderer)new DATableHeaderRenderer());
        fileColumn.setText("File");
        fileColumn.setWidth(450);
    }

    public void updateData() {
        if (this.current == null) {
            if (this.root == null) {
                Logger.debug((Object)"Root is empty");
                return;
            }
            this.current = this.root;
        }
        this.table.removeAll();
        this.inputText.setText(this.current.getAbsolutePath());
        if (!this.current.getAbsolutePath().equals(this.root.getAbsolutePath())) {
            GridItem parentItem = new GridItem(this.table, 0);
            parentItem.setText(ExplorerUtil.PARENT_STR);
            parentItem.setData(ExplorerUtil.DATA_FIEL_KEY, (Object)this.current.getParentFile());
        }
        File[] children = this.current.listFiles();
        int selectionIndex = -1;
        if (children != null) {
            int index;
            GridItem item;
            File child;
            int size = children.length;
            int i = 0;
            while (i < size) {
                child = children[i];
                if (child.isDirectory()) {
                    item = new GridItem(this.table, 0);
                    item.setText(child.getName());
                    item.setData(ExplorerUtil.DATA_FIEL_KEY, (Object)child);
                    if (this.selectionStr != null && this.selectionStr.equals(child.getAbsolutePath())) {
                        index = this.table.indexOf(item);
                        this.table.setSelection(index);
                        this.selected = child;
                        this.inputText.setText(child.getAbsolutePath());
                        selectionIndex = index;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < size) {
                child = children[i];
                if (!child.isDirectory() && (this.filter == null || child.getName().contains(this.filter))) {
                    item = new GridItem(this.table, 0);
                    item.setText(child.getName());
                    item.setData(ExplorerUtil.DATA_FIEL_KEY, (Object)child);
                    if (this.selectionStr != null && this.selectionStr.equals(child.getAbsolutePath())) {
                        index = this.table.indexOf(item);
                        this.table.setSelection(index);
                        this.selected = child;
                        this.inputText.setText(child.getAbsolutePath());
                        selectionIndex = index;
                    }
                    this.table.getVerticalBar().setMaximum(size);
                    this.table.getVerticalBar().setSelection(selectionIndex);
                }
                ++i;
            }
        }
        this.table.update();
    }

    public void setRoot(String r) {
        if (r != null && !r.isEmpty()) {
            File rootDir = new File(r);
            if (!rootDir.exists() || !rootDir.isDirectory()) {
                Logger.debug((Object)"root path is invalid");
                return;
            }
            this.root = rootDir;
        }
    }

    public Grid getTable() {
        return this.table;
    }

    public List<File> getSelection() {
        String path;
        File file;
        GridItem[] selections = this.table.getSelection();
        ArrayList<File> files = new ArrayList<File>();
        if (selections.length > 0) {
            int i = 0;
            while (i < selections.length) {
                GridItem selection = selections[i];
                if (!selection.getText().equals(ExplorerUtil.PARENT_STR)) {
                    File entry = (File)selection.getData(ExplorerUtil.DATA_FIEL_KEY);
                    files.add(entry);
                }
                ++i;
            }
        } else if (this.inputText.getText() != null && !this.inputText.getText().isEmpty() && (file = new File(path = this.inputText.getText())) != null && file.exists()) {
            files.add(file);
        }
        return files;
    }

    private int setCurrent(String path) {
        int result = FAIL;
        if (path != null && !path.isEmpty()) {
            File file = new File(path);
            if (!file.exists()) {
                Logger.debug((Object)"invalid path");
                return result;
            }
            if (!file.isDirectory()) {
                this.current = file.getParentFile();
                this.selectionStr = file.getAbsolutePath();
                result = FILE;
            } else {
                this.current = file;
                this.selectionStr = "";
                result = DIRECTORY;
            }
            this.updateData();
            return result;
        }
        return result;
    }

    private void adjustInput() {
        String path = this.inputText.getText();
        if (path == null || path.isEmpty()) {
            Logger.debug((Object)"path must not empty");
            this.inputText.setText(this.current.getAbsolutePath());
            return;
        }
        int ret = this.setCurrent(path);
        if (ret != FAIL) {
            this.inputText.setBackground(ColorResources.WHITE);
        } else {
            this.inputText.setText(this.current.getAbsolutePath());
        }
    }

    public void setFilterString(String filter) {
        this.filter = filter;
    }
}

