/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.summary.warning;

import org.tizen.dynamicanalyzer.nl.SummaryLabels;

public enum WarningCase {
    DUPLICATE_OPEN(1, SummaryLabels.WARNING_CASE_PRE_FIX, SummaryLabels.WARNING_CASE_POST_FIX_DUPLICATE, SummaryLabels.WARNING_CASE_BRIEF_DUPLICATE),
    WITHOUT_USING(2, SummaryLabels.WARNING_CASE_PRE_FIX, SummaryLabels.WARNING_CASE_POST_FIX_NO_OPERATION, SummaryLabels.WARNING_CASE_BRIEF_NO_OPERATION),
    JOINABLE_LEAK(3, SummaryLabels.WARNING_CASE_PRE_FIX, SummaryLabels.WARNING_CASE_POST_FIX_JOINABLE_LEAK, SummaryLabels.WARNING_CASE_BRIEF_JOINABLE_LEAK),
    CLOSED_NETWORK_FD(4, SummaryLabels.WARNING_CASE_PRE_FIX, SummaryLabels.WARNING_CASE_POST_CLOSED_FD_FOR_FAILED_FD, SummaryLabels.WARNING_CASE_BRIEF_CLOSED_FD_FOR_FAILED_FD),
    CONCURRENT_ACCESS(5, SummaryLabels.WARNING_CASE_PRE_FIX, SummaryLabels.WARNING_CASE_POST_CONCURRENT_ACCESS, SummaryLabels.WARNING_CASE_BRIEF_CONCURRENT_ACCESS);

    private final int type;
    private final String prefix;
    private final String postfix;
    private final String shortMsg;

    private WarningCase(int type, String msgPrefix, String msgPostfix, String shortMsg) {
        this.type = type;
        this.prefix = msgPrefix;
        this.postfix = msgPostfix;
        this.shortMsg = shortMsg;
    }

    public int getType() {
        return this.type;
    }

    public String getMessage(String path) {
        return String.valueOf(this.prefix) + path + this.postfix;
    }

    public String getShortMessage() {
        return this.shortMsg;
    }

    public static String getShortWarningMessage(int type) {
        if (DUPLICATE_OPEN.getType() == type) {
            return DUPLICATE_OPEN.getShortMessage();
        }
        if (WITHOUT_USING.getType() == type) {
            return WITHOUT_USING.getShortMessage();
        }
        if (JOINABLE_LEAK.getType() == type) {
            return JOINABLE_LEAK.getShortMessage();
        }
        if (CLOSED_NETWORK_FD.getType() == type) {
            return CLOSED_NETWORK_FD.getShortMessage();
        }
        if (CONCURRENT_ACCESS.getType() == type) {
            return CONCURRENT_ACCESS.getShortMessage();
        }
        return "";
    }

    public static String getFullWarningMessage(String key, int type) {
        if (DUPLICATE_OPEN.getType() == type) {
            return DUPLICATE_OPEN.getMessage(key);
        }
        if (WITHOUT_USING.getType() == type) {
            return WITHOUT_USING.getMessage(key);
        }
        if (JOINABLE_LEAK.getType() == type) {
            return JOINABLE_LEAK.getMessage(key);
        }
        if (CLOSED_NETWORK_FD.getType() == type) {
            return CLOSED_NETWORK_FD.getMessage(key);
        }
        if (CONCURRENT_ACCESS.getType() == type) {
            return CONCURRENT_ACCESS.getMessage(key);
        }
        return "";
    }
}

