/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.resources.FontResources;
import org.tizen.dynamicanalyzer.ui.widgets.FilterDialog;
import org.tizen.dynamicanalyzer.ui.widgets.SearchDialog;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class DAAdvancedPopupMenu
extends DAPopupMenu {
    public static final int advancedMenuButtonSize = 16;
    public static final int advancedMenuButtonOffset = 3;
    public static final int advancedMenuWidthOffset = 87;
    public static final int advancedMenuHeightOffset = 5;
    private DATableComposite ownTable = null;

    public DAAdvancedPopupMenu(Composite parent) {
        super(parent);
        this.setFont(FontResources.CONTEXT_MENU_ITEM_FONT);
        this.setDefaultMenuItems();
    }

    public void setTable(DATableComposite table) {
        this.ownTable = table;
    }

    private void setDefaultMenuItems() {
        DAPopupMenuItem searchItem = new DAPopupMenuItem((DAPopupMenu)this);
        searchItem.setText(ADVANCED_MENU_ITEM.SEARCH.name);
        searchItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                        SearchDialog searchDialog = new SearchDialog(shell, DAAdvancedPopupMenu.this.ownTable);
                        searchDialog.open();
                    }
                });
            }
        });
        DAPopupMenuItem filterItem = new DAPopupMenuItem((DAPopupMenu)this);
        filterItem.setText(ADVANCED_MENU_ITEM.FILTER.name);
        filterItem.addListener(new DAPopupMenuListener(){

            public void widgetSelected(DAPopupMenuItem menuItem) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = WorkbenchUtil.getWorkbenchWindow().getShell();
                        FilterDialog filterDialog = new FilterDialog(shell, DAAdvancedPopupMenu.this.ownTable, -1);
                        filterDialog.open();
                    }
                });
            }
        });
    }

    public void setMouseListener() {
        this.getParent().getShell().addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
                DAAdvancedPopupMenu.this.closeChild();
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                DAAdvancedPopupMenu.this.closeChild();
            }

            public void shellActivated(ShellEvent e) {
            }
        });
        this.getParent().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                switch (e.button) {
                    case 1: {
                        DAAdvancedPopupMenu.this.closeParent();
                        break;
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public static enum ADVANCED_MENU_ITEM {
        SEARCH(0, AnalyzerLabels.ADVANCED_MENU_SEARCH),
        FILTER(1, AnalyzerLabels.ADVANCED_MENU_FILTER);

        public final int index;
        public final String name;

        private ADVANCED_MENU_ITEM(int index, String name) {
            this.index = index;
            this.name = name;
        }
    }
}

