/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.resources.ExclusionInstance;
import org.eclipse.cdt.core.resources.RefreshExclusion;
import org.eclipse.cdt.core.resources.RefreshExclusionFactory;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshScopeManager {
    public static final String EXCLUSION_CLASS = "exclusionClass";
    public static final Object EXCLUSION_FACTORY = "exclusionFactory";
    public static final String EXTENSION_ID = "RefreshExclusionFactory";
    public static final String FACTORY_CLASS = "factoryClass";
    public static final String FILE_VALUE = "FILE";
    private static RefreshScopeManager fInstance;
    public static final String FOLDER_VALUE = "FOLDER";
    public static final String INSTANCE_CLASS = "instanceClass";
    public static final String OTHER_VALUE = "OTHER";
    public static final String PROJECT_VALUE = "PROJECT";
    public static final String REFRESH_SCOPE_STORAGE_NAME = "refreshScope";
    public static final String RESOURCE_ELEMENT_NAME = "resource";
    public static final String RESOURCE_TYPE_ATTRIBUTE_NAME = "resourceType";
    public static final String VERSION_ELEMENT_NAME = "version";
    public static final String VERSION_NUMBER_ATTRIBUTE_NAME = "versionNumber";
    public static final String WORKSPACE_PATH_ATTRIBUTE_NAME = "workspacePath";
    private HashMap<String, RefreshExclusionFactory> fClassnameToExclusionFactoryMap = new HashMap();
    private boolean fIsLoaded = false;
    private boolean fIsLoading = false;
    private HashMap<IProject, LinkedHashSet<IResource>> fProjectToResourcesMap;
    private HashMap<IResource, List<RefreshExclusion>> fResourceToExclusionsMap;
    private int fVersion = 1;

    public static synchronized RefreshScopeManager getInstance() {
        if (fInstance == null) {
            fInstance = new RefreshScopeManager();
        }
        return fInstance;
    }

    private RefreshScopeManager() {
        this.loadExtensions();
        try {
            this.loadSettings();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 2 || event.getType() == 4) {
                    IProject project = event.getResource().getProject();
                    try {
                        if (project.exists() && project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
                            RefreshScopeManager.this.clearDataForProject(project);
                        }
                    }
                    catch (CoreException coreException) {}
                    return;
                }
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    try {
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                if (delta.getResource() instanceof IProject) {
                                    IProject project = (IProject)delta.getResource();
                                    if (delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0) {
                                        RefreshScopeManager.this.loadSettings(ResourcesPlugin.getWorkspace().getRoot(), project);
                                        return false;
                                    }
                                } else if (delta.getResource() instanceof IWorkspaceRoot) {
                                    return true;
                                }
                                return false;
                            }
                        });
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, 7);
    }

    public synchronized void addExclusion(IResource resource, RefreshExclusion exclusion) {
        this.getResourcesToExclusionsMap();
        List<RefreshExclusion> exclusions = this.fResourceToExclusionsMap.get(resource);
        if (exclusions == null) {
            exclusions = new LinkedList<RefreshExclusion>();
            this.fResourceToExclusionsMap.put(resource, exclusions);
        }
        exclusions.add(exclusion);
    }

    public synchronized void addResourceToRefresh(IProject project, IResource resource) {
        this.getProjectToResourcesMap();
        LinkedHashSet<Object> resourceSet = this.fProjectToResourcesMap.get(project);
        if (resourceSet == null) {
            resourceSet = new LinkedHashSet();
            this.fProjectToResourcesMap.put(project, resourceSet);
        }
        resourceSet.add(resource);
    }

    public synchronized void clearAllData() {
        this.clearAllResourcesToRefresh();
        this.clearAllExclusions();
        this.fIsLoaded = false;
    }

    public synchronized void clearAllExclusions() {
        if (this.fResourceToExclusionsMap != null) {
            this.fResourceToExclusionsMap.clear();
        }
    }

    public synchronized void clearAllResourcesToRefresh() {
        this.getProjectToResourcesMap();
        this.fProjectToResourcesMap.clear();
    }

    private synchronized void clearDataForProject(IProject project) {
        this.clearResourcesToRefresh(project);
        this.clearExclusionsForProject(project);
    }

    public synchronized void clearExclusions(IResource resource) {
        this.getResourcesToExclusionsMap();
        List<RefreshExclusion> exclusions = this.fResourceToExclusionsMap.get(resource);
        if (exclusions != null) {
            exclusions.clear();
        }
    }

    public synchronized void clearExclusionsForProject(IProject project) {
        this.getResourcesToExclusionsMap();
        LinkedList<IResource> resourcesToRemove = new LinkedList<IResource>();
        for (IResource resource : this.fResourceToExclusionsMap.keySet()) {
            IProject project2 = resource.getProject();
            if (!project2.equals((Object)project)) continue;
            resourcesToRemove.add(resource);
        }
        for (IResource resource : resourcesToRemove) {
            this.fResourceToExclusionsMap.remove(resource);
        }
    }

    public synchronized void clearResourcesToRefresh(IProject project) {
        this.getProjectToResourcesMap();
        Object resourceSet = null;
        this.fProjectToResourcesMap.put(project, (LinkedHashSet<IResource>)resourceSet);
    }

    public synchronized void deleteResourceToRefresh(IProject project, IResource resource) {
        this.getProjectToResourcesMap();
        LinkedHashSet<Object> resourceSet = this.fProjectToResourcesMap.get(project);
        if (resourceSet == null) {
            resourceSet = new LinkedHashSet();
            return;
        }
        resourceSet.remove(resource);
    }

    public synchronized RefreshExclusion getExclusionForClassName(String className) {
        RefreshExclusionFactory factory = this.getFactoryForClassName(className);
        if (factory == null) {
            return null;
        }
        return factory.createNewExclusion();
    }

    public synchronized List<RefreshExclusion> getExclusions(IResource resource) {
        this.getResourcesToExclusionsMap();
        List<RefreshExclusion> exclusions = this.fResourceToExclusionsMap.get(resource);
        if (exclusions == null) {
            exclusions = new LinkedList<RefreshExclusion>();
            this.fResourceToExclusionsMap.put(resource, exclusions);
        }
        return exclusions;
    }

    public synchronized RefreshExclusionFactory getFactoryForClassName(String className) {
        RefreshExclusionFactory factory = this.fClassnameToExclusionFactoryMap.get(className);
        return factory;
    }

    public synchronized ExclusionInstance getInstanceForClassName(String className) {
        RefreshExclusionFactory factory = this.getFactoryForClassName(className);
        if (factory == null) {
            return null;
        }
        return factory.createNewExclusionInstance();
    }

    private HashMap<IProject, LinkedHashSet<IResource>> getProjectToResourcesMap() {
        if (this.fProjectToResourcesMap == null) {
            this.fProjectToResourcesMap = new HashMap();
        }
        return this.fProjectToResourcesMap;
    }

    public IWorkspaceRunnable getRefreshRunnable(final IProject project) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            private void refreshResources(IResource resource, List<RefreshExclusion> exclusions, IProgressMonitor monitor) throws CoreException {
                if (resource instanceof IContainer) {
                    IContainer container = (IContainer)resource;
                    if (RefreshScopeManager.this.shouldResourceBeRefreshed(resource)) {
                        resource.refreshLocal(1, monitor);
                    }
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource child = iResourceArray[n2];
                        this.refreshResources(child, exclusions, monitor);
                        ++n2;
                    }
                }
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                List<IResource> resourcesToRefresh = RefreshScopeManager.this.getResourcesToRefresh(project);
                for (IResource resource : resourcesToRefresh) {
                    List<RefreshExclusion> exclusions = RefreshScopeManager.this.getExclusions(resource);
                    this.refreshResources(resource, exclusions, monitor);
                }
            }
        };
        return runnable;
    }

    public synchronized ISchedulingRule getRefreshSchedulingRule(IProject project) {
        return new MultiRule(this.getResourcesToRefresh(project).toArray(new ISchedulingRule[0]));
    }

    private HashMap<IResource, List<RefreshExclusion>> getResourcesToExclusionsMap() {
        if (this.fResourceToExclusionsMap == null) {
            this.fResourceToExclusionsMap = new HashMap();
        }
        return this.fResourceToExclusionsMap;
    }

    public synchronized List<IResource> getResourcesToRefresh(IProject project) {
        this.getProjectToResourcesMap();
        LinkedHashSet<Object> resources = this.fProjectToResourcesMap.get(project);
        if (resources == null) {
            resources = new LinkedHashSet();
            resources.add((IResource)project);
            this.fProjectToResourcesMap.put(project, resources);
        }
        return new LinkedList<IResource>(resources);
    }

    public int getVersion() {
        return this.fVersion;
    }

    public synchronized void loadExtensions() {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", EXTENSION_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension2 = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension2.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (configElement.getName().equals(EXCLUSION_FACTORY)) {
                        String exclusionClassName = configElement.getAttribute(EXCLUSION_CLASS);
                        String factoryClassName = configElement.getAttribute(FACTORY_CLASS);
                        String instanceClassName = configElement.getAttribute(INSTANCE_CLASS);
                        if (factoryClassName != null) {
                            try {
                                Object execExt = configElement.createExecutableExtension(FACTORY_CLASS);
                                if (execExt instanceof RefreshExclusionFactory) {
                                    RefreshExclusionFactory exclusionFactory = (RefreshExclusionFactory)execExt;
                                    if (exclusionClassName != null) {
                                        this.fClassnameToExclusionFactoryMap.put(exclusionClassName, exclusionFactory);
                                    }
                                    if (instanceClassName != null) {
                                        this.fClassnameToExclusionFactoryMap.put(instanceClassName, exclusionFactory);
                                    }
                                }
                            }
                            catch (CoreException e) {
                                CCorePlugin.log(e);
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public synchronized void loadSettings() throws CoreException {
        if (!this.fIsLoaded && !this.fIsLoading) {
            this.fIsLoading = true;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] iProjectArray = workspaceRoot.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                this.loadSettings(workspaceRoot, project);
                ++n2;
            }
            this.fIsLoaded = true;
            this.fIsLoading = false;
        }
    }

    public synchronized void loadSettings(IWorkspaceRoot workspaceRoot, IProject project) throws CoreException {
        if (project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
            ICStorageElement[] children;
            CProjectDescriptionManager descriptionManager = CProjectDescriptionManager.getInstance();
            ICProjectDescription projectDescription = descriptionManager.getProjectDescription(project, false);
            if (projectDescription == null) {
                return;
            }
            ICStorageElement storageElement = projectDescription.getStorage(REFRESH_SCOPE_STORAGE_NAME, true);
            ICStorageElement[] iCStorageElementArray = children = storageElement.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String resourcePath;
                ICStorageElement child = iCStorageElementArray[n2];
                if (child.getName().equals(RESOURCE_ELEMENT_NAME) && (resourcePath = child.getAttribute(WORKSPACE_PATH_ATTRIBUTE_NAME)) != null) {
                    String resourceTypeString = child.getAttribute(RESOURCE_TYPE_ATTRIBUTE_NAME);
                    if (resourceTypeString == null) {
                        resourceTypeString = OTHER_VALUE;
                    }
                    Object resource = null;
                    resource = resourceTypeString.equals(PROJECT_VALUE) ? workspaceRoot.getProject(resourcePath) : (resourceTypeString.equals(FILE_VALUE) ? workspaceRoot.getFile((IPath)new Path(resourcePath)) : (resourceTypeString.equals(FOLDER_VALUE) ? workspaceRoot.getFolder((IPath)new Path(resourcePath)) : workspaceRoot.findMember(resourcePath)));
                    if (resource != null) {
                        this.addResourceToRefresh(project, (IResource)resource);
                        List<RefreshExclusion> exclusions = RefreshExclusion.loadData(child, null, (IResource)resource, this);
                        for (RefreshExclusion exclusion : exclusions) {
                            this.addExclusion((IResource)resource, exclusion);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public synchronized void persistSettings(ICProjectDescription projectDescription) throws CoreException {
        this.getProjectToResourcesMap();
        this.getResourcesToExclusionsMap();
        IProject project = projectDescription.getProject();
        if (!project.exists()) {
            return;
        }
        if (project.isOpen() && project.hasNature("org.eclipse.cdt.core.cnature")) {
            ICStorageElement storageElement = projectDescription.getStorage(REFRESH_SCOPE_STORAGE_NAME, true);
            storageElement.clear();
            storageElement.setAttribute(VERSION_NUMBER_ATTRIBUTE_NAME, Integer.toString(this.fVersion));
            for (IResource resource : this.fProjectToResourcesMap.get(project)) {
                ICStorageElement resourceElement = storageElement.createChild(RESOURCE_ELEMENT_NAME);
                resourceElement.setAttribute(WORKSPACE_PATH_ATTRIBUTE_NAME, resource.getFullPath().toString());
                String resourceTypeString = null;
                resourceTypeString = resource instanceof IFile ? FILE_VALUE : (resource instanceof IFolder ? FOLDER_VALUE : (resource instanceof IProject ? PROJECT_VALUE : OTHER_VALUE));
                resourceElement.setAttribute(RESOURCE_TYPE_ATTRIBUTE_NAME, resourceTypeString);
                List<RefreshExclusion> exclusions = this.fResourceToExclusionsMap.get(resource);
                if (exclusions == null) continue;
                for (RefreshExclusion exclusion : exclusions) {
                    exclusion.persistData(resourceElement);
                }
            }
        }
    }

    public synchronized void removeExclusion(IResource resource, RefreshExclusion exclusion) {
        this.getResourcesToExclusionsMap();
        List<RefreshExclusion> exclusions = this.fResourceToExclusionsMap.get(resource);
        if (exclusions == null) {
            exclusions = new LinkedList<RefreshExclusion>();
            this.fResourceToExclusionsMap.put(resource, exclusions);
        }
        exclusions.remove(exclusion);
    }

    public synchronized void setExclusions(IResource resource, List<RefreshExclusion> newExclusions) {
        this.getResourcesToExclusionsMap();
        LinkedList<RefreshExclusion> exclusions = new LinkedList<RefreshExclusion>(newExclusions);
        this.fResourceToExclusionsMap.put(resource, exclusions);
    }

    public synchronized void setResourcesToRefresh(IProject project, List<IResource> resources) {
        this.getProjectToResourcesMap();
        LinkedHashSet<IResource> resourceSet = new LinkedHashSet<IResource>(resources);
        this.fProjectToResourcesMap.put(project, resourceSet);
    }

    public synchronized boolean shouldResourceBeRefreshed(IResource resource) {
        IProject project = resource.getProject();
        List<IResource> resourcesToRefresh = this.getResourcesToRefresh(project);
        boolean isInSomeTree = false;
        IResource topLevelResource = null;
        for (IResource resourceToRefresh : resourcesToRefresh) {
            IContainer container;
            if (resourceToRefresh.equals((Object)resource)) {
                isInSomeTree = true;
                topLevelResource = resource;
                break;
            }
            if (!(resourceToRefresh instanceof IContainer) || !(container = (IContainer)resourceToRefresh).getFullPath().isPrefixOf(resource.getFullPath())) continue;
            isInSomeTree = true;
            topLevelResource = resourceToRefresh;
            break;
        }
        if (!isInSomeTree) {
            return false;
        }
        boolean isExcluded = false;
        for (RefreshExclusion exclusion : this.getExclusions(topLevelResource)) {
            if (!exclusion.testExclusionChain(resource)) continue;
            isExcluded = true;
            break;
        }
        return !isExcluded;
    }
}

