/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.TizenAbstractButtonRenderer;
import org.eclipse.swt.custom.TizenButton;
import org.eclipse.swt.custom.TizenButtonAttribute;
import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TizenRadioButtonRenderer
extends TizenAbstractButtonRenderer {
    public static final int SELECTED = 0;
    public static final int SELECTED_HOVER = 1;
    public static final int UNSELECTED = 2;
    public static final int UNSELECTED_HOVER = 3;
    public static final int SELECTED_DISABLE = 4;
    public static final int UNSELECTED_DISABLE = 5;

    TizenRadioButtonRenderer(TizenButton parent, Composite parentComposite) {
        super(parent, parentComposite);
        this.setPushButtonDefaultColors();
    }

    private void setPushButtonDefaultColors() {
        this.parent.attr.setForeGroundColor(0, TizenResourceManager.RADIO_BUTTON_SELECT_COLOR);
        this.parent.attr.setForeGroundColor(1, TizenResourceManager.RADIO_BUTTON_SELECT_COLOR);
        this.parent.attr.setForeGroundColor(4, TizenResourceManager.RADIO_BUTTON_DIMMED_FONT_COLOR);
        this.parent.attr.setForeGroundColor(2, TizenResourceManager.RADIO_BUTTON_NORMAL_FONT_COLOR);
        this.parent.attr.setForeGroundColor(3, TizenResourceManager.RADIO_BUTTON_NORMAL_FONT_COLOR);
        this.parent.attr.setForeGroundColor(5, TizenResourceManager.RADIO_BUTTON_DIMMED_FONT_COLOR);
    }

    public Listener getMouseListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 6: 
                    case 32: {
                        if (!TizenRadioButtonRenderer.this.isWidgetEnable) break;
                        if (TizenRadioButtonRenderer.this.getButtonState() != 0) {
                            TizenRadioButtonRenderer.this.setButtonState(3);
                        }
                        TizenRadioButtonRenderer.this.parent.redraw();
                        break;
                    }
                    case 7: {
                        if (!TizenRadioButtonRenderer.this.isWidgetEnable) break;
                        if (TizenRadioButtonRenderer.this.getButtonState() != 0) {
                            TizenRadioButtonRenderer.this.setButtonState(2);
                        }
                        TizenRadioButtonRenderer.this.parent.redraw();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        if (!TizenRadioButtonRenderer.this.isWidgetEnable || !TizenRadioButtonRenderer.this.isHover()) break;
                        if (TizenRadioButtonRenderer.this.getButtonState() == 0) {
                            TizenRadioButtonRenderer.this.setButtonState(3);
                        } else {
                            TizenRadioButtonRenderer.this.setButtonState(0);
                        }
                        TizenRadioButtonRenderer.this.parent.redraw();
                        TizenRadioButtonRenderer.this.selectRadio();
                        TizenRadioButtonRenderer.this.parent.fireSelectionEvent();
                        break;
                    }
                    case 9: {
                        TizenRadioButtonRenderer.this.drawButton(event);
                    }
                }
            }
        };
    }

    protected void setBackground(Color color) {
        this.parent.attr.setBackGroundColor(0, color);
        this.parent.attr.setBackGroundColor(1, color);
        this.parent.attr.setBackGroundColor(4, color);
        this.parent.attr.setBackGroundColor(2, color);
        this.parent.attr.setBackGroundColor(3, color);
        this.parent.attr.setBackGroundColor(5, color);
    }

    protected void setForeground(Color color) {
        this.parent.attr.setForeGroundColor(0, color);
        this.parent.attr.setForeGroundColor(1, color);
        this.parent.attr.setForeGroundColor(4, color);
        this.parent.attr.setForeGroundColor(2, color);
        this.parent.attr.setForeGroundColor(3, color);
        this.parent.attr.setForeGroundColor(5, color);
    }

    protected void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            if (this.getButtonState() == 4) {
                this.setButtonState(0);
            } else if (this.getButtonState() == 5) {
                this.setButtonState(2);
            }
        } else if (this.getButtonState() == 0) {
            this.setButtonState(4);
        } else if (this.getButtonState() == 2) {
            this.setButtonState(5);
        }
        this.parent.redraw();
    }

    protected void setSelection(boolean selected) {
        if (selected) {
            if (this.isWidgetEnable) {
                this.setButtonState(0);
            } else {
                this.setButtonState(4);
            }
        } else if (this.isWidgetEnable) {
            this.setButtonState(2);
        } else {
            this.setButtonState(5);
        }
        this.parent.redraw();
    }

    protected boolean getSelection() {
        return this.getButtonState() == 0 || this.getButtonState() == 4;
    }

    protected boolean setFocus() {
        this.isFocus = true;
        if (this.getButtonState() == 2) {
            this.setButtonState(3);
        }
        this.parent.redraw();
        return true;
    }

    protected boolean removeFocus() {
        this.isFocus = false;
        if (this.getButtonState() == 3) {
            this.setButtonState(2);
        }
        this.parent.redraw();
        return false;
    }

    private void selectRadio() {
        if (!this.parent.isEqualsType(this.parent.getStyle(), 16)) {
            return;
        }
        Control[] controlArray = this.parentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Button && ((Button)child).isEqualsType(child.getStyle(), 16)) {
                if (this.parent == child) {
                    ((Button)child).setButtonState(0);
                } else {
                    ((Button)child).setButtonState(2);
                }
                ((Button)child).redraw();
            }
            ++n2;
        }
    }

    protected Image getImage(int state) {
        switch (this.getButtonState()) {
            case 0: {
                return TizenResourceManager.getInstance().radioSelected;
            }
            case 1: {
                return TizenResourceManager.getInstance().radioSelectedHover;
            }
            case 4: {
                return TizenResourceManager.getInstance().radioSelectedDisable;
            }
            case 2: {
                return TizenResourceManager.getInstance().radioUnselected;
            }
            case 3: {
                return TizenResourceManager.getInstance().radioUnelectedHover;
            }
            case 5: {
                return TizenResourceManager.getInstance().radioUnselectedDisable;
            }
        }
        return TizenResourceManager.getInstance().radioUnselected;
    }

    protected void drawButton(Event e) {
        TizenButton me = (TizenButton)e.widget;
        Rectangle rect = me.getClientArea();
        int x = 0;
        int y = 0;
        this.drawBackground(e.gc, rect, this.parent.getAttribute());
        Image img = this.getImage(this.getButtonState());
        if (img != null) {
            Rectangle imgRect = img.getBounds();
            y = (rect.height - imgRect.height) / 2;
            e.gc.drawImage(img, x, y);
            int fontHeight = e.gc.getFontMetrics().getHeight();
            x = imgRect.width + 6;
            y = (rect.height - fontHeight) / 2;
        }
        if (this.parent.getAttribute().getForeGroundcolor(this.getButtonState()) != null) {
            e.gc.setForeground(this.parent.getAttribute().getForeGroundcolor(this.getButtonState()));
        } else {
            e.gc.setForeground(this.parent.getForeground());
        }
        if (this.parent.getAttribute().getFont() != null) {
            e.gc.setFont(this.parent.getAttribute().getFont());
        }
        if (this.parent.getText() != null) {
            e.gc.drawText(this.parent.getText(), x, y);
        }
    }

    private void drawBackground(GC gc, Rectangle rect, TizenButtonAttribute attr) {
        if (this.parent.getBackground() != null) {
            gc.setBackground(this.parent.getBackground());
        } else {
            gc.setBackground(TizenResourceManager.WHITE_COLOR);
        }
        gc.fillRectangle(rect);
    }
}

