/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.TizenResourceManager;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.OriginalText;
import org.eclipse.swt.widgets.TypedListener;

public class TizenText
extends Canvas {
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";
    private static final int STATE_NORMAL = 0;
    private static final int STATE_PUSH = 1;
    private static final int STATE_HOVER = 2;
    private static final int STATE_DISABLE = 3;
    protected OriginalText text = null;
    private int textState = 0;
    private int textStyle = 0;

    public TizenText(Composite parent, int style) {
        super(parent, TizenText.removeStyleOfContainer(style | 0x20000000));
        this.textStyle = style;
        this.setLayout(new GridLayout(1, false));
        this.text = new OriginalText(this, TizenText.removeBorderStyle(style));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.text.setLayoutData(gridData);
        this.text.setFont(TizenResourceManager.NORMAL_FONT);
        this.addEventListener();
    }

    static int removeBorderStyle(int style) {
        if ((style & 0x800) != 0) {
            return style -= 2048;
        }
        return style;
    }

    static int removeStyleOfContainer(int style) {
        int returnStyle = style;
        if ((style & 0x800) != 0) {
            returnStyle -= 2048;
        }
        if ((style & 0x200) != 0) {
            returnStyle -= 512;
        }
        if ((style & 0x100) != 0) {
            returnStyle -= 256;
        }
        return returnStyle;
    }

    private void addEventListener() {
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                TizenText.this.textState = 0;
                TizenText.this.redraw();
            }

            public void focusGained(FocusEvent e) {
                TizenText.this.textState = 2;
                TizenText.this.redraw();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TizenText.this.paint(e);
            }
        });
    }

    private void paint(PaintEvent event) {
        GC gc = event.gc;
        Rectangle rect = this.getClientArea();
        this.changeFontColor();
        if ((this.textStyle & 0x800) != 0) {
            this.drawBorder(gc, rect);
        }
    }

    private void drawBorder(GC gc, Rectangle rect) {
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        this.setBorderColor(gc);
        gc.drawRectangle(r);
    }

    private void setBorderColor(GC gc) {
        switch (this.textState) {
            case 0: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_NORMAL_COLOR);
                break;
            }
            case 1: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_PUSH_COLOR);
                break;
            }
            case 2: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_HOVER_COLOR);
                break;
            }
            case 3: {
                gc.setForeground(TizenResourceManager.COMBO_LINE_DISABLE_COLOR);
            }
        }
    }

    private void changeFontColor() {
        switch (this.textState) {
            case 0: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(TizenResourceManager.COMBO_FONT_NORMAL_COLOR);
                break;
            }
            case 1: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(TizenResourceManager.COMBO_FONT_PUSH_COLOR);
                break;
            }
            case 2: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(TizenResourceManager.COMBO_FONT_HOVER_COLOR);
                break;
            }
            case 3: {
                this.text.setBackground(this.getBackground());
                this.text.setForeground(TizenResourceManager.COMBO_FONT_DISABLE_COLOR);
            }
        }
    }

    private void fireSelectionEvent(Event e, int eventType) {
        e.item = this;
        e.widget = this;
        this.notifyListeners(eventType, e);
    }

    private void hookingListener(SWTEventListener listener, int eventType) {
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(eventType, typedListener);
    }

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
        final int event = eventType;
        if (eventType == 9) {
            return;
        }
        this.text.addListener(eventType, new Listener(){

            public void handleEvent(Event e) {
                TizenText.this.fireSelectionEvent(e, event);
            }
        });
    }

    public void addModifyListener(ModifyListener listener) {
        this.hookingListener(listener, 24);
    }

    public void addSegmentListener(SegmentListener listener) {
        this.hookingListener(listener, 49);
        this.text.addSegmentListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.hookingListener(listener, 13);
        this.hookingListener(listener, 14);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.hookingListener(listener, 25);
    }

    public void append(String string) {
        this.text.append(string);
    }

    public void clearSelection() {
        this.text.clearSelection();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point returnComputeSize = super.computeSize(wHint, hHint, changed);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.equals("linux")) {
            returnComputeSize.y -= 10;
        }
        return returnComputeSize;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return super.computeTrim(x, y, width, height);
    }

    public void copy() {
        this.text.copy();
    }

    public void cut() {
        this.text.copy();
    }

    public int getBorderWidth() {
        return super.getBorderWidth();
    }

    public int getCaretLineNumber() {
        return this.text.getCaretLineNumber();
    }

    public Point getCaretLocation() {
        return this.text.getCaretLocation();
    }

    public int getCaretPosition() {
        return this.text.getCaretPosition();
    }

    public int getCharCount() {
        return this.text.getCharCount();
    }

    public boolean getDoubleClickEnabled() {
        return this.text.getDoubleClickEnabled();
    }

    public char getEchoChar() {
        return this.text.getEchoChar();
    }

    public boolean getEditable() {
        return this.text.getEditable();
    }

    public int getLineCount() {
        return this.text.getLineCount();
    }

    public String getLineDelimiter() {
        return this.text.getLineDelimiter();
    }

    public int getLineHeight() {
        return this.text.getLineHeight();
    }

    public int getOrientation() {
        return super.getOrientation();
    }

    public String getMessage() {
        return this.text.getMessage();
    }

    public Point getSelection() {
        return this.text.getSelection();
    }

    public int getSelectionCount() {
        return this.text.getSelectionCount();
    }

    public String getSelectionText() {
        return this.text.getSelectionText();
    }

    public int getTabs() {
        return this.text.getTabs();
    }

    public String getText() {
        return this.text.getText();
    }

    public char[] getTextChars() {
        return this.text.getTextChars();
    }

    public String getText(int start, int end) {
        return this.text.getText(start, end);
    }

    public int getTextLimit() {
        return this.text.getTextLimit();
    }

    public int getTopIndex() {
        return this.text.getTopIndex();
    }

    public int getTopPixel() {
        return this.text.getTopPixel();
    }

    public void insert(String string) {
        this.text.insert(string);
    }

    public void paste() {
        this.text.paste();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.text.removeModifyListener(listener);
    }

    public void removeSegmentListener(SegmentListener listener) {
        this.text.removeSegmentListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.text.removeSelectionListener(listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.text.removeVerifyListener(listener);
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.text.setDoubleClickEnabled(doubleClick);
    }

    public void setEchoChar(char echo) {
        this.text.setEchoChar(echo);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }

    public void setFont(Font font) {
        this.text.setFont(font);
    }

    public void setMessage(String message) {
        this.text.setMessage(message);
    }

    public void setOrientation(int orientation) {
        this.text.setOrientation(orientation);
    }

    public void setSelection(int start) {
        this.text.setSelection(start);
    }

    public void setSelection(int start, int end) {
        this.text.setSelection(start, end);
    }

    public void setRedraw(boolean redraw) {
        this.text.setRedraw(redraw);
    }

    public void setSelection(Point selection) {
        this.text.setSelection(selection);
    }

    public void setTabs(int tabs) {
        this.text.setTabs(tabs);
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public void setTextChars(char[] text1) {
        this.text.setTextChars(text1);
    }

    public void setTextLimit(int limit) {
        this.text.setTextLimit(limit);
    }

    public void setTopIndex(int index) {
        this.text.setTopIndex(index);
    }

    public void showSelection() {
        this.text.showSelection();
    }
}

