/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.widgets.button.toggle;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonAttribute;
import org.tizen.dynamicanalyzer.widgets.button.DACustomButtonRenderer;
import org.tizen.dynamicanalyzer.widgets.helper.ColorResources;

public class DACustomToggleButtonRenderer
extends DACustomButtonRenderer {
    @Override
    public void draw(GC gc, Canvas canvas, int state, DACustomButtonAttribute attr) {
        Rectangle rect = canvas.getClientArea();
        if (attr.getDrawType() == 0) {
            Image image = attr.getImage(state);
            if (image == null) {
                return;
            }
            gc.drawImage(image, rect.x, rect.y);
            this.drawButtonText(gc, rect, attr, state);
        } else if (attr.getDrawType() == 1 || attr.getDrawType() == 2) {
            this.drawButton(gc, rect, state, attr);
            this.drawButtonToggleImage(gc, rect, state, attr);
        }
    }

    @Override
    protected void drawButton(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        if (attr.getDrawType() == 1) {
            gc.setBackground(attr.getColor(state));
            gc.fillRectangle(rect);
        } else {
            int index = state * 2;
            gc.setForeground(attr.getColor(index));
            gc.setBackground(attr.getColor(index + 1));
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
        }
        Rectangle r = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        this.drawButtonText(gc, r, attr, state);
        Color c = gc.getForeground();
        if (attr.getOutlineColor(state) != null) {
            gc.setForeground(attr.getOutlineColor(state));
            gc.drawRectangle(r);
        }
        Rectangle ir = new Rectangle(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
        if (attr.getOutlineInColor(state) != null) {
            gc.setForeground(attr.getOutlineInColor(state));
            gc.drawRectangle(ir);
        }
        gc.setForeground(c);
    }

    private void drawButtonToggleImage(GC gc, Rectangle rect, int state, DACustomButtonAttribute attr) {
        Point p = null;
        Image img = null;
        Rectangle imgRect = null;
        img = state < 4 ? attr.getButtonImage(0) : attr.getButtonImage(4);
        if (img != null) {
            imgRect = img.getBounds();
            int x = 0;
            int y = 0;
            p = attr.getButtonImagePoint();
            if (p == null) {
                int width = rect.width - imgRect.width;
                int height = rect.height - imgRect.height;
                if (width > 0) {
                    x = width / 2;
                } else {
                    Logger.debug((Object)("width size : " + width));
                }
                if (height > 0) {
                    y = height / 2;
                } else {
                    Logger.debug((Object)("height size : " + height));
                }
            } else {
                x = p.x;
                y = p.y;
            }
            gc.drawImage(img, x, y);
        }
    }

    @Override
    protected void drawButtonText(GC gc, Rectangle rect, DACustomButtonAttribute attr, int state) {
        String text = null;
        Font font = null;
        Rectangle textRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        if (attr.getIcon() != null) {
            Rectangle iconRect = attr.getIcon().getBounds();
            textRect.x += iconRect.width;
            textRect.width -= iconRect.width;
        }
        if ((text = attr.getText()) != null) {
            font = attr.getFont();
            if (font == null) {
                font = new Font((Device)Display.getCurrent(), "Arial", this.computeFontSize(textRect), 0);
                attr.setFont(font);
            }
            gc.setFont(font);
            int x = 0;
            int y = 0;
            int offset = 0;
            if (attr.getFontPoint() == null) {
                return;
            }
            offset = 2;
            x = textRect.x + textRect.width / 2;
            y = textRect.y + textRect.height / 2 / 2;
            if (attr.getFontColor(state) != null) {
                gc.setForeground(attr.getFontColor(state));
            } else {
                gc.setForeground(ColorResources.BLACK);
            }
            if (state == 1) {
                ++x;
                ++y;
            }
            gc.drawString(text, x + offset, y, true);
        }
    }
}

