/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.AbstractTableInformationControl;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class BasicPartList
extends AbstractTableInformationControl {
    private MElementContainer<?> input;
    private EPartService partService;
    private StackRenderer renderer;

    public BasicPartList(Shell parent, int shellStyle, int treeStyler, EPartService partService, MElementContainer<?> input, StackRenderer renderer, boolean mru) {
        super(parent, shellStyle, treeStyler);
        this.partService = partService;
        this.input = input;
        this.renderer = renderer;
        if (mru && this.getTableViewer() != null) {
            this.getTableViewer().setComparator(new ViewerComparator(){

                public int category(Object element) {
                    if (element instanceof MPart) {
                        MPart part = (MPart)element;
                        CTabItem item = BasicPartList.this.renderer.findItemForPart(part);
                        if (item != null && !item.isShowing()) {
                            return -1;
                        }
                    }
                    return 0;
                }
            });
        }
    }

    @Override
    protected TableViewer createTableViewer(Composite parent, int style) {
        Table table = new Table(parent, 4 | style & 0xFFFFFFFD);
        table.setLayoutData((Object)new GridData(1, 1, false, false));
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.addFilter((ViewerFilter)new AbstractTableInformationControl.NamePatternFilter(this));
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setLabelProvider((IBaseLabelProvider)new BasicStackListLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        return tableViewer;
    }

    private List<Object> getInput() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (MUIElement element : this.input.getChildren()) {
            if (element instanceof MPlaceholder) {
                if (!element.isToBeRendered() || !element.isVisible()) continue;
                element = ((MPlaceholder)element).getRef();
            }
            if (!element.isToBeRendered() || !element.isVisible() || !(element instanceof MPart)) continue;
            list.add(element);
        }
        return list;
    }

    public void setInput() {
        this.getTableViewer().setInput(this.getInput());
        this.selectFirstMatch();
    }

    @Override
    protected void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        this.dispose();
        if (selectedElement instanceof MPart) {
            this.partService.activate((MPart)selectedElement);
        }
    }

    @Override
    protected boolean deleteSelectedElements() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            if (this.partService.savePart((MPart)selectedElement, true)) {
                this.partService.hidePart((MPart)selectedElement);
            }
            if (this.getShell() == null) {
                return true;
            }
            if (this.getInput().isEmpty()) {
                this.getShell().dispose();
                return true;
            }
            List viewerInput = (List)this.getTableViewer().getInput();
            viewerInput.remove(selectedElement);
        }
        return false;
    }

    private class BasicStackListLabelProvider
    extends ColumnLabelProvider {
        private Font boldFont;

        public BasicStackListLabelProvider() {
            FontData[] fontDatas;
            Font font = Display.getDefault().getSystemFont();
            FontData[] fontDataArray = fontDatas = font.getFontData();
            int n = fontDatas.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fontData = fontDataArray[n2];
                fontData.setStyle(fontData.getStyle() | 1);
                ++n2;
            }
            this.boldFont = new Font((Device)Display.getDefault(), fontDatas);
        }

        public Font getFont(Object element) {
            if (element instanceof MPart) {
                MPart part = (MPart)element;
                CTabItem item = BasicPartList.this.renderer.findItemForPart(part);
                if (item != null && !item.isShowing()) {
                    return this.boldFont;
                }
            }
            return super.getFont(element);
        }

        public String getText(Object element) {
            if (element instanceof MDirtyable && ((MDirtyable)element).isDirty()) {
                return "*" + ((MUILabel)element).getLocalizedLabel();
            }
            return ((MUILabel)element).getLocalizedLabel();
        }

        public Image getImage(Object element) {
            return BasicPartList.this.renderer.getImage((MUILabel)element);
        }

        public String getToolTipText(Object element) {
            return ((MUILabel)element).getLocalizedTooltip();
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }

        public void dispose() {
            this.boldFont.dispose();
        }
    }
}

