/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.common;

import java.io.Serializable;
import org.tizen.dynamicanalyzer.nl.UserErrorWarningLabels;
import org.tizen.dynamicanalyzer.util.Logger;

public class DAResult
implements Serializable {
    private static final long serialVersionUID = 5201453771343228903L;
    public static final DAResult SUCCESS = new DAResult(ErrorCode.SUCCESS);
    private ErrorCode errCode;
    private String detailMsg;

    public DAResult(ErrorCode code) {
        this.errCode = code;
        this.detailMsg = null;
    }

    public DAResult(ErrorCode code, String msg) {
        this.errCode = code;
        this.detailMsg = msg;
    }

    public int getErrorNumber() {
        return this.errCode.getErrorNumber();
    }

    public void setDetailMessage(String message) {
        this.detailMsg = message;
    }

    public String getMessage() {
        StringBuffer message = new StringBuffer(this.errCode.getErrorMessage());
        if (this.detailMsg != null) {
            message.append("\n");
            message.append(this.detailMsg);
        }
        return message.toString();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.errCode != ErrorCode.SUCCESS) {
            str.append("[ERROR : ");
        } else {
            str.append("[SUCCESS : ");
        }
        str.append(String.valueOf(this.errCode.errMessage) + "]");
        if (this.detailMsg != null) {
            str.append("\n[DETAIL : ");
            str.append(String.valueOf(this.detailMsg) + "]");
        }
        return str.toString();
    }

    public boolean equals(Object target) {
        if (target instanceof DAResult) {
            DAResult res = (DAResult)target;
            return res.errCode == this.errCode;
        }
        if (target instanceof ErrorCode) {
            ErrorCode code = (ErrorCode)((Object)target);
            return code == this.errCode;
        }
        return false;
    }

    public boolean isSuccess() {
        return this.errCode == ErrorCode.SUCCESS;
    }

    private static String getMethodName(int depth) {
        StackTraceElement[] elements = null;
        try {
            throw new Exception("exception for method name");
        }
        catch (Exception e) {
            elements = e.getStackTrace();
            String methodName = elements[depth].getMethodName();
            return methodName;
        }
    }

    public void printDebug() {
        String method = String.valueOf(DAResult.getMethodName(2)) + "()";
        StringBuffer str = new StringBuffer();
        if (this.errCode != ErrorCode.SUCCESS) {
            str.append("[ERROR : ");
        } else {
            str.append("[SUCCESS : ");
        }
        str.append(String.valueOf(this.errCode.errMessage) + "   ");
        if (method != null) {
            str.append("METHOD : " + method + " ]");
        }
        Logger.debug((Object)str.toString());
    }

    public ErrorCode getErrorCode() {
        return this.errCode;
    }

    public static enum ErrorCode {
        SUCCESS(0, "Success!"),
        ERR_EXCEPTION_OCCURRED(-1, "Exception is occurred."),
        ERR_INVALID_VERSION(-100, "Protocol version is not supported or invalid."),
        ERR_REMOTE_PORT_GET_FAILED(-101, "Communicator failed to get remote port."),
        ERR_CONTROL_SOCKET_CREATION_FAIL(-102, "Communicator failed to create Control Socket."),
        ERR_DATA_SOCKET_CREATION_FAIL(-103, "Communicator failed to create Data Socket."),
        ERR_CONTROL_SOCKET_CONNECTION_CLOSED(-104, "Connection closed."),
        ERR_PROTOCOL_NOT_SUPPORTED(-105, "Protocol is not supported by current communicator."),
        ERR_FILE_IS_NOT_EXISTS(-201, "File is not exist."),
        ERR_UPLOAD_FILE_FAILED(-202, "File upload is failed."),
        ERR_SDB_PUSH_FAILED(-203, "Sdb push is failed."),
        ERR_READELF_SIZE_GET_FAILED(-204, "Readelf size get failed."),
        ERR_READELF_UPLOAD_FAILED(-205, "Readelf file size is different."),
        ERR_MSG_STOP_FAIL(-502, "Communicator failed to send 'Trace Stop Message'."),
        ERR_MSG_RUNTIME_FAIL(-503, "Runtime message is not ok."),
        ERR_TARGET_INFO_GET_FAIL(-505, "Communicator failed to send 'Target Info Message'."),
        ERR_KEEP_ALIVE(-506, "Communicator failed to send 'Keep Alive Message'."),
        ERR_RECEIVE_ACK_FAIL(-508, "Communicator failed to receive 'Ack Message'."),
        ERR_PROCESS_ADD_INFO_GET_FAIL(-509, "Communicator failed to get 'process add info'."),
        ERR_SWAP_INSTRUMENTATION_FAIL(-510, "Communicator failed to send 'Instrument Message'."),
        ERR_DA_IS_EXIT(-901, "Dynamic Analyzer is closing."),
        ERR_OUT_OF_MEMORY(-1001, UserErrorWarningLabels.ERROR_OUT_OF_MEMORY),
        ERR_NO_DEVICE(-1010, UserErrorWarningLabels.ERROR_DEVICE_NOT_FOUND),
        ERR_DISCONNECTED(-1011, UserErrorWarningLabels.ERROR_DEVICE_CONNECTION),
        ERR_NOT_SUPPORTED(-1012, UserErrorWarningLabels.ERROR_DEVICE_NOT_SUPPORTED),
        ERR_BUSY_DEVICE(-1013, UserErrorWarningLabels.ERROR_DEVICE_IS_BUSY),
        ERR_TRACING_NOT_RUNNING(-1014, UserErrorWarningLabels.ERROR_TRACING_NOT_RUNNING),
        ERR_DEVICE_TARGET_MISMATCH(-1015, UserErrorWarningLabels.ERROR_DEVICE_TARGET_MISMATCH),
        ERR_NO_APP(-1020, UserErrorWarningLabels.ERROR_NONEXIST_APPLICATION),
        ERR_INVALID_APP(-1021, UserErrorWarningLabels.ERROR_UNSUPPORTED_APPLICATION),
        ERR_BY_SECURITY(-1030, UserErrorWarningLabels.ERROR_BY_SECURITY_REASON),
        ERR_BY_USER_CANCEL(-1031, UserErrorWarningLabels.WARNING_USER_CANCEL),
        ERR_CONFIG_FAILED(-1100, UserErrorWarningLabels.ERROR_CONFIGURATION_FAILED),
        ERR_LIB_NOTFOUND_INRPM(-1101, UserErrorWarningLabels.ERROR_LIB_NOT_FOUND_INRPM),
        ERR_RPM_NOTFOUND(-1102, UserErrorWarningLabels.ERROR_RPM_NOT_FOUND),
        ERR_START_DATA_CHANNEL(-2001, UserErrorWarningLabels.ERR_START_DATA_CHANNEL),
        ERR_START_MESSAGE_PARSER(-2002, UserErrorWarningLabels.ERR_START_MESSAGE_PARSER),
        ERR_START_LOG_PARSER(-2003, UserErrorWarningLabels.ERR_START_LOG_PARSER),
        ERR_STOP_DATA_CHANNEL(-2004, UserErrorWarningLabels.ERROR_INTERNAL_REASON),
        ERR_STOP_MESSAGE_PARSER(-2005, UserErrorWarningLabels.ERROR_INTERNAL_REASON),
        ERR_STOP_LOG_PARSER(-2006, UserErrorWarningLabels.ERROR_INTERNAL_REASON),
        ERR_NO_PROCINFO(-2007, UserErrorWarningLabels.ERR_NO_PROCINFO),
        ERR_CONTINUITY_BROKEN(-2010, UserErrorWarningLabels.WARNING_OVERHEAD_EXPLODE),
        ERR_WRONG_MESSAGE_FORMAT(-2011, UserErrorWarningLabels.ERR_WRONG_MESSAGE_FORMAT),
        ERR_DATA_SOCKET_CLOSED(-2012, UserErrorWarningLabels.ERROR_CONNECTION_CLOSED),
        ERR_DOWNLOAD_FILE_FAILED(-2013, UserErrorWarningLabels.ERROR_DOWNLOAD_FILE_FAILED),
        ERR_DOWNLOAD_FILE_FAILED_DUETO_SECURITY(-2014, UserErrorWarningLabels.ERROR_DOWNLOAD_FILE_FAILED_DUETO_SECURITY),
        ERR_CANCEL_FAILED(-2015, UserErrorWarningLabels.ERROR_CANCEL_FAILED),
        ERR_MSG_START_FAIL(-2101, UserErrorWarningLabels.ERROR_START_TRACE_FAILED),
        ERR_MSG_SEND_FAIL(-2102, UserErrorWarningLabels.ERR_MSG_SEND_FAIL),
        ERR_BIN_INFO_GET_FAIL(-2103, UserErrorWarningLabels.ERROR_FAILED_OPERATION),
        ERR_SCREENSHOT_GET_FAIL(-2104, UserErrorWarningLabels.ERROR_SCREENSHOT_FAILED),
        ERR_UIHIERARCHY_GET_FAIL(-2201, UserErrorWarningLabels.ERROR_UIHIERARCHY_FAILED),
        ERR_UI_OBJECT_NOT_FOUND(-2202, UserErrorWarningLabels.ERROR_UI_OBJECT_NOT_FOUND),
        ERR_UI_OBJECT_CAN_NOT_TAKE_SCREENSHOT(-2203, UserErrorWarningLabels.ERROR_UI_OBJECT_SCREENSHOT_NOT_AVAILABLE),
        ERR_UIHIERARCHY_GET_CANCEL_FAIL(-2204, UserErrorWarningLabels.ERROR_UIHIERARCHY_CANCEL_FAILED),
        ERR_WEB_APP_WITH_UIHV(-2301, UserErrorWarningLabels.ERROR_WEB_APPLICATION_WITH_UIHV),
        ERR_UNKNOWN(-9999, UserErrorWarningLabels.ERROR_BY_UNKNOWN_REASON);

        private final int errNumber;
        private final String errMessage;

        private ErrorCode(int num, String msg) {
            this.errNumber = num;
            this.errMessage = msg;
        }

        public int getErrorNumber() {
            return this.errNumber;
        }

        public String getErrorMessage() {
            return this.errMessage;
        }

        public static ErrorCode getErrorCode(int num) {
            ErrorCode[] errorCodeArray = ErrorCode.values();
            int n = errorCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ErrorCode code = errorCodeArray[n2];
                if (code.errNumber == num) {
                    return code;
                }
                ++n2;
            }
            return null;
        }
    }
}

