/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.opengl.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.swap.model.data.GLES20LogData;
import org.tizen.dynamicanalyzer.ui.opengl.data.GLDataManager;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLRedundantDataType;
import org.tizen.dynamicanalyzer.ui.opengl.data.type.GLStatisticsDataType;

public class GLStatisticsDataManager {
    private static final String SPLIT = " | ";
    private static final String STATE_CHANGE = "State Change";
    private static final String MATRIX = "Matrix";
    private static final String TEXTURE = "Texture";
    private static final String DRAW = "Draw";
    private static final String PROGRAM_AND_SHADER = "Program and Shader";
    private static final String BUFFER = "Buffer";
    private static final String GET = "Get";
    private static final String IS = "Is";
    private static final String DELETE = "Delete";
    private static final String CLEAR = "Clear";
    private static final String BIND = "Bind";
    private static final String EVAS_GL = "evas_gl";
    private ConcurrentHashMap<String, GLRedundantDataType> redundantHsahMap = new ConcurrentHashMap();
    private double totalAPICount = 0.0;

    public void addAPI(GLES20LogData logData) {
        String hashKey = String.valueOf(logData.getApiName()) + logData.getArgs();
        GLRedundantDataType savedHash = this.redundantHsahMap.get(hashKey);
        if (savedHash == null) {
            this.redundantHsahMap.put(hashKey, new GLRedundantDataType(logData.getApiId(), logData.getArgs(), 1, logData.getElapsedTime()));
        } else {
            savedHash.addCallCount();
            savedHash.addElapsedTime(logData.getElapsedTime());
        }
        this.totalAPICount += 1.0;
    }

    public void insertRedundantData() {
        GLDataManager.getInstance().getRedundantDBTable().insertRedundantData(this.getRedundantTableData());
    }

    public void selectRedundantData() {
        List<GLRedundantDataType> redundantList = GLDataManager.getInstance().getRedundantDBTable().select();
        if (redundantList == null) {
            return;
        }
        for (GLRedundantDataType data : redundantList) {
            String hashKey = String.valueOf(Global.getFunctionName(data.getApiID())) + data.getArgs();
            GLRedundantDataType savedHash = this.redundantHsahMap.get(hashKey);
            if (savedHash == null) {
                this.redundantHsahMap.put(hashKey, new GLRedundantDataType(data.getApiID(), data.getArgs(), data.getCallCount(), data.getElapsedTime()));
            } else {
                savedHash.setCallCount(savedHash.getCallCount() + data.getCallCount());
            }
            this.totalAPICount += (double)data.getCallCount();
        }
    }

    public List<GLRedundantDataType> getRedundantTableData() {
        ArrayList<GLRedundantDataType> returnList = new ArrayList<GLRedundantDataType>();
        for (Map.Entry<String, GLRedundantDataType> entry : this.redundantHsahMap.entrySet()) {
            returnList.add(entry.getValue());
        }
        return returnList;
    }

    public List<GLStatisticsDataType> getStatisticsTableData() {
        ArrayList<GLStatisticsDataType> returnList = new ArrayList<GLStatisticsDataType>();
        LinkedHashMap<String, GLStatisticsDataType> statisticsHashMap = this.getStatisticDataFromRedundantHashMap();
        for (Map.Entry<String, GLStatisticsDataType> entry : statisticsHashMap.entrySet()) {
            returnList.add(entry.getValue());
        }
        return returnList;
    }

    private LinkedHashMap<String, GLStatisticsDataType> getStatisticDataFromRedundantHashMap() {
        LinkedHashMap<String, GLStatisticsDataType> returnStatisticsHsahMap = new LinkedHashMap<String, GLStatisticsDataType>();
        for (Map.Entry<String, GLRedundantDataType> entry : this.redundantHsahMap.entrySet()) {
            GLRedundantDataType redundantDataType = entry.getValue();
            String hashKey = redundantDataType.getAPIName();
            GLStatisticsDataType savedHash = returnStatisticsHsahMap.get(hashKey);
            if (savedHash == null) {
                returnStatisticsHsahMap.put(hashKey, new GLStatisticsDataType(redundantDataType.getApiID(), redundantDataType.getArgs(), this.getRate(redundantDataType.getCallCount()), redundantDataType.getCallCount(), redundantDataType.getElapsedTime(), this.getAPIType(redundantDataType.getAPIName())));
                continue;
            }
            savedHash.addCallCount(redundantDataType.getCallCount());
            savedHash.setRate(this.getRate(savedHash.getCallCount()));
            savedHash.addElapsedTime(redundantDataType.getElapsedTime());
        }
        return returnStatisticsHsahMap;
    }

    private double getRate(double callCount) {
        return callCount / this.totalAPICount * 100.0;
    }

    private String getAPIType(String apiName) {
        StringBuffer returnBuffer = new StringBuffer();
        if (apiName.contains(MATRIX)) {
            returnBuffer.append(MATRIX).append(SPLIT);
        }
        if (apiName.contains(TEXTURE) || apiName.contains("Tex")) {
            returnBuffer.append(TEXTURE).append(SPLIT);
        }
        if (apiName.contains(BUFFER) || apiName.contains(CLEAR)) {
            returnBuffer.append(BUFFER).append(SPLIT);
        }
        if (apiName.contains(GET) || apiName.contains("glHint")) {
            returnBuffer.append(GET).append(SPLIT);
        }
        if (apiName.contains(IS)) {
            returnBuffer.append(IS).append(SPLIT);
        }
        if (apiName.contains(DRAW) || apiName.contains("glFinish") || apiName.contains("glFlush")) {
            returnBuffer.append(DRAW).append(SPLIT);
        }
        if (apiName.contains(DELETE)) {
            returnBuffer.append(DELETE).append(SPLIT);
        }
        if (apiName.contains(BIND) || apiName.contains("Gen")) {
            returnBuffer.append(BIND).append(SPLIT);
        }
        if (apiName.contains("Program") || apiName.contains("Shader") || apiName.contains("Uniform") || apiName.contains("Vertex")) {
            returnBuffer.append(PROGRAM_AND_SHADER).append(SPLIT);
        }
        if (apiName.contains("Blend") || apiName.contains("Color") || apiName.contains("Cull") || apiName.contains("Depth") || apiName.contains("Disable") || apiName.contains("Enable") || apiName.contains("Stencil") || apiName.contains("glLineWidth") || apiName.contains("glPixelStorei") || apiName.contains("glPolygonOffset") || apiName.contains("glReadPixels") || apiName.contains("glSampleCoverage") || apiName.contains("glScissor") || apiName.contains("glViewport")) {
            returnBuffer.append(STATE_CHANGE).append(SPLIT);
        }
        if (apiName.contains(EVAS_GL) || apiName.contains("elm_glview_gl_api_get")) {
            returnBuffer.append(EVAS_GL);
        }
        if (returnBuffer.length() == 0) {
            return "";
        }
        if (returnBuffer.lastIndexOf(SPLIT) == returnBuffer.length() - SPLIT.length()) {
            returnBuffer.delete(returnBuffer.length() - SPLIT.length(), returnBuffer.length());
        }
        return returnBuffer.toString();
    }
}

