/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.disassembler;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.services.IEDCModuleDMContext;
import org.eclipse.cdt.debug.edc.symbols.IEDCSymbolReader;
import org.eclipse.cdt.debug.edc.symbols.IFunctionScope;
import org.eclipse.cdt.debug.edc.symbols.ILineEntry;
import org.eclipse.cdt.debug.edc.symbols.IScope;

public class EDCInstructionFunctionInfo {
    private final String functionName;
    private final IAddress functionStartAddress;

    public EDCInstructionFunctionInfo(String name, IAddress address) {
        this.functionName = name;
        this.functionStartAddress = address;
    }

    public EDCInstructionFunctionInfo(IEDCModuleDMContext module, ILineEntry line) {
        String name = null;
        IAddress start = null;
        IEDCSymbolReader reader = module.getSymbolReader();
        if (reader != null) {
            IScope scope = reader.getModuleScope().getScopeAtAddress(line.getLowAddress());
            while (scope != null && !(scope instanceof IFunctionScope)) {
                scope = scope.getParent();
            }
            if (scope != null) {
                name = scope.getName();
                start = ((IFunctionScope)scope).getLowAddress();
            }
        }
        this.functionName = name;
        this.functionStartAddress = start;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public IAddress getFunctionStartAddress() {
        return this.functionStartAddress;
    }
}

