/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.BinaryOperator;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Instruction;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Interpreter;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.OperandValue;
import org.eclipse.cdt.debug.edc.internal.symbols.IArrayType;
import org.eclipse.cdt.debug.edc.internal.symbols.IPointerType;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.debug.edc.symbols.TypeUtils;
import org.eclipse.core.runtime.CoreException;

public class OperatorPlus
extends BinaryOperator {
    public OperatorPlus(int start) {
        this(0, false, start);
    }

    protected OperatorPlus(int resultId, boolean isAssignmentOperator, int start) {
        super(resultId, isAssignmentOperator, start);
    }

    @Override
    protected boolean customHandleOperation(Interpreter fInterpreter, OperandValue left, OperandValue right) throws CoreException {
        IType rightType = null;
        IType leftType = null;
        boolean isLeftPointer = false;
        leftType = TypeUtils.getStrippedType(left.getValueType());
        isLeftPointer = leftType instanceof IPointerType || leftType instanceof IArrayType;
        boolean isRightPointer = false;
        rightType = TypeUtils.getStrippedType(right.getValueType());
        boolean bl = isRightPointer = rightType instanceof IPointerType || rightType instanceof IArrayType;
        if (!isLeftPointer && !isRightPointer) {
            return false;
        }
        if (isLeftPointer && isRightPointer) {
            if (this.getValueType(left) == 11 && this.getValueType(right) == 11) {
                return false;
            }
            throw EDCDebugger.newCoreException(ASTEvalMessages.OperatorPlus_PtrPlusPtr);
        }
        if (isRightPointer) {
            OperandValue temp = right;
            right = left;
            left = temp;
            temp = right;
            right = left;
            left = temp;
            IType tempType = rightType;
            rightType = leftType;
            leftType = tempType;
        }
        BigInteger bigIntAddress = left.getBigIntValue();
        BigInteger aggregateSize = BigInteger.ZERO;
        aggregateSize = leftType instanceof IPointerType ? BigInteger.valueOf(leftType.getByteSize()) : BigInteger.valueOf(TypeUtils.getStrippedType(leftType.getType()).getByteSize());
        BigInteger addAmount = aggregateSize;
        right = this.convertForPromotion(right);
        addAmount = addAmount.multiply(right.getBigIntValue());
        bigIntAddress = bigIntAddress.add(addAmount);
        this.pushNewValue(left.getValueType(), bigIntAddress);
        return true;
    }

    @Override
    protected int getIntResult(int leftOperand, int rightOperand) throws CoreException {
        return leftOperand + rightOperand;
    }

    @Override
    protected long getLongResult(long leftOperand, long rightOperand) throws CoreException {
        return leftOperand + rightOperand;
    }

    @Override
    protected BigInteger getBigIntegerResult(BigInteger leftOperand, BigInteger rightOperand, int length) throws CoreException {
        return leftOperand.add(rightOperand).and(Instruction.Mask8Bytes);
    }

    @Override
    protected float getFloatResult(float leftOperand, float rightOperand) {
        return leftOperand + rightOperand;
    }

    @Override
    protected double getDoubleResult(double leftOperand, double rightOperand) {
        return leftOperand + rightOperand;
    }

    @Override
    protected boolean getBooleanResult(boolean leftOperand, boolean rightOperand) {
        return false;
    }

    @Override
    protected String getStringResult(String leftOperand, String rightOperand) throws CoreException {
        return String.valueOf(leftOperand) + rightOperand;
    }
}

