/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.SortArrowRenderer;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class DefaultColumnHeaderRenderer
extends GridHeaderRenderer {
    int leftMargin = 6;
    int rightMargin = 6;
    int topMargin = 3;
    int bottomMargin = 3;
    int arrowMargin = 6;
    int imageSpacing = 3;
    private SortArrowRenderer arrowRenderer = new SortArrowRenderer();

    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        GridColumn column = (GridColumn)((Object)value);
        int x = 0;
        x += this.leftMargin;
        x += gc.stringExtent((String)column.getText()).x + this.rightMargin;
        int y = 0;
        y += this.topMargin;
        y += gc.getFontMetrics().getHeight();
        y += this.bottomMargin;
        if (column.getImage() != null) {
            x += column.getImage().getBounds().width + this.imageSpacing;
            y = Math.max(y, this.topMargin + column.getImage().getBounds().height + this.bottomMargin);
        }
        return new Point(x, y);
    }

    public void paint(GC gc, Object value) {
        int len;
        GridColumn column = (GridColumn)((Object)value);
        boolean flat = column.getParent().getCellSelectionEnabled() && !column.getMoveable();
        boolean drawSelected = this.isMouseDown() && this.isHover();
        gc.setBackground(this.getDisplay().getSystemColor(22));
        if (flat && this.isSelected()) {
            gc.setBackground(column.getParent().getCellHeaderSelectionBackground());
        }
        gc.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        int pushedDrawingOffset = 0;
        if (drawSelected) {
            pushedDrawingOffset = 1;
        }
        int x = this.leftMargin;
        if (column.getImage() != null) {
            gc.drawImage(column.getImage(), this.getBounds().x + x + pushedDrawingOffset, this.getBounds().y + pushedDrawingOffset + this.getBounds().height - this.bottomMargin - column.getImage().getBounds().height);
            x += column.getImage().getBounds().width + this.imageSpacing;
        }
        int width = this.getBounds().width - x;
        width = column.getSort() == 0 ? (width -= this.rightMargin) : (width -= this.arrowMargin + this.arrowRenderer.getSize().x + this.arrowMargin);
        gc.setForeground(this.getDisplay().getSystemColor(21));
        int y = this.getBounds().y + this.getBounds().height - this.bottomMargin - gc.getFontMetrics().getHeight();
        String text = TextUtils.getShortString(gc, column.getText(), width);
        if (column.getAlignment() == 131072) {
            int len2 = gc.stringExtent((String)text).x;
            if (len2 < width) {
                x += width - len2;
            }
        } else if (column.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
            x += (width - len) / 2;
        }
        gc.drawString(text, this.getBounds().x + x + pushedDrawingOffset, y + pushedDrawingOffset, true);
        if (column.getSort() != 0) {
            this.arrowRenderer.setSelected(column.getSort() == 128);
            if (drawSelected) {
                this.arrowRenderer.setLocation(this.getBounds().x + this.getBounds().width - this.arrowMargin - this.arrowRenderer.getBounds().width + 1, this.getBounds().y + (this.getBounds().height - this.arrowRenderer.getBounds().height) / 2 + 1);
            } else {
                this.arrowRenderer.setLocation(this.getBounds().x + this.getBounds().width - this.arrowMargin - this.arrowRenderer.getBounds().width, this.getBounds().y + (this.getBounds().height - this.arrowRenderer.getBounds().height) / 2);
            }
            this.arrowRenderer.paint(gc, null);
        }
        if (!flat) {
            if (drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(20));
            }
            gc.drawLine(this.getBounds().x, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y);
            gc.drawLine(this.getBounds().x, this.getBounds().y, this.getBounds().x, this.getBounds().y + this.getBounds().height - 1);
            if (!drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(19));
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + 1, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + 1);
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + 1, this.getBounds().x + 1, this.getBounds().y + this.getBounds().height - 2);
            }
            if (drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(17));
            }
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height - 1, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            if (!drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
                gc.drawLine(this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + 1, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + this.getBounds().height - 2);
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + this.getBounds().height - 2, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + this.getBounds().height - 2);
            }
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(17));
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height - 1, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
        }
    }

    public void setDisplay(Display display) {
        super.setDisplay(display);
        this.arrowRenderer.setDisplay(display);
    }

    public boolean notify(int event, Point point, Object value) {
        return false;
    }

    public Rectangle getTextBounds(Object value, boolean preferred) {
        GridColumn column = (GridColumn)((Object)value);
        int x = this.leftMargin;
        if (column.getImage() != null) {
            x += column.getImage().getBounds().width + this.imageSpacing;
        }
        GC gc = new GC((Drawable)column.getParent());
        gc.setFont(column.getParent().getFont());
        int y = this.getBounds().height - this.bottomMargin - gc.getFontMetrics().getHeight();
        Rectangle bounds = new Rectangle(x, y, 0, 0);
        Point p = gc.stringExtent(column.getText());
        bounds.height = p.y;
        if (preferred) {
            bounds.width = p.x;
        } else {
            int width = this.getBounds().width - x;
            width = column.getSort() == 0 ? (width -= this.rightMargin) : (width -= this.arrowMargin + this.arrowRenderer.getSize().x + this.arrowMargin);
            bounds.width = width;
        }
        gc.dispose();
        return bounds;
    }
}

