/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPClassTemplate
extends CPPTemplateDefinition
implements ICPPClassTemplate,
ICPPInternalClassTemplate,
ICPPInternalClassTypeMixinHost {
    private ICPPClassTemplate fIndexBinding = null;
    private boolean checkedIndex = false;
    private boolean checkedDefinition = false;
    private ICPPClassTemplatePartialSpecialization[] partialSpecializations = null;
    private ICPPDeferredClassInstance fDeferredInstance;

    public CPPClassTemplate(IASTName name) {
        super(name);
    }

    public void checkForDefinition() {
        if (this.checkedDefinition) {
            return;
        }
        this.checkedDefinition = true;
        if (this.definition != null) {
            return;
        }
        FindDefinitionAction action = new FindDefinitionAction();
        IASTNode node = CPPVisitor.getContainingBlockItem(this.declarations[0]).getParent();
        while (node instanceof ICPPASTTemplateDeclaration) {
            node = node.getParent();
        }
        node.accept(action);
        this.definition = action.result;
        if (this.definition == null) {
            node.getTranslationUnit().accept(action);
            this.definition = action.result;
        }
    }

    public void addPartialSpecialization(ICPPClassTemplatePartialSpecialization spec) {
        this.partialSpecializations = (ICPPClassTemplatePartialSpecialization[])ArrayUtil.append(ICPPClassTemplatePartialSpecialization.class, this.partialSpecializations, spec);
    }

    public ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier() {
        if (this.definition != null) {
            IASTNode node = this.definition.getParent();
            if (node instanceof ICPPASTQualifiedName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                return (ICPPASTCompositeTypeSpecifier)node;
            }
        }
        return null;
    }

    public ICPPClassScope getCompositeScope() {
        IScope scope;
        if (this.definition == null) {
            this.checkForDefinition();
        }
        if (this.definition != null) {
            IASTNode parent = this.definition.getParent();
            while (parent instanceof IASTName) {
                parent = parent.getParent();
            }
            if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)parent;
                return compSpec.getScope();
            }
        }
        this.checkForIndexBinding();
        if (this.fIndexBinding != null && (scope = this.fIndexBinding.getCompositeScope()) instanceof ICPPClassScope) {
            return (ICPPClassScope)scope;
        }
        return null;
    }

    public int getKey() {
        IASTNode n;
        if (this.definition != null) {
            ICPPASTCompositeTypeSpecifier cts = this.getCompositeTypeSpecifier();
            if (cts != null) {
                return cts.getKey();
            }
            IASTNode n2 = this.definition.getParent();
            if (n2 instanceof ICPPASTElaboratedTypeSpecifier) {
                return ((ICPPASTElaboratedTypeSpecifier)n2).getKind();
            }
        }
        if (this.declarations != null && this.declarations.length > 0 && (n = this.declarations[0].getParent()) instanceof ICPPASTElaboratedTypeSpecifier) {
            return ((ICPPASTElaboratedTypeSpecifier)n).getKind();
        }
        return 3;
    }

    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() {
        this.partialSpecializations = (ICPPClassTemplatePartialSpecialization[])ArrayUtil.trim(ICPPClassTemplatePartialSpecialization.class, this.partialSpecializations);
        return this.partialSpecializations;
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        return false;
    }

    public ICPPBase[] getBases() {
        return ClassTypeHelper.getBases(this);
    }

    public IField[] getFields() {
        return ClassTypeHelper.getFields(this);
    }

    public ICPPField[] getDeclaredFields() {
        return ClassTypeHelper.getDeclaredFields(this);
    }

    public ICPPMethod[] getMethods() {
        return ClassTypeHelper.getMethods(this);
    }

    public ICPPMethod[] getAllDeclaredMethods() {
        return ClassTypeHelper.getAllDeclaredMethods(this);
    }

    public ICPPMethod[] getDeclaredMethods() {
        return ClassTypeHelper.getDeclaredMethods(this);
    }

    public ICPPConstructor[] getConstructors() {
        return ClassTypeHelper.getConstructors(this);
    }

    public IBinding[] getFriends() {
        return ClassTypeHelper.getFriends(this);
    }

    public ICPPClassType[] getNestedClasses() {
        return ClassTypeHelper.getNestedClasses(this);
    }

    public IField findField(String name) {
        return ClassTypeHelper.findField(this, name);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    public boolean isAnonymous() {
        return false;
    }

    public final ICPPDeferredClassInstance asDeferredInstance() throws DOMException {
        if (this.fDeferredInstance == null) {
            this.fDeferredInstance = this.createDeferredInstance();
        }
        return this.fDeferredInstance;
    }

    protected ICPPDeferredClassInstance createDeferredInstance() throws DOMException {
        ICPPTemplateArgument[] args = CPPTemplates.templateParametersAsArguments(this.getTemplateParameters());
        return new CPPDeferredClassInstance(this, args, this.getCompositeScope());
    }

    public ICPPTemplateArgument getDefaultArgFromIndex(int paramPos) throws DOMException {
        ICPPTemplateParameter[] params;
        this.checkForIndexBinding();
        if (this.fIndexBinding != null && paramPos < (params = this.fIndexBinding.getTemplateParameters()).length) {
            ICPPTemplateParameter param = params[paramPos];
            return param.getDefaultValue();
        }
        return null;
    }

    private void checkForIndexBinding() {
        if (this.checkedIndex) {
            return;
        }
        this.checkedIndex = true;
        IASTTranslationUnit tu = this.definition != null ? this.definition.getTranslationUnit() : this.declarations[0].getTranslationUnit();
        IIndex index = tu.getIndex();
        if (index != null) {
            this.fIndexBinding = (ICPPClassTemplate)((Object)index.adaptBinding(this));
        }
    }

    private class FindDefinitionAction
    extends ASTVisitor {
        private char[] nameArray;
        public IASTName result;

        FindDefinitionAction() {
            this.nameArray = CPPClassTemplate.this.getNameCharArray();
            this.result = null;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
        }

        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof ICPPASTTemplateId || name instanceof ICPPASTQualifiedName) {
                return 3;
            }
            char[] c = name.getLookupKey();
            if (name.getParent() instanceof ICPPASTTemplateId) {
                name = (IASTName)name.getParent();
            }
            if (name.getParent() instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name.getParent()).getNames();
                if (ns[ns.length - 1] != name) {
                    return 3;
                }
                name = (IASTName)name.getParent();
            }
            if (name.getParent() instanceof ICPPASTCompositeTypeSpecifier && CharArrayUtils.equals(c, this.nameArray) && (binding = name.resolveBinding()) == CPPClassTemplate.this) {
                this.result = name.getLastName();
                return 2;
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration || declaration instanceof ICPPASTTemplateDeclaration) {
                return 3;
            }
            return 1;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            return declSpec instanceof ICPPASTCompositeTypeSpecifier ? 3 : 1;
        }

        public int visit(IASTDeclarator declarator) {
            return 1;
        }
    }
}

