/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.Spawner;

public class ProcessFactory {
    private static ProcessFactory instance;
    private boolean hasSpawner = false;
    private Runtime runtime;

    private ProcessFactory() {
        String OS = System.getProperty("os.name").toLowerCase();
        this.runtime = Runtime.getRuntime();
        try {
            if (OS != null && OS.equals("windows 98")) {
                this.hasSpawner = false;
            } else {
                System.loadLibrary("spawner");
                this.hasSpawner = true;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
    }

    public static ProcessFactory getFactory() {
        if (instance == null) {
            instance = new ProcessFactory();
        }
        return instance;
    }

    public Process exec(String cmd) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(cmd);
        }
        return this.runtime.exec(cmd);
    }

    public Process exec(String[] cmdarray) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(cmdarray);
        }
        return this.runtime.exec(cmdarray);
    }

    public Process exec(String[] cmdarray, String[] envp) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(cmdarray, envp);
        }
        return this.runtime.exec(cmdarray, envp);
    }

    public Process exec(String cmd, String[] envp) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(cmd, envp);
        }
        return this.runtime.exec(cmd, envp);
    }

    public Process exec(String cmd, String[] envp, File dir) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(cmd, envp, dir);
        }
        return this.runtime.exec(cmd, envp, dir);
    }

    public Process exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(cmdarray, envp, dir);
        }
        return this.runtime.exec(cmdarray, envp, dir);
    }

    public Process exec(String[] cmdarray, String[] envp, File dir, PTY pty) throws IOException {
        if (this.hasSpawner) {
            return new Spawner(cmdarray, envp, dir, pty);
        }
        throw new UnsupportedOperationException(CCorePlugin.getResourceString("Util.exception.cannotCreatePty"));
    }
}

