/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmPanelProperties
extends HierarchyUIObjectProperties {
    private String orient;
    private boolean hidden;
    private boolean scrollable;

    public ElmPanelProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.orient = this.getOrientMessage(parser.getChar());
        this.hidden = parser.getBoolean();
        this.scrollable = parser.getBoolean();
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("orient", this.orient));
        properties.add(new PropertyValue("hidden", Boolean.toString(this.hidden)));
        properties.add(new PropertyValue("scrollable", Boolean.toString(this.scrollable)));
        return properties;
    }

    private String getOrientMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_PANEL_ORIENT_TOP";
            }
            case 1: {
                return "ELM_PANEL_ORIENT_BOTTOM";
            }
            case 2: {
                return "ELM_PANEL_ORIENT_LEFT";
            }
            case 3: {
                return "ELM_PANEL_ORIENT_RIGHT";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

