/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.timeline.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.nl.TimelineChartLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.timeline.SystemDataDBTable;
import org.tizen.dynamicanalyzer.ui.timeline.chart.TimelineChart;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.utils.Formatter;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartPlot;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeries;
import org.tizen.dynamicanalyzer.widgets.chart.DAChartSeriesItem;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoard;
import org.tizen.dynamicanalyzer.widgets.chartBoard.DAChartBoardItem;

public class CPUCoreChart
extends TimelineChart {
    private int coreSize = -1;
    private List<DAChartSeries> coreChartSeriesList = new ArrayList<DAChartSeries>();
    private Color[] coreChartSeriesColors = new Color[]{ColorResources.CHART_SERIES_BLUE, ColorResources.CHART_SERIES_EMERALD, ColorResources.CHART_SERIES_PINK, ColorResources.CHART_SERIES_ORANGE, ColorResources.CHART_SERIES_YELLOWGREEN, ColorResources.CHART_SERIES_RED, ColorResources.CHART_SERIES_PURPLE, ColorResources.CHART_SERIES_GRAY};

    public CPUCoreChart(String pageID) {
        super(pageID);
        this.chartType = -102;
        this.probeType = 5;
        this.chartName = TimelineChartLabels.CPU_CORE_CHART_TITLE;
        this.chartDescriptor = TimelineChartLabels.CPU_CORE_CHART_DESCRIPTOR;
        this.chartIcon = ImageResources.FEATURE_CPUCORE_SMALL_NOR;
        this.addIcon = ImageResources.FEATURE_CPUCORE_SMALL_NOR;
    }

    @Override
    public DAChartBoardItem createBoardItem(DAChartBoard board) {
        DAChartBoardItem item = super.createBoardItem(board);
        this.chart.getPlot().setAutoHeightRange(DAChartPlot.AutoRangeType.MANUAL);
        this.chart.getPlot().setAxisRangeY(0.0, 100.0);
        this.chart.getPlot().setAxisUnit("%");
        this.chart.getPlot().setShowAxis(true);
        return item;
    }

    @Override
    public void inputChartSeries(List<Object> dataList) {
        int i;
        if (this.coreSize == -1) {
            if (Global.getProject() == null) {
                return;
            }
            this.coreSize = Global.getProject().getDeviceStatusInfo().getCpuCount();
            i = 0;
            while (i < this.coreSize) {
                DAChartSeries chartSeries = new DAChartSeries(String.valueOf(TimelineChartLabels.CPU_CORE_CHART_SERIES_NAME_CORE) + i, 1, this.coreChartSeriesColors[i % this.coreSize]);
                this.chart.addSeries(chartSeries);
                this.coreChartSeriesList.add(chartSeries);
                ++i;
            }
        }
        i = 0;
        while (i < this.coreChartSeriesList.size()) {
            this.coreChartSeriesList.get(i).clear();
            ++i;
        }
        List data = (List)dataList.get(0);
        int i2 = 0;
        while (i2 < data.size()) {
            List row = (List)data.get(i2);
            double time = (double)((Long)row.get(SystemDataDBTable.COLUMN.SAMPLING_TIME.ordinal())).longValue() / 1000000.0;
            List cpuLoadList = (List)row.get(SystemDataDBTable.COLUMN.CPU_LOAD.ordinal());
            int ii = 0;
            while (ii < cpuLoadList.size()) {
                double cpuLoad = (Double)cpuLoadList.get(ii);
                if (cpuLoad > 100.0) {
                    Logger.error((Object)("Core usage is above 100%; value = " + cpuLoad));
                    cpuLoad = 100.0;
                } else if (cpuLoad < 0.0) {
                    Logger.error((Object)("Core usage is less then 0%; value = " + cpuLoad));
                    cpuLoad = 0.0;
                }
                this.coreChartSeriesList.get(ii).addSeriesItem(new DAChartSeriesItem(time, cpuLoad, Formatter.toPercentageFormat(cpuLoad)));
                ++ii;
            }
            ++i2;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.coreSize = -1;
        this.coreChartSeriesList.clear();
    }
}

