/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.tizen.dynamicanalyzer.resources.ImageResources;
import org.tizen.dynamicanalyzer.ui.widgets.DAAdvancedPopupMenu;
import org.tizen.dynamicanalyzer.ui.widgets.table.DATableComposite;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenu;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuItem;
import org.tizen.dynamicanalyzer.widgets.popupMenu.DAPopupMenuListener;

public class DAAdvancedViewComposite
extends DAViewComposite {
    private DAAdvancedPopupMenu advancedMenu = null;
    protected DATableComposite ownTable = null;
    private PaintListener advancedMenuButtonPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Rectangle bounds = DAAdvancedViewComposite.this.titleBar.getBounds();
            int width = bounds.width;
            gc.drawImage(ImageResources.ADVANCED_MENU_BUTTON_NORMAL, width - 19, 3);
        }
    };
    private Listener advancedMenuButtonMouseUpListener = new Listener(){

        public void handleEvent(Event event) {
            Rectangle bounds = DAAdvancedViewComposite.this.titleBar.getBounds();
            int width = bounds.width;
            if (event.x < width - 16 || event.x > width - 6) {
                return;
            }
            if (event.button == 1) {
                Point loc = DAAdvancedViewComposite.this.getLocation();
                Point p = DAAdvancedViewComposite.this.contentArea.toDisplay(loc);
                int x = 0;
                int y = 0;
                x = p.x - loc.x + ((DAAdvancedViewComposite)DAAdvancedViewComposite.this).contentArea.getBounds().width - 87;
                y = p.y - loc.y - 5;
                DAAdvancedViewComposite.this.advancedMenu.open(DAAdvancedViewComposite.this.advancedMenu.getTopShell(), x, y);
            }
        }
    };

    public DAAdvancedViewComposite(Composite parent, int style, boolean titleVisibility, boolean advancedButtonActivation) {
        super(parent, style, titleVisibility);
        this.contentArea = this.getContentArea();
        this.advancedMenu = new DAAdvancedPopupMenu(this.contentArea);
        if (titleVisibility && advancedButtonActivation) {
            this.titleBar = this.getTitleArea();
            this.titleBar.addPaintListener(this.advancedMenuButtonPaintListener);
            this.titleBar.addListener(4, this.advancedMenuButtonMouseUpListener);
        }
    }

    public List<Integer> getDisabledMenuIndexes() {
        ArrayList<Integer> disabledIndexes = new ArrayList<Integer>();
        int i = 0;
        while (i < this.advancedMenu.getItems().size()) {
            if (!this.advancedMenu.getItem(i).isEnabled()) {
                disabledIndexes.add(i);
            }
            ++i;
        }
        return disabledIndexes;
    }

    protected void setTable(DATableComposite table) {
        if (table == null) {
            Logger.error((Object)"table object is null !!");
        } else {
            this.ownTable = table;
            this.advancedMenu.setTable(table);
        }
    }

    public DATableComposite getTable() {
        return this.ownTable;
    }

    protected void addAdvancedMenuItem(String itemName, DAPopupMenuListener eventListener) {
        DAPopupMenuItem searchItem = new DAPopupMenuItem((DAPopupMenu)this.advancedMenu);
        searchItem.setText(itemName);
        searchItem.addListener(eventListener);
    }

    protected void disableAdvancedMenuItem(int itemIndex) {
        DAPopupMenuItem item = this.advancedMenu.getItem(itemIndex);
        if (item != null) {
            item.setEnabled(false);
        } else {
            Logger.debug((Object)"Wrong menu index !!");
        }
    }
}

