/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command.message;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sdb.command.message.CommandErrorException;
import org.tizen.common.sdb.command.message.ICommandErrorHandler;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;

public class CertificateDefaultErrorHandler
implements ICommandErrorHandler {
    private static final String CERTIFICATE_MGR_COMMAND_ID = "org.tizen.common.signing.certificateManager";
    private static final int OPEN_BUTTON_ID = 0;
    private static final int CANCEL_BUTTON_ID = 1;
    private static final String OPEN_BUTTON = "Open";
    private static final String CANCEL_BUTTON = "Cancel";
    private static final String MESSAGE = "The application installation on the device has failed due to a signature error! (error code : %d)\n\nYou need an appropriate certificate profile, which can be created or activated in the Certificate Manager. Do you want to open the Certificate Manager?";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void handle(final CommandErrorException e) {
        SWTUtil.asyncExec(new Runnable(){

            @Override
            public void run() {
                int errorCode = e.getErrorCode();
                String message = String.format(CertificateDefaultErrorHandler.MESSAGE, errorCode);
                String title = JFaceResources.getString((String)"Problem_Occurred");
                String[] buttonStrings = new String[]{CertificateDefaultErrorHandler.OPEN_BUTTON, CertificateDefaultErrorHandler.CANCEL_BUTTON};
                MessageDialog dialog = new MessageDialog(DialogUtil.getActiveShell(), title, null, message, 1, buttonStrings, 0);
                int result = dialog.open();
                if (result == 0) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IHandlerService handlerService = (IHandlerService)page.getActivePart().getSite().getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand(CertificateDefaultErrorHandler.CERTIFICATE_MGR_COMMAND_ID, null);
                    }
                    catch (Exception e2) {
                        CertificateDefaultErrorHandler.this.logger.error("Failed to execute certificate manager", (Throwable)e2);
                    }
                } else {
                    dialog.close();
                }
            }
        });
    }
}

