/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.formatter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.edc.formatter.AbstractVariableConverter;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractCompositeFormatProvider
extends AbstractVariableConverter
implements ITypeContentProvider {
    private final NameToFieldPath[] nameToFieldPaths;

    public AbstractCompositeFormatProvider(IType type, boolean forDetails, List<NameToFieldPath> nameToFieldPaths) {
        super(type, forDetails);
        this.nameToFieldPaths = nameToFieldPaths.toArray(new NameToFieldPath[nameToFieldPaths.size()]);
    }

    @Override
    public Iterator<IExpressions.IExpressionDMContext> getChildIterator(IExpressions.IExpressionDMContext variable) throws CoreException {
        List<IExpressions.IExpressionDMContext> childExpressions = this.getChildren(variable);
        return childExpressions.iterator();
    }

    @Override
    public int getChildCount(IExpressions.IExpressionDMContext variable) throws CoreException {
        List<IExpressions.IExpressionDMContext> childExpressions = this.getChildren(variable);
        return childExpressions.size();
    }

    protected List<IExpressions.IExpressionDMContext> getChildren(IExpressions.IExpressionDMContext variable) throws CoreException {
        ArrayList<IExpressions.IExpressionDMContext> childExpressions = new ArrayList<IExpressions.IExpressionDMContext>();
        NameToFieldPath[] nameToFieldPathArray = this.nameToFieldPaths;
        int n = this.nameToFieldPaths.length;
        int n2 = 0;
        while (n2 < n) {
            NameToFieldPath nameToFieldPath = nameToFieldPathArray[n2];
            IExpressions.IExpressionDMContext createSubExpression = FormatUtils.createSubExpression(variable, nameToFieldPath.getName(), String.valueOf(FormatUtils.getFieldAccessor(this.type)) + nameToFieldPath.getFieldPath());
            if (createSubExpression != null) {
                childExpressions.add(createSubExpression);
            }
            ++n2;
        }
        List<IExpressions.IExpressionDMContext> allChildren = FormatUtils.getAllChildExpressions(variable);
        for (IExpressions.IExpressionDMContext child : allChildren) {
            String name = ((IEDCExpression)child).getName();
            if (this.hasFieldPath(name)) continue;
            childExpressions.add(child);
        }
        return childExpressions;
    }

    private boolean hasFieldPath(String fieldPath) {
        NameToFieldPath[] nameToFieldPathArray = this.nameToFieldPaths;
        int n = this.nameToFieldPaths.length;
        int n2 = 0;
        while (n2 < n) {
            NameToFieldPath nameToFieldPath = nameToFieldPathArray[n2];
            if (nameToFieldPath.getFieldPath().equals(fieldPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected String getDetailsValue(IExpressions.IExpressionDMContext variable) throws CoreException {
        return this.getValueString(variable);
    }

    @Override
    protected String getSummaryValue(IExpressions.IExpressionDMContext variable) throws CoreException {
        return this.getValueString(variable);
    }

    protected String getValueString(IExpressions.IExpressionDMContext variable) throws CoreException {
        IEDCExpressions expressions = ((IEDCExpression)variable).getExpressionsService();
        if (expressions == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<IExpressions.IExpressionDMContext> children = this.getChildren(variable);
        int i = 0;
        for (IExpressions.IExpressionDMContext child : children) {
            IEDCExpression childExpression = (IEDCExpression)child;
            if (i < this.nameToFieldPaths.length) {
                sb.append(this.nameToFieldPaths[i].getName());
            } else {
                sb.append(childExpression.getName());
            }
            sb.append("=");
            sb.append(FormatUtils.getVariableValue(childExpression));
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    protected static class NameToFieldPath {
        private String name;
        private String fieldPath;

        public NameToFieldPath(String name, String fieldPath) {
            this.name = name;
            this.fieldPath = fieldPath;
        }

        public String getName() {
            return this.name;
        }

        public String getFieldPath() {
            return this.fieldPath;
        }
    }
}

