/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.tizen.sdb.CommandResponse;
import org.tizen.sdb.command.Pull;
import org.tizen.sdb.command.Push;
import org.tizen.sdb.command.receiver.LineReceiver;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;
import org.tizen.sdblib.service.ISyncProgressMonitor;
import org.tizen.sdblib.service.NullSyncProgressMonitor;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncServiceReturnCode;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.FileEntryUtil;
import org.tizen.sdblib.util.FilenameUtil;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.ObjectUtil;
import org.tizen.sdblib.util.Preferences;

public class SyncService
implements Closeable {
    protected final Device device;

    public SyncService(SmartDevelopmentBridge sdb, Device device) {
        Assert.notNull(device);
        this.device = device;
    }

    @Override
    public void close() {
    }

    public SyncResult pull(FileEntry entry, String localPath) {
        return this.pull(new FileEntry[]{entry}, localPath);
    }

    public SyncResult pull(FileEntry[] entries, String localPath) {
        return this.pull(entries, localPath, null);
    }

    public SyncResult pull(FileEntry[] entries, String localPath, ISyncProgressMonitor monitor) {
        return this.pull(entries, localPath, monitor, Preferences.getTimeOut());
    }

    public SyncResult pull(FileEntry[] entries, String destination, ISyncProgressMonitor monitor, int timeOut) {
        SyncResult result;
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        File f = new File(destination);
        if (!f.exists()) {
            return new SyncResult(SyncServiceReturnCode.RESULT_NO_DIR_TARGET);
        }
        if (!f.isDirectory()) {
            return new SyncResult(SyncServiceReturnCode.RESULT_TARGET_IS_FILE);
        }
        monitor.start(-1L);
        monitor.startSubTask("File size checking: it can take some time.");
        try {
            long total = FileEntryUtil.getTotalSize(entries, monitor);
            if (total == -1L) {
                SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_FAIL_GET_FOLDER_SIZE);
                return syncResult;
            }
            try {
                monitor.startSubTask("Pulling file(s) from the device");
                monitor.stop();
                monitor.start(total);
                result = this.doPull(entries, destination, monitor, timeOut);
            }
            catch (InterruptedException interruptedException) {
                SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
                return syncResult;
            }
        }
        finally {
            monitor.stop();
        }
        return result;
    }

    public SyncResult doPull(FileEntry[] entries, String destination, ISyncProgressMonitor monitor, int timeOut) {
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        try {
            FileEntry[] fileEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                FileEntry[] children;
                FileEntry entry = fileEntryArray[n2];
                String path = FilenameUtil.addTailingPath(destination, entry.getName());
                if (entry.isRoot()) {
                    children = entry.getChildren();
                    this.doPull(children, destination, monitor, timeOut);
                } else if (entry.isDirectory()) {
                    new File(path).mkdir();
                    children = entry.getChildren();
                    this.doPull(children, path, monitor, timeOut);
                } else {
                    if (entry.getType().isDevice() || entry.getType().isFIFO()) {
                        return new SyncResult();
                    }
                    monitor.startSubTask(String.format("%s\t%s", entry.getFullPath(), path));
                    SyncResult result = this.doPull(entry, path, monitor, timeOut);
                    if (!result.isOk()) {
                        return result;
                    }
                }
                ++n2;
            }
            return new SyncResult();
        }
        catch (IOException e) {
            return new SyncResult(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Exception)e);
        }
    }

    @Deprecated
    public SyncResult doPull(FileEntry remote, OutputStream out, ISyncProgressMonitor monitor, int timeOut) throws IOException {
        return new SyncResult();
    }

    public SyncResult doPull(FileEntry remote, String path, ISyncProgressMonitor monitor, int timeOut) throws IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return this.doPullForPrve(remote, path, monitor, timeOut);
        }
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        Pull pull = new Pull();
        LineReceiver receiver = new LineReceiver(){

            @Override
            public void processNewLines(String[] lines) {
                int i = 0;
                while (i < lines.length) {
                    System.out.println(lines[i]);
                    ++i;
                }
            }
        };
        if (monitor.isCanceled()) {
            receiver.close();
            return new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
        }
        pull.pull(remote.getFullPath(), Paths.get(path, new String[0]), this.device.getSerialNumber(), receiver);
        CommandResponse resp = pull.getResponse();
        SyncResult syncResult = new SyncResult(resp.getStatusCode(), resp.getResult());
        return syncResult;
    }

    /*
     * Exception decompiling
     */
    private SyncResult doPullForPrve(FileEntry remote, String path, ISyncProgressMonitor monitor, int timeOut) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SyncResult push(String local, FileEntry entry) {
        return this.push(new String[]{local}, entry);
    }

    public SyncResult push(String[] locals, FileEntry entry) {
        return this.push(locals, entry, null);
    }

    public SyncResult push(String[] locals, FileEntry entry, ISyncProgressMonitor monitor) {
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = locals;
        int n = locals.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(path);
            if (!file.exists()) {
                return new SyncResult(SyncServiceReturnCode.RESULT_NO_LOCAL_FILE);
            }
            files.add(file);
            ++n2;
        }
        return this.push(files.toArray(new File[files.size()]), entry, monitor, Preferences.getTimeOut());
    }

    public SyncResult push(File[] locals, FileEntry remote, ISyncProgressMonitor monitor, int timeOut) {
        SyncResult result;
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        if (!remote.isDirectory() && FileEntryType.Unknown != remote.getType()) {
            return new SyncResult(SyncServiceReturnCode.RESULT_REMOTE_IS_FILE);
        }
        monitor.start(-1L);
        monitor.startSubTask("File size checking: it can take some time.");
        try {
            try {
                long total = SyncService.getTotalLocalFileSizeLong(locals, monitor);
                monitor.startSubTask("Pushing file(s) to the device");
                monitor.stop();
                monitor.start(total);
                result = this.doPush(locals, remote, monitor, timeOut);
            }
            catch (InterruptedException interruptedException) {
                SyncResult syncResult = new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
                monitor.stop();
                return syncResult;
            }
        }
        finally {
            monitor.stop();
        }
        return result;
    }

    public SyncResult doPush(File[] locals, FileEntry remote, ISyncProgressMonitor monitor, int timeOut) {
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        monitor.printLog("Your data is to be sent over an unencrypted connection and could be read by others.");
        try {
            String remotePath = remote.getFullPath();
            File[] fileArray = locals;
            int n = locals.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (monitor.isCanceled()) {
                    return new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
                }
                if (f.exists()) {
                    SyncResult result;
                    String path = FilenameUtil.addTailingPath(remotePath, f.getName());
                    FileEntry remoteFile = f.getName().contains("'") ? this.device.getSimpleFileEntry(path) : this.device.getFileEntry(path);
                    monitor.startSubTask(String.format("%s\t%s", f.getAbsolutePath(), path));
                    if (f.isDirectory() ? !(result = this.doPush(f.listFiles(), remoteFile, monitor, timeOut)).isOk() : f.isFile() && !(result = this.doPush(f, remoteFile, monitor, timeOut, false)).isOk()) {
                        return result;
                    }
                }
                ++n2;
            }
            return new SyncResult();
        }
        catch (IOException e) {
            return new SyncResult(SyncServiceReturnCode.RESULT_FILE_READ_ERROR, (Exception)e);
        }
    }

    private SyncResult doPush(File f, FileEntry remote, ISyncProgressMonitor monitor, int timeOut, boolean bPrintSecureWarnMsg) throws IOException {
        if (SmartDevelopmentBridge.getBridge() != null && !SmartDevelopmentBridge.getBridge().isTims()) {
            return this.doPushForPrev(f, remote, monitor, timeOut, bPrintSecureWarnMsg);
        }
        monitor = ObjectUtil.nvl(monitor, NullSyncProgressMonitor.getInstance());
        if (bPrintSecureWarnMsg) {
            monitor.printLog("Your data is to be sent over an unencrypted connection and could be read by others.");
        }
        Push push = new Push();
        LineReceiver receiver = new LineReceiver(){

            @Override
            public void processNewLines(String[] lines) {
                int i = 0;
                while (i < lines.length) {
                    System.out.println(lines[i]);
                    ++i;
                }
            }
        };
        push.push(f.toPath().toAbsolutePath(), remote.getFullPath(), this.device.getSerialNumber(), receiver);
        if (monitor.isCanceled()) {
            return new SyncResult(SyncServiceReturnCode.RESULT_CANCELED);
        }
        return new SyncResult();
    }

    /*
     * Exception decompiling
     */
    private SyncResult doPushForPrev(File f, FileEntry remote, ISyncProgressMonitor monitor, int timeOut, boolean bPrintSecureWarnMsg) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static long getTotalLocalFileSizeLong(File[] files, ISyncProgressMonitor monitor) throws InterruptedException {
        long count = 0L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (monitor.isCanceled()) {
                throw new InterruptedException("The long running operation was cancelled");
            }
            if (f.exists()) {
                if (f.isDirectory()) {
                    count += SyncService.getTotalLocalFileSizeLong(f.listFiles(), monitor);
                } else if (f.isFile()) {
                    count += f.length();
                }
            }
            ++n2;
        }
        return count;
    }

    public SyncResult delete(String filePath) {
        String command = String.format("rm -f %s", FileEntry.getStringWithDoubleQuote(filePath));
        String cmd = "";
        cmd = this.device.isSecureProtocol() ? "0 rmfile " + FileEntry.getStringWithDoubleQuote(filePath) : command;
        try {
            this.device.executeShellCommand(cmd);
            return new SyncResult();
        }
        catch (IOException e) {
            Log.e("failed to delete file", e);
            return new SyncResult(SyncServiceReturnCode.RESULT_FAIL_DELETE_FILE);
        }
    }
}

