/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.setting;

import java.util.HashMap;
import java.util.Map;
import org.tizen.dynamicanalyzer.nl.ConfigureLabels;
import org.tizen.dynamicanalyzer.setting.TemplateData;

public enum Template {
    TEMPLATE_BOTTLENECK(1, ConfigureLabels.TEMPLATE_NAME_BOTTLENECK, ConfigureLabels.TEMPLATE_DESCRIPTION_BOTTLENECK),
    TEMPLATE_MEMORY_LEAKS(2, ConfigureLabels.TEMPLATE_NAME_MEMORY_LEAKS, ConfigureLabels.TEMPLATE_DESCRIPTION_MEMORY_LEAKS),
    TEMPLATE_PROCESS_ACTIVITY(3, ConfigureLabels.TEMPLATE_NAME_PROCESS_ACTIVITY, ConfigureLabels.TEMPLATE_DESCRIPTION_PROCESS_ACTIVITY),
    TEMPLATE_FILE(4, ConfigureLabels.TEMPLATE_NAME_FILE, ConfigureLabels.TEMPLATE_DESCRIPTION_FILE),
    TEMPLATE_THREAD_ACTIVITY(5, ConfigureLabels.TEMPLATE_NAME_THREAD_ACTIVITY, ConfigureLabels.TEMPLATE_DESCRIPTION_THREAD_ACTIVITY),
    TEMPLATE_WAIT_STATUS(6, ConfigureLabels.TEMPLATE_NAME_WAIT_STATUS, ConfigureLabels.TEMPLATE_DESCRIPTION_WAIT_STATUS),
    TEMPLATE_NETWORK(7, ConfigureLabels.TEMPLATE_NAME_NETWORK, ConfigureLabels.TEMPLATE_DESCRIPTION_NETWORK),
    TEMPLATE_OPEN_GL(8, ConfigureLabels.TEMPLATE_NAME_OPEN_GL, ConfigureLabels.TEMPLATE_DESCRIPTION_OPEN_GL),
    TEMPLATE_ENERGY(9, ConfigureLabels.TEMPLATE_NAME_ENERGY, ConfigureLabels.TEMPLATE_DESCRIPTION_ENERGY),
    TEMPLATE_UI_HIERARCHY(10, ConfigureLabels.TEMPLATE_NAME_UI_HIERARCHY, ConfigureLabels.TEMPLATE_DESCRIPTION_UI_HIERARCHY),
    TEMPLATE_CUSTOM(11, ConfigureLabels.TEMPLATE_NAME_CUSTOM, ConfigureLabels.TEMPLATE_DESCRIPTION_CUSTOM);

    private static final Map<Integer, Template> templateByIndex;
    private static final Map<String, Template> templateByName;
    private int index = 0;
    private String name = null;
    private String description = null;
    private TemplateData data = null;

    static {
        templateByIndex = new HashMap<Integer, Template>();
        templateByName = new HashMap<String, Template>();
        Template[] templateArray = Template.values();
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            int index = template.getIndex();
            String name = template.getName();
            templateByIndex.put(index, template);
            templateByName.put(name, template);
            ++n2;
        }
    }

    private Template(int index, String name, String desc) {
        this.index = index;
        this.name = name;
        this.description = desc;
        this.data = new TemplateData(this);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public TemplateData getData() {
        return this.data;
    }

    public static Template getTemplate(String name) {
        return templateByName.get(name);
    }

    public static Template getTemplate(int templateIndex) {
        return templateByIndex.get(templateIndex);
    }
}

