/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.swap.model.data.hierarchy.elementary;

import java.util.ArrayList;
import java.util.List;
import org.tizen.dynamicanalyzer.communicator.ProtocolParser;
import org.tizen.dynamicanalyzer.protocol.Protocol;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.HierarchyUIObjectProperties;
import org.tizen.dynamicanalyzer.swap.model.data.hierarchy.PropertyValue;
import org.tizen.dynamicanalyzer.util.Logger;

public class ElmColorselectorProperties
extends HierarchyUIObjectProperties {
    private int[] color = new int[4];
    private String paletteName;
    private String mode;

    public ElmColorselectorProperties(Protocol protocolVersion) {
        super(protocolVersion);
    }

    @Override
    public void parsePropertiesFromByte(ProtocolParser parser) {
        this.color[0] = parser.getInt();
        this.color[1] = parser.getInt();
        this.color[2] = parser.getInt();
        this.color[3] = parser.getInt();
        this.paletteName = parser.getString();
        this.mode = this.getModeMessage(parser.getChar());
    }

    @Override
    public List<PropertyValue> getProperties() {
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        properties.add(new PropertyValue("color", "[" + this.color[0] + ", " + this.color[1] + ", " + this.color[2] + "," + this.color[3] + "]"));
        properties.add(new PropertyValue("paletteName", this.paletteName));
        properties.add(new PropertyValue("mode", this.mode));
        return properties;
    }

    private String getModeMessage(int code) {
        switch (code) {
            case 0: {
                return "ELM_COLORSELECTOR_PALETTE";
            }
            case 1: {
                return "ELM_COLORSELECTOR_COMPONENTS";
            }
            case 2: {
                return "ELM_COLORSELECTOR_BOTH";
            }
            case 3: {
                return "ELM_COLORSELECTOR_PICKER";
            }
            case 4: {
                return "ELM_COLORSELECTOR_PLANE";
            }
            case 5: {
                return "ELM_COLORSELECTOR_PALETTE_PLANE";
            }
            case 6: {
                return "ELM_COLORSELECTOR_ALL";
            }
        }
        Logger.warning((Object)("Invalid code : " + code));
        return "-";
    }
}

