/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.control;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.eclipse.swt.widgets.Display;
import org.tizen.dynamicanalyzer.common.AnalyzerManager;
import org.tizen.dynamicanalyzer.common.DAResult;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.common.Global;
import org.tizen.dynamicanalyzer.communicator.DACommunicator;
import org.tizen.dynamicanalyzer.control.ResourceMonitor;
import org.tizen.dynamicanalyzer.handlers.UIActionHolder;
import org.tizen.dynamicanalyzer.nl.AnalyzerLabels;
import org.tizen.dynamicanalyzer.nl.MenuBarLabels;
import org.tizen.dynamicanalyzer.project.Project;
import org.tizen.dynamicanalyzer.shortcut.ShortCutManager;
import org.tizen.dynamicanalyzer.swap.communicator.DataChannelThread;
import org.tizen.dynamicanalyzer.swap.logparser.DataManagerRegistry;
import org.tizen.dynamicanalyzer.swap.logparser.LogParser;
import org.tizen.dynamicanalyzer.swap.logparser.MessageParser;
import org.tizen.dynamicanalyzer.ui.info.screenshot.ScreenshotTimer;
import org.tizen.dynamicanalyzer.ui.page.BaseView;
import org.tizen.dynamicanalyzer.ui.page.MenuBar;
import org.tizen.dynamicanalyzer.ui.page.UpdateViewTimer;
import org.tizen.dynamicanalyzer.ui.timeline.calltrace.CallTraceDataManager;
import org.tizen.dynamicanalyzer.ui.timeline.dlog.DLogDataManager;
import org.tizen.dynamicanalyzer.ui.toolbar.Toolbar;
import org.tizen.dynamicanalyzer.util.Logger;
import org.tizen.dynamicanalyzer.util.WorkbenchUtil;
import org.tizen.dynamicanalyzer.utils.AnalyzerUtil;
import org.tizen.dynamicanalyzer.widgets.da.base.ProgressManager;
import org.tizen.dynamicanalyzer.widgets.progress.ProgressHolder;

public class StopTraceManager
implements Runnable {
    private static final long LSAN_MESSAGE_TIMEOUT = TimeUnit.SECONDS.toNanos(30L);
    private DAResult error;
    private boolean stopFromTarget = false;
    private Thread stopThread = null;

    public StopTraceManager(DAResult err, boolean stopFromTarget) {
        this.error = err;
        this.stopFromTarget = stopFromTarget;
    }

    @Override
    public void run() {
        ProgressHolder progress;
        block37: {
            block34: {
                Throwable throwable2;
                block35: {
                    progress = null;
                    if (Global.isGUIMode()) {
                        progress = ProgressManager.INSTANCE.createProgress(true, 1, "Stop Trace actions", AnalyzerLabels.DLG_PLEASE_WAIT, null);
                    }
                    try {
                        ResourceMonitor.stop();
                        try {
                            if (!this.stopFromTarget) {
                                DACommunicator.stopTrace();
                            }
                        }
                        catch (Exception e) {
                            Logger.error((Object)"Failed : Stop Trace");
                            e.printStackTrace();
                        }
                        if (Global.isGUIMode()) {
                            progress.setValue(2);
                        }
                        Thread stopTimers = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                if (Global.isGUIMode()) {
                                    Toolbar.INSTANCE.stopTimer();
                                }
                                ScreenshotTimer.stop();
                                UpdateViewTimer.stop();
                            }
                        }, "StopTimersThread");
                        stopTimers.start();
                        if (Global.isGUIMode()) {
                            progress.setValue(10);
                        }
                        if (this.error.equals((Object)DAResult.ErrorCode.ERR_BY_USER_CANCEL)) {
                            this.stopThread = new ForcedStopThread();
                        } else {
                            this.stopThread = new NormalStopThread();
                            Project project = Global.getProject();
                            if (project != null && project.isValid()) {
                                if (Global.isGUIMode()) {
                                    project.setTotalStopTime(Toolbar.INSTANCE.getTime());
                                }
                            } else {
                                Logger.error((Object)"project is not valid to save");
                            }
                        }
                        this.stopThread.start();
                        if (Global.isGUIMode()) {
                            progress.setValue(40);
                        }
                        UIActionHolder.getUIAction().applyStopTraceUI();
                        if (Global.isGUIMode()) {
                            progress.setValue(55);
                        }
                        DLogDataManager.getInstance().stopDlog();
                        if (Global.isGUIMode()) {
                            progress.setValue(70);
                        }
                        if (Global.isGUIMode()) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BaseView baseView = (BaseView)WorkbenchUtil.getViewPart((String)BaseView.ID);
                                    baseView.getTopComposite().updateView();
                                }
                            });
                        }
                        break block34;
                    }
                    catch (Throwable throwable2) {
                        if (Global.isGUIMode()) {
                            progress.setValue(90);
                        }
                        this.updateDAState();
                        AnalyzerUtil.getLSanLock().lock();
                        Logger.debug((Object)"LSan locked");
                        if (!Global.isLSanInitialized()) break block35;
                        try {
                            try {
                                long remainedTime = LSAN_MESSAGE_TIMEOUT;
                                Condition cond = AnalyzerUtil.getLSanCondition();
                                while (Global.isLSanInitialized()) {
                                    if (remainedTime <= 0L) {
                                        Logger.warning((Object)"LeakSanitizer message timeout!");
                                    }
                                    remainedTime = cond.awaitNanos(remainedTime);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                Logger.warning((Object)"Interrupted while waiting for message from LeakSanitizer");
                                Global.setLSanInitialized(false);
                                break block35;
                            }
                        }
                        catch (Throwable throwable3) {
                            Global.setLSanInitialized(false);
                            throw throwable3;
                        }
                    }
                    Global.setLSanInitialized(false);
                }
                AnalyzerUtil.getLSanLock().unlock();
                Logger.debug((Object)"LSan unlocked");
                if (Global.isGUIMode()) {
                    progress.setValue(100);
                    ProgressManager.INSTANCE.stopProgress(progress);
                }
                throw throwable2;
            }
            if (Global.isGUIMode()) {
                progress.setValue(90);
            }
            this.updateDAState();
            AnalyzerUtil.getLSanLock().lock();
            Logger.debug((Object)"LSan locked");
            if (Global.isLSanInitialized()) {
                try {
                    try {
                        long remainedTime = LSAN_MESSAGE_TIMEOUT;
                        Condition cond = AnalyzerUtil.getLSanCondition();
                        while (Global.isLSanInitialized()) {
                            if (remainedTime <= 0L) {
                                Logger.warning((Object)"LeakSanitizer message timeout!");
                                break;
                            }
                            remainedTime = cond.awaitNanos(remainedTime);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.warning((Object)"Interrupted while waiting for message from LeakSanitizer");
                        Global.setLSanInitialized(false);
                        break block37;
                    }
                }
                catch (Throwable throwable) {
                    Global.setLSanInitialized(false);
                    throw throwable;
                }
                Global.setLSanInitialized(false);
            }
        }
        AnalyzerUtil.getLSanLock().unlock();
        Logger.debug((Object)"LSan unlocked");
        if (Global.isGUIMode()) {
            progress.setValue(100);
            ProgressManager.INSTANCE.stopProgress(progress);
        }
    }

    private void updateDAState() {
        if (this.stopThread != null) {
            try {
                this.stopThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.stopThread = null;
        }
        DAState.changeCurrentState(DAState.DONE);
        if (Global.isGUIMode()) {
            ShortCutManager.getInstance().setEnabled(true);
            Toolbar.INSTANCE.changeUIState(DAState.getCurrentState());
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_SAVE, true);
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_NEW, true);
                    MenuBar.getInstance().setMenuItemEnable(MenuBarLabels.FILE_LOAD, true);
                    AnalyzerManager.getCurrentPage().updateView();
                }
            });
        }
    }

    private static class ForcedStopThread
    extends Thread {
        public ForcedStopThread() {
            super(ForcedStopThread.class.getSimpleName());
        }

        @Override
        public void run() {
            ProgressHolder stopProgress = null;
            if (Global.isGUIMode()) {
                stopProgress = ProgressManager.INSTANCE.createProgress(true, 1, "Forced stop", AnalyzerLabels.DLG_PLEASE_WAIT, null);
            }
            DataChannelThread.getInstance().stopForced();
            if (stopProgress != null) {
                stopProgress.setValues("Data channel stopped forcibly", 20);
            }
            MessageParser.getInstance().stopForced();
            if (stopProgress != null) {
                stopProgress.setValues("Message parser stopped forcibly", 40);
            }
            LogParser.getInstance().stopForced();
            if (stopProgress != null) {
                stopProgress.setValues("Log parser stopped forcibly", 60);
            }
            DataManagerRegistry.stopThreadsForced();
            if (stopProgress != null) {
                stopProgress.setValues("Page data managers stopped forcibly", 80);
            }
            CallTraceDataManager.getInstance().addCallStackIndexes();
            if (stopProgress != null) {
                stopProgress.setValue(100);
                ProgressManager.INSTANCE.stopProgress(stopProgress);
            }
        }
    }

    private static class NormalStopThread
    extends Thread {
        public NormalStopThread() {
            super(NormalStopThread.class.getSimpleName());
        }

        @Override
        public void run() {
            ProgressHolder stopProgress = null;
            if (Global.isGUIMode()) {
                stopProgress = ProgressManager.INSTANCE.createProgress(true, 1, "Normal stop", AnalyzerLabels.DLG_PLEASE_WAIT, null);
            }
            DataChannelThread.getInstance().stopNormal();
            if (stopProgress != null) {
                stopProgress.setValues("Data channel stopped normally", 20);
            }
            MessageParser.getInstance().stopNormal();
            if (stopProgress != null) {
                stopProgress.setValues("Message parser stopped normally", 40);
            }
            LogParser.getInstance().stopNormal();
            if (stopProgress != null) {
                stopProgress.setValues("Log parser stopped normally", 60);
            }
            DataManagerRegistry.stopThreadsNormal();
            if (stopProgress != null) {
                stopProgress.setValues("Page data managers stopped normally", 80);
            }
            CallTraceDataManager.getInstance().addCallStackIndexes();
            if (stopProgress != null) {
                stopProgress.setValue(100);
                ProgressManager.INSTANCE.stopProgress(stopProgress);
            }
        }
    }
}

