/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.database.compatible;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tizen.dynamicanalyzer.database.SqlConnectionManager;
import org.tizen.dynamicanalyzer.database.compatible.IConvert;
import org.tizen.dynamicanalyzer.database.compatible.SubConverter10to20Earlier;
import org.tizen.dynamicanalyzer.database.compatible.SubConverter10to20Later;
import org.tizen.dynamicanalyzer.project.ProjectVersion;
import org.tizen.dynamicanalyzer.util.Logger;

public class DBConverter
implements IConvert {
    private ProjectVersion version;
    private Set<String> tables = new HashSet<String>();
    private Map<String, Set<String>> columns = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> indexColumns = new HashMap<String, Set<String>>();

    public DBConverter(ProjectVersion version) {
        this.version = version;
    }

    public boolean convert() {
        boolean ret = true;
        switch (this.version) {
            case VERSION_10: {
                if (new SubConverter10to20Earlier(this).convert() && new SubConverter10to20Later(this).convert()) break;
                ret = false;
                break;
            }
            case VERSION_20: {
                break;
            }
            case VERSION_UNKNOWN: {
                Logger.warning((Object)"Converting failed : unknown version of project");
                ret = false;
            }
        }
        return ret;
    }

    private void queryTableList() {
        this.tables.clear();
        ResultSet rs = SqlConnectionManager.executeQueryRS("select table_name from information_schema.tables where table_schema='PUBLIC' order by table_name");
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        this.tables.add(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
    }

    private void queryColumnList() {
        this.columns.clear();
        ResultSet rs = SqlConnectionManager.executeQueryRS("select table_name, column_name from information_schema.columns where table_schema='PUBLIC' order by table_name, ordinal_position");
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        String tableName = rs.getString(1);
                        String columnName = rs.getString(2);
                        Set<String> columnSet = this.columns.get(tableName);
                        if (columnSet == null) {
                            columnSet = new HashSet<String>();
                            this.columns.put(tableName, columnSet);
                        }
                        columnSet.add(columnName);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
    }

    private void queryIndexColumList() {
        this.indexColumns.clear();
        ResultSet rs = SqlConnectionManager.executeQueryRS("select table_name, column_name from information_schema.system_indexinfo where table_schem='PUBLIC' order by table_name");
        if (rs != null) {
            try {
                try {
                    while (rs.next()) {
                        String tableName = rs.getString(1);
                        String columnName = rs.getString(2);
                        Set<String> columnForIndex = this.indexColumns.get(tableName);
                        if (columnForIndex == null) {
                            columnForIndex = new HashSet<String>();
                            this.indexColumns.put(tableName, columnForIndex);
                        }
                        columnForIndex.add(columnName);
                    }
                }
                catch (SQLException e) {
                    Logger.exception((Throwable)e);
                    SqlConnectionManager.releaseResultSet(rs);
                }
            }
            finally {
                SqlConnectionManager.releaseResultSet(rs);
            }
        }
    }

    @Override
    public void init() {
        this.queryTableList();
        this.queryColumnList();
    }

    @Override
    public Set<String> getTables() {
        return Collections.unmodifiableSet(this.tables);
    }

    @Override
    public Set<String> getColumns(String tableName) {
        Set<String> columnList = this.columns.get(tableName);
        if (columnList != null) {
            return Collections.unmodifiableSet(columnList);
        }
        return null;
    }

    @Override
    public Set<String> getIndexColumns(String tableName) {
        Set<String> columnList = this.indexColumns.get(tableName);
        if (columnList != null) {
            return Collections.unmodifiableSet(columnList);
        }
        return null;
    }

    @Override
    public boolean renameColumn(String tableName, String from, String to) {
        String query = String.format("alter table %s alter column %s rename to %s", tableName, from, to);
        return SqlConnectionManager.executeUpdate(query);
    }

    @Override
    public boolean renameTable(String from, String to) {
        String query = String.format("alter table %s rename to %s", from, to);
        return SqlConnectionManager.executeUpdate(query);
    }

    @Override
    public boolean addIndex(String tableName, String[] columnList) {
        StringBuffer columns = new StringBuffer();
        int i = 0;
        while (i < columnList.length) {
            if (i != 0) {
                columns.append(", ");
            }
            columns.append(columnList[i]);
            ++i;
        }
        String query = String.format("create index %s_index on %s (%s)", tableName, tableName, columns.toString());
        return SqlConnectionManager.executeUpdate(query);
    }

    @Override
    public boolean dropIndex(String tableName, String indexName) {
        String query = String.format("drop index %s", indexName);
        return SqlConnectionManager.executeUpdate(query);
    }

    @Override
    public boolean changeType(String tableName, String columnName, String type) {
        String query = String.format("alter table %s alter column %s set data type %s", tableName, columnName, type);
        return SqlConnectionManager.executeUpdate(query);
    }

    @Override
    public boolean addColumn(String tableName, String columnName, String type, String defaultValue, String option) {
        String query = String.format("alter table %s add column %s %s default '%s' %s", tableName, columnName, type, defaultValue, option);
        return SqlConnectionManager.executeUpdate(query);
    }

    @Override
    public boolean dropColumn(String tableName, String columnName) {
        String query = String.format("alter table %s drop column %s cascade", tableName, columnName);
        return SqlConnectionManager.executeUpdate(query);
    }

    @Override
    public boolean createTable(String tableName) {
        return true;
    }
}

