/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.ui.hierarchy.tree.overview;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.dynamicanalyzer.common.DASelectionData;
import org.tizen.dynamicanalyzer.nl.UIHierarchyPageLabels;
import org.tizen.dynamicanalyzer.resources.ColorResources;
import org.tizen.dynamicanalyzer.ui.hierarchy.HierarchyViewCommunication;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.HierarchyTreeView;
import org.tizen.dynamicanalyzer.ui.hierarchy.tree.overview.HierarchyTreeOverViewFigure;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewComposite;
import org.tizen.dynamicanalyzer.widgets.da.view.DAViewData;

public class HierarchyTreeOverView
extends DAViewComposite {
    private HierarchyTreeOverViewFigure overviewFigure;

    public HierarchyTreeOverView(Composite parent, int style, HierarchyTreeView sourceView) {
        super(parent, style, true);
        this.setLayout((Layout)new FillLayout());
        this.setTitle(UIHierarchyPageLabels.UIHIERARCHY_OVERVIEW_TITLE);
        Composite contents = this.getContentArea();
        contents.setLayout((Layout)new FillLayout());
        Canvas canvas = new Canvas(contents, 0x20000800);
        canvas.setBackground(ColorResources.TREEVIEW_BG);
        this.overviewFigure = new HierarchyTreeOverViewFigure(contents);
        this.overviewFigure.setViewport(sourceView.getFigureCanvas().getViewport());
        this.overviewFigure.setSource((IFigure)sourceView.getTreeLayer());
        LightweightSystem overviewLWS = new LightweightSystem(canvas);
        overviewLWS.setContents((IFigure)this.overviewFigure);
    }

    public void updateView(DAViewData data) {
        if (data instanceof DASelectionData && data.getData() instanceof HierarchyViewCommunication) {
            HierarchyViewCommunication param = (HierarchyViewCommunication)data.getData();
            switch (param.getAction()) {
                case NODE_SELECT: 
                case NODE_UNSELECT: 
                case TREE_RESTRUCT: 
                case TREE_ZOOM: 
                case NODE_SEARCH: {
                    this.overviewFigure.repaint();
                    break;
                }
            }
        }
    }
}

