/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.formatter.AbortFormatting;
import org.eclipse.cdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.cdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCodeFormatter
extends CodeFormatter {
    private DefaultCodeFormatterOptions preferences;
    private Map<String, ?> options;

    public CCodeFormatter() {
        this(DefaultCodeFormatterOptions.getDefaultSettings());
    }

    public CCodeFormatter(DefaultCodeFormatterOptions preferences) {
        this(preferences, null);
    }

    public CCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, ?> options) {
        this.setOptions(options);
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public CCodeFormatter(Map<String, ?> options) {
        this(null, options);
    }

    @Override
    public String createIndentationString(int indentationLevel) {
        if (indentationLevel < 0) {
            throw new IllegalArgumentException();
        }
        int tabs = 0;
        int spaces = 0;
        switch (this.preferences.tab_char) {
            case 2: {
                spaces = indentationLevel * this.preferences.tab_size;
                break;
            }
            case 1: {
                tabs = indentationLevel;
                break;
            }
            case 4: {
                int tabSize = this.preferences.tab_size;
                int spaceEquivalents = indentationLevel * this.preferences.indentation_size;
                tabs = spaceEquivalents / tabSize;
                spaces = spaceEquivalents % tabSize;
                break;
            }
            default: {
                return "";
            }
        }
        if (tabs == 0 && spaces == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(tabs + spaces);
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public void setOptions(Map<String, ?> options) {
        if (options != null) {
            this.options = options;
            HashMap<String, String> formatterPrefs = new HashMap<String, String>(options.size());
            for (String key : options.keySet()) {
                Object value = options.get(key);
                if (!(value instanceof String)) continue;
                formatterPrefs.put(key, (String)value);
            }
            this.preferences = new DefaultCodeFormatterOptions(formatterPrefs);
        } else {
            this.options = CCorePlugin.getOptions();
            this.preferences = DefaultCodeFormatterOptions.getDefaultSettings();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        IFile file;
        TextEdit edit = null;
        ITranslationUnit tu = (ITranslationUnit)this.options.get("org.eclipse.cdt.core.formatter.current_translation_unit");
        if (tu == null && (file = (IFile)this.options.get("org.eclipse.cdt.core.formatter.current_file")) != null) {
            tu = (ITranslationUnit)CoreModel.getDefault().create(file);
        }
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        this.preferences.initial_indentation_level = indentationLevel;
        if (tu != null) {
            IIndex index;
            try {
                index = CCorePlugin.getIndexManager().getIndex(tu.getCProject());
                index.acquireReadLock();
            }
            catch (CoreException e) {
                throw new AbortFormatting(e);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            try {
                IASTTranslationUnit ast;
                try {
                    ast = tu.getAST(index, 6);
                }
                catch (CoreException exc) {
                    throw new AbortFormatting(exc);
                }
                CodeFormatterVisitor codeFormatter = new CodeFormatterVisitor(this.preferences, offset, length);
                edit = codeFormatter.format(source, ast);
                IStatus status = codeFormatter.getStatus();
                if (status.isOK()) return edit;
                CCorePlugin.log(status);
                return edit;
            }
            finally {
                index.releaseReadLock();
            }
        }
        IncludeFileContentProvider contentProvider = IncludeFileContentProvider.getSavedFilesProvider();
        ScannerInfo scanInfo = new ScannerInfo();
        FileContent content = FileContent.create("<text>", source.toCharArray());
        ILanguage language = (ILanguage)this.options.get("org.eclipse.cdt.core.formatter.language");
        if (language == null) {
            language = GPPLanguage.getDefault();
        }
        try {
            IASTTranslationUnit ast = language.getASTTranslationUnit(content, (IScannerInfo)scanInfo, contentProvider, null, 0, ParserUtil.getParserLogService());
            CodeFormatterVisitor codeFormatter = new CodeFormatterVisitor(this.preferences, offset, length);
            edit = codeFormatter.format(source, ast);
            IStatus status = codeFormatter.getStatus();
            if (status.isOK()) return edit;
            CCorePlugin.log(status);
            return edit;
        }
        catch (CoreException e) {
            throw new AbortFormatting(e);
        }
    }
}

