/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.dynamicanalyzer.cli.utils;

import java.io.IOException;
import org.tizen.dynamicanalyzer.cli.tracing.TracingProcess;
import org.tizen.dynamicanalyzer.cli.utils.Communicator;
import org.tizen.dynamicanalyzer.cli.utils.Message;
import org.tizen.dynamicanalyzer.common.DAState;
import org.tizen.dynamicanalyzer.util.Logger;

public class ProcessCommunicationProcessor
implements Runnable {
    private Communicator comm;
    private TracingProcess process;

    public ProcessCommunicationProcessor(Communicator comm, TracingProcess process) {
        this.comm = comm;
        this.process = process;
    }

    @Override
    public void run() {
        block12: while (true) {
            Message message;
            if ((message = this.comm.getMessage()) == null) break;
            switch (message.getMessageType()) {
                case RESPONSE__STOP_DONE: 
                case RESPONSE__TRACING_TIME: 
                case RESPONSE__ALIVE: 
                case SIGNAL__ERROR_OCCURED: {
                    Logger.error((Object)"Wrong message for Process");
                    continue block12;
                }
                case REQUEST__STOP_TRACING: {
                    this.process.stopTrace();
                    try {
                        this.comm.sendMessage(message.getTid(), Message.MessageType.RESPONSE__STOP_DONE, new String[0]);
                    }
                    catch (IOException e) {
                        Logger.error((Object)e);
                    }
                    continue block12;
                }
                case REQUEST__TRACING_TIME: {
                    long time = this.process.getTracingTime();
                    try {
                        this.comm.sendMessage(message.getTid(), Message.MessageType.RESPONSE__TRACING_TIME, Long.toString(time));
                    }
                    catch (IOException e) {
                        Logger.error((Object)e);
                    }
                    continue block12;
                }
                case REQUEST__IS_ALIVE: {
                    try {
                        Logger.debug((Object)"REQUEST__IS_ALIVE message got");
                        Logger.debug((Object)("TID = " + message.getTid()));
                        Logger.debug((Object)("DAState is " + DAState.getCurrentState()));
                        DAState.waitRunning();
                        if (DAState.isRunning()) {
                            this.comm.sendMessage(message.getTid(), Message.MessageType.RESPONSE__ALIVE, new String[0]);
                            Logger.debug((Object)"RESPONSE__ALIVE message sent");
                        }
                        Logger.debug((Object)("New DAState is " + DAState.getCurrentState()));
                    }
                    catch (Exception e) {
                        Logger.error((Object)e);
                    }
                    continue block12;
                }
            }
            Logger.error((Object)"Unknown message type.");
        }
        Logger.debug((Object)"Communication stopped");
    }

    public void errorOccured(int errNum) {
        try {
            this.comm.sendMessage(0L, Message.MessageType.SIGNAL__ERROR_OCCURED, Integer.toString(errNum));
        }
        catch (IOException e) {
            Logger.error((Object)e);
        }
    }
}

